/*
 * Decompiled with CFR 0.152.
 */
package Jama;

import Jama.LUDecomposition;
import Jama.QRDecomposition;
import java.io.Serializable;

public class Matrix
implements Cloneable,
Serializable {
    private double[][] A;
    private int m;
    private int n;

    public Matrix(int n, int n2) {
        this.m = n;
        this.n = n2;
        this.A = new double[n][n2];
    }

    public Matrix(double[][] dArray, int n, int n2) {
        this.A = dArray;
        this.m = n;
        this.n = n2;
    }

    public Matrix copy() {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = this.A[i][j];
            }
        }
        return matrix;
    }

    public Object clone() {
        return this.copy();
    }

    public double[][] getArray() {
        return this.A;
    }

    public double[][] getArrayCopy() {
        double[][] dArray = new double[this.m][this.n];
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = this.A[i][j];
            }
        }
        return dArray;
    }

    public double[] getColumnPackedCopy() {
        double[] dArray = new double[this.m * this.n];
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i + j * this.m] = this.A[i][j];
            }
        }
        return dArray;
    }

    public int getRowDimension() {
        return this.m;
    }

    public int getColumnDimension() {
        return this.n;
    }

    public Matrix getMatrix(int n, int n2, int n3, int n4) {
        Matrix matrix = new Matrix(n2 - n + 1, n4 - n3 + 1);
        double[][] dArray = matrix.getArray();
        try {
            for (int i = n; i <= n2; ++i) {
                for (int j = n3; j <= n4; ++j) {
                    dArray[i - n][j - n3] = this.A[i][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public Matrix getMatrix(int[] nArray, int n, int n2) {
        Matrix matrix = new Matrix(nArray.length, n2 - n + 1);
        double[][] dArray = matrix.getArray();
        try {
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = n; j <= n2; ++j) {
                    dArray[i][j - n] = this.A[nArray[i]][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public void set(int n, int n2, double d) {
        this.A[n][n2] = d;
    }

    public Matrix solve(Matrix matrix) {
        return this.m == this.n ? new LUDecomposition(this).solve(matrix) : new QRDecomposition(this).solve(matrix);
    }
}

