/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math;

import java.util.Random;

public class MathUtil {
    private static final Random random = new Random(System.currentTimeMillis());

    public static int getSign(double d) {
        if (d != 0.0 && !Double.isNaN(d) && !Double.isInfinite(d)) {
            return (int)(Math.abs(d) / d);
        }
        return 1;
    }

    public static boolean isApproxEqual(double d, double d2, double d3) {
        return Math.abs(d - d2) < d3;
    }

    public static double clamp(double d, double d2, double d3) {
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3)) {
            return Double.NaN;
        }
        if (d2 < d) {
            return d;
        }
        if (d2 > d3) {
            return d3;
        }
        return d2;
    }
}

