/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.model.clock;

import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ClockListener;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.model.clock.TimingStrategy;
import java.util.ArrayList;

public abstract class Clock
implements IClock {
    private ArrayList listeners = new ArrayList();
    private TimingStrategy timingStrategy;
    private double lastSimulationTime = 0.0;
    private double simulationTime = 0.0;
    private long lastWallTime = 0L;
    private long wallTime = 0L;

    public Clock(TimingStrategy timingStrategy) {
        this.timingStrategy = timingStrategy;
    }

    public void addClockListener(ClockListener clockListener) {
        this.listeners.add(clockListener);
    }

    protected void tick(double d) {
        this.lastWallTime = this.wallTime;
        this.wallTime = System.currentTimeMillis();
        this.setSimulationTimeNoUpdate(this.simulationTime + d);
        this.notifyClockTicked();
        this.testNotifySimulationTimeChange();
    }

    protected void doTick() {
        this.tick(this.timingStrategy.getSimulationTimeChange(this.lastWallTime, this.wallTime));
    }

    public void stepClockWhilePaused() {
        this.tick(this.timingStrategy.getSimulationTimeChangeForPausedClock());
    }

    private void setSimulationTimeNoUpdate(double d) {
        this.lastSimulationTime = this.simulationTime;
        this.simulationTime = d;
    }

    public double getSimulationTimeChange() {
        return this.simulationTime - this.lastSimulationTime;
    }

    public TimingStrategy getTimingStrategy() {
        return this.timingStrategy;
    }

    public void setTimingStrategy(TimingStrategy timingStrategy) {
        this.timingStrategy = timingStrategy;
    }

    protected void notifyClockTicked() {
        ClockEvent clockEvent = new ClockEvent(this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ClockListener clockListener = (ClockListener)this.listeners.get(i);
            clockListener.clockTicked(clockEvent);
        }
    }

    protected void notifyClockPaused() {
        ClockEvent clockEvent = new ClockEvent(this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ClockListener clockListener = (ClockListener)this.listeners.get(i);
            clockListener.clockPaused(clockEvent);
        }
    }

    protected void notifyClockStarted() {
        ClockEvent clockEvent = new ClockEvent(this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ClockListener clockListener = (ClockListener)this.listeners.get(i);
            clockListener.clockStarted(clockEvent);
        }
    }

    private void testNotifySimulationTimeChange() {
        if (this.getSimulationTimeChange() != 0.0) {
            this.notifySimulationTimeChanged();
        }
    }

    protected void notifySimulationTimeChanged() {
        ClockEvent clockEvent = new ClockEvent(this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ClockListener clockListener = (ClockListener)this.listeners.get(i);
            clockListener.simulationTimeChanged(clockEvent);
        }
    }
}

