/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.util.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class PersistenceUtil {
    public static Serializable copy(Serializable serializable) throws CopyFailedException {
        return PersistenceUtil.copy(serializable, null);
    }

    public static Serializable copy(Serializable serializable, CopyObjectReplacementStrategy copyObjectReplacementStrategy) throws CopyFailedException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = copyObjectReplacementStrategy == null ? new ObjectOutputStream(byteArrayOutputStream) : new MyObjectOutputStream(byteArrayOutputStream, copyObjectReplacementStrategy);
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return (Serializable)new ObjectInputStream(byteArrayInputStream).readObject();
        }
        catch (IOException iOException) {
            throw new CopyFailedException(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CopyFailedException(classNotFoundException);
        }
    }

    public static class CopyFailedException
    extends Exception {
        public CopyFailedException(Throwable throwable) {
            super(throwable);
        }
    }

    private static class MyObjectOutputStream
    extends ObjectOutputStream {
        private CopyObjectReplacementStrategy copyObjectReplacementStrategy;

        public MyObjectOutputStream(OutputStream outputStream, CopyObjectReplacementStrategy copyObjectReplacementStrategy) throws IOException {
            super(outputStream);
            this.copyObjectReplacementStrategy = copyObjectReplacementStrategy;
        }

        protected Object replaceObject(Object object) throws IOException {
            return this.copyObjectReplacementStrategy.replaceObject(object);
        }
    }

    public static interface CopyObjectReplacementStrategy {
        public Object replaceObject(Object var1);
    }
}

