/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.util;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class SwingUtils {
    private SwingUtils() {
    }

    public static JMenuBar addMenuAt(JMenu jMenu, JMenuBar jMenuBar, int n) {
        int n2;
        ArrayList<JMenu> arrayList = new ArrayList<JMenu>();
        for (n2 = 0; n2 < jMenuBar.getMenuCount(); ++n2) {
            if (n2 == n) {
                arrayList.add(jMenu);
            }
            arrayList.add(jMenuBar.getMenu(n2));
        }
        jMenuBar.removeAll();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            JMenu jMenu2 = (JMenu)arrayList.get(n2);
            jMenuBar.add(jMenu2);
        }
        return jMenuBar;
    }

    public static GridBagConstraints getGridBagConstraints(int n, int n2, int n3, int n4, int n5, int n6) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.fill = n5;
        gridBagConstraints.anchor = n6;
        return gridBagConstraints;
    }

    public static void addGridBagComponent(Container container, Component component, int n, int n2, int n3, int n4, int n5, int n6) throws AWTException {
        SwingUtils.addGridBagComponent(container, component, n, n2, n3, n4, n5, n6, new Insets(0, 0, 0, 0));
    }

    public static void addGridBagComponent(Container container, Component component, int n, int n2, int n3, int n4, int n5, int n6, Insets insets) throws AWTException {
        LayoutManager layoutManager = container.getLayout();
        if (!(layoutManager instanceof GridBagLayout)) {
            throw new AWTException("Invalid layout: " + layoutManager);
        }
        GridBagConstraints gridBagConstraints = SwingUtils.getGridBagConstraints(n, n2, n3, n4, n5, n6);
        gridBagConstraints.insets = insets;
        ((GridBagLayout)layoutManager).setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    public static void centerWindowOnScreen(Window window) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        window.setLocation((int)(dimension.getWidth() / 2.0 - (double)(window.getWidth() / 2)), (int)(dimension.getHeight() / 2.0 - (double)(window.getHeight() / 2)));
    }

    public static void centerDialogInParent(JDialog jDialog) {
        Rectangle rectangle = jDialog.getParent().getBounds();
        Rectangle rectangle2 = new Rectangle((int)(rectangle.getMinX() + rectangle.getWidth() / 2.0 - (double)(jDialog.getWidth() / 2)), (int)(rectangle.getMinY() + rectangle.getHeight() / 2.0 - (double)(jDialog.getHeight() / 2)), jDialog.getWidth(), jDialog.getHeight());
        jDialog.setBounds(rectangle2);
    }

    public static void fixButtonOpacity(JButton jButton) {
        if (!(UIManager.getLookAndFeel() instanceof MetalLookAndFeel)) {
            jButton.setOpaque(false);
        }
    }

    public static Dimension getMaxDimension(JButton jButton, String string, ImageIcon imageIcon, String string2, ImageIcon imageIcon2) {
        jButton.setText(string);
        jButton.setIcon(imageIcon);
        Dimension dimension = jButton.getUI().getPreferredSize(jButton);
        jButton.setText(string2);
        jButton.setIcon(imageIcon2);
        Dimension dimension2 = jButton.getUI().getPreferredSize(jButton);
        int n = (int)Math.max(dimension.getWidth(), dimension2.getWidth());
        int n2 = (int)Math.max(dimension.getHeight(), dimension2.getHeight());
        return new Dimension(n, n2);
    }
}

