/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet;

import edu.colorado.phet.common.piccolophet.PhetRootPNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;

public class PhetPCanvas
extends PSwingCanvas {
    private TransformStrategy transformStrategy;
    private ComponentAdapter resizeAdapter;
    private PhetRootPNode phetRootNode;
    private AffineTransform transform;

    public PhetPCanvas() {
        this(new ConstantTransformStrategy(new AffineTransform()));
    }

    public PhetPCanvas(Rectangle2D rectangle2D) {
        this(new ConstantTransformStrategy(new AffineTransform()));
        this.setTransformStrategy(new ViewportStrategy(this, rectangle2D));
    }

    public PhetPCanvas(TransformStrategy transformStrategy) {
        this.transformStrategy = transformStrategy;
        this.phetRootNode = new PhetRootPNode();
        this.getLayer().addChild(this.phetRootNode);
        this.removeInputEventListener(this.getZoomEventHandler());
        this.removeInputEventListener(this.getPanEventHandler());
        this.resizeAdapter = new ResizeAdapter();
        this.addComponentListener(this.resizeAdapter);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                PhetPCanvas.this.requestFocus();
            }
        });
        this.setOpaque(true);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.requestFocus();
    }

    public void setTransformStrategy(TransformStrategy transformStrategy) {
        this.transformStrategy = transformStrategy;
        this.updateScale();
    }

    protected void updateScale() {
        this.phetRootNode.setWorldTransform(this.transformStrategy.getWorldTransform());
    }

    public PhetRootPNode getPhetRootNode() {
        return this.phetRootNode;
    }

    public void setPhetRootNode(PhetRootPNode phetRootPNode) {
        if (this.phetRootNode != null) {
            this.getLayer().removeChild(this.phetRootNode);
        }
        this.phetRootNode = phetRootPNode;
        this.getLayer().addChild(this.phetRootNode);
    }

    public void addScreenChild(PNode pNode) {
        this.phetRootNode.addScreenChild(pNode);
    }

    public void paintComponent(Graphics graphics) {
        this.transform = ((Graphics2D)graphics).getTransform();
        super.paintComponent(graphics);
    }

    public void removeActivity(PActivity pActivity) {
        this.getRoot().getActivityScheduler().removeActivity(pActivity);
    }

    public static class ViewportStrategy
    implements TransformStrategy {
        private Rectangle2D modelViewport;
        private PhetPCanvas phetPCanvas;

        public ViewportStrategy(PhetPCanvas phetPCanvas, Rectangle2D rectangle2D) {
            this.phetPCanvas = phetPCanvas;
            this.modelViewport = rectangle2D;
        }

        protected double getScaleY() {
            return (double)this.phetPCanvas.getHeight() / this.modelViewport.getHeight();
        }

        protected double getScaleX() {
            return (double)this.phetPCanvas.getWidth() / this.modelViewport.getWidth();
        }

        public AffineTransform getWorldTransform() {
            double d;
            double d2;
            double d3 = this.getScaleX();
            double d4 = d2 = d3 < (d = this.getScaleY()) ? d3 : d;
            if (d2 < 0.0) {
                System.err.println(this.getClass().getName() + ": Warning: Sometimes in 1.5, sometimes getWidth() and getHeight() return negative values, causing troubles for this layout code.");
            }
            if (d2 != 0.0) {
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(0.0, this.phetPCanvas.getHeight());
                affineTransform.scale(d2, -d2);
                affineTransform.translate(this.modelViewport.getX(), -this.modelViewport.getY());
                return affineTransform;
            }
            return new AffineTransform();
        }
    }

    public static class ConstantTransformStrategy
    implements TransformStrategy {
        private AffineTransform affineTransform;

        public ConstantTransformStrategy(AffineTransform affineTransform) {
            this.affineTransform = affineTransform;
        }

        public AffineTransform getWorldTransform() {
            return new AffineTransform(this.affineTransform);
        }
    }

    public static interface TransformStrategy {
        public AffineTransform getWorldTransform();
    }

    protected class ResizeAdapter
    extends ComponentAdapter {
        protected ResizeAdapter() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            PhetPCanvas.this.updateScale();
        }

        public void componentShown(ComponentEvent componentEvent) {
            PhetPCanvas.this.updateScale();
        }
    }
}

