/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet;

import edu.umd.cs.piccolo.PNode;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

public class PhetRootPNode
extends PNode {
    private PNode worldNode = new PNode();
    private PNode screenNode = new PNode();

    public int indexOfChild(PNode pNode) {
        int n = super.indexOfChild(pNode);
        if (n >= 0) {
            return n;
        }
        n = super.indexOfChild(new WorldChild(pNode));
        if (n >= 0) {
            return n;
        }
        n = super.indexOfChild(new ScreenChild(pNode));
        if (n >= 0) {
            return n;
        }
        return -1;
    }

    public void addScreenChild(PNode pNode) {
        ScreenChild screenChild = new ScreenChild(pNode);
        screenChild.setTransform(this.screenNode.getTransform());
        this.addChild(screenChild);
    }

    public void removeScreenChild(PNode pNode) {
        int n = super.indexOfChild(new ScreenChild(pNode));
        if (n >= 0) {
            this.removeChild(n);
        }
    }

    public void addWorldChild(PNode pNode) {
        WorldChild worldChild = new WorldChild(pNode);
        worldChild.setTransform(this.worldNode.getTransform());
        this.addChild(worldChild);
    }

    private ArrayList getChildren(Class clazz) {
        ArrayList<PNode> arrayList = new ArrayList<PNode>();
        for (int i = 0; i < this.getChildrenCount(); ++i) {
            PNode pNode = this.getChild(i);
            if (!clazz.isAssignableFrom(pNode.getClass())) continue;
            arrayList.add(pNode);
        }
        return arrayList;
    }

    public void translateWorld(double d, double d2) {
        this.worldNode.translate(d, d2);
        this.updateWorldNodes();
    }

    public void scaleWorldAboutPoint(double d, Point2D point2D) {
        this.worldNode.scaleAboutPoint(d, point2D);
        this.updateWorldNodes();
    }

    private ArrayList getWorldChildren() {
        return this.getChildren(WorldChild.class);
    }

    public void setWorldTransform(AffineTransform affineTransform) {
        this.worldNode.setTransform(affineTransform);
        this.updateWorldNodes();
    }

    protected void updateWorldNodes() {
        ArrayList arrayList = this.getWorldChildren();
        for (int i = 0; i < arrayList.size(); ++i) {
            PNode pNode = (PNode)arrayList.get(i);
            pNode.setTransform(this.worldNode.getTransformReference(true));
        }
    }

    public void globalToScreen(Rectangle2D rectangle2D) {
        this.screenNode.globalToLocal(rectangle2D);
    }

    public void globalToWorld(Point2D point2D) {
        this.worldNode.globalToLocal(point2D);
    }

    public void worldToScreen(Rectangle2D rectangle2D) {
        this.worldNode.localToGlobal(rectangle2D);
        this.screenNode.globalToLocal(rectangle2D);
    }

    public void worldToScreen(Point2D point2D) {
        this.worldNode.localToGlobal(point2D);
        this.screenNode.globalToLocal(point2D);
    }

    public void screenToWorld(Point2D point2D) {
        this.screenNode.localToGlobal(point2D);
        this.worldNode.globalToLocal(point2D);
    }

    public void screenToWorld(Dimension2D dimension2D) {
        this.screenNode.localToGlobal(dimension2D);
        this.worldNode.globalToLocal(dimension2D);
    }

    public void addWorldTransformListener(PropertyChangeListener propertyChangeListener) {
        this.worldNode.addPropertyChangeListener("transform", propertyChangeListener);
    }

    private static class WorldChild
    extends WrapperNode {
        public WorldChild(PNode pNode) {
            super(pNode);
        }
    }

    private static class ScreenChild
    extends WrapperNode {
        public ScreenChild(PNode pNode) {
            super(pNode);
        }
    }

    private static class WrapperNode
    extends PNode {
        private PNode node;

        public WrapperNode(PNode pNode) {
            this.node = pNode;
            this.addChild(pNode);
        }

        public boolean equals(Object object) {
            return object instanceof WrapperNode && ((WrapperNode)object).node == this.node;
        }
    }
}

