/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.event;

import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.umd.cs.piccolo.activities.PActivity;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Point2D;

public class PanZoomWorldKeyHandler
implements KeyListener {
    private PhetPCanvas phetPCanvas;
    private int translateDX = 7;
    private double zoomScale = 1.1;
    private PanEvent panRight;
    private PanEvent panLeft;
    private PanEvent panUp;
    private PanEvent panDown;
    private ZoomEvent zoomIn;
    private ZoomEvent zoomOut;

    public PanZoomWorldKeyHandler(PhetPCanvas phetPCanvas) {
        this.phetPCanvas = phetPCanvas;
        this.panRight = new PanEvent(-this.translateDX, 0);
        this.panLeft = new PanEvent(this.translateDX, 0);
        this.panUp = new PanEvent(0, this.translateDX);
        this.panDown = new PanEvent(0, -this.translateDX);
        this.zoomIn = new ZoomEvent(this.zoomScale);
        this.zoomOut = new ZoomEvent(1.0 / this.zoomScale);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isShiftDown()) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.zoomIn.start();
                    break;
                }
                case 40: {
                    this.zoomOut.start();
                    break;
                }
            }
        }
        switch (keyEvent.getKeyCode()) {
            case 102: {
                this.panRight.start();
                break;
            }
            case 100: {
                this.panLeft.start();
                break;
            }
            case 104: {
                this.panUp.start();
                break;
            }
            case 101: {
                this.panDown.start();
                break;
            }
            case 33: {
                this.zoomIn.start();
                break;
            }
            case 34: {
                this.zoomOut.start();
                break;
            }
        }
    }

    private void zoomWorld(double d) {
        Point2D point2D = this.phetPCanvas.getCamera().getBounds().getCenter2D();
        this.phetPCanvas.getCamera().localToGlobal(point2D);
        this.phetPCanvas.getPhetRootNode().globalToWorld(point2D);
        this.phetPCanvas.getPhetRootNode().scaleWorldAboutPoint(d, point2D);
    }

    private void translateWorld(int n, int n2) {
        this.phetPCanvas.getPhetRootNode().translateWorld(n, n2);
    }

    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 102: {
                this.panRight.stop();
                break;
            }
            case 100: {
                this.panLeft.stop();
                break;
            }
            case 104: {
                this.panUp.stop();
                this.zoomIn.stop();
                break;
            }
            case 101: {
                this.panDown.stop();
                this.zoomOut.stop();
                break;
            }
            case 33: {
                this.zoomIn.stop();
                break;
            }
            case 34: {
                this.zoomOut.stop();
                break;
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private class ZoomEvent
    extends PanZoomActivity {
        private double scale;

        public ZoomEvent(double d) {
            this.scale = d;
        }

        protected void activityStep(long l) {
            super.activityStep(l);
            PanZoomWorldKeyHandler.this.zoomWorld(this.scale);
        }
    }

    private class PanEvent
    extends PanZoomActivity {
        private int dx;
        private int dy;

        public PanEvent(int n, int n2) {
            this.dx = n;
            this.dy = n2;
        }

        protected void activityStep(long l) {
            super.activityStep(l);
            PanZoomWorldKeyHandler.this.translateWorld(this.dx, this.dy);
        }
    }

    private class PanZoomActivity
    extends PActivity {
        public PanZoomActivity() {
            super(-1L);
        }

        public void start() {
            if (!PanZoomWorldKeyHandler.this.phetPCanvas.getRoot().getActivityScheduler().getActivitiesReference().contains(this)) {
                PanZoomWorldKeyHandler.this.phetPCanvas.getRoot().addActivity(this);
            }
        }

        public void stop() {
            while (PanZoomWorldKeyHandler.this.phetPCanvas.getRoot().getActivityScheduler().getActivitiesReference().contains(this)) {
                PanZoomWorldKeyHandler.this.phetPCanvas.removeActivity(this);
            }
        }
    }
}

