/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.help;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PAffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class AbstractHelpItem
extends PNode {
    private JComponent _helpPane;
    private IFollower _follower;
    private boolean _enabled;

    public AbstractHelpItem(JComponent jComponent) {
        this._helpPane = jComponent;
        this.setEnabled(false);
    }

    public void updatePosition() {
        if (this._follower != null) {
            this._follower.updatePosition();
        }
    }

    public void setEnabled(boolean bl) {
        this._enabled = bl;
        if (this._follower != null) {
            this._follower.setFollowEnabled(bl);
        } else {
            this.setVisible(bl);
        }
        if (!bl) {
            this.setVisible(false);
        }
    }

    public static boolean isNodeVisible(PNode pNode) {
        boolean bl = pNode.getVisible();
        PNode pNode2 = pNode;
        while (bl && pNode2 != null) {
            if ((pNode2 = pNode2.getParent()) == null) continue;
            bl = pNode2.getVisible();
        }
        return bl;
    }

    public void pointAt(Point2D point2D) {
        this.setOffset(point2D.getX(), point2D.getY());
    }

    public void pointAt(double d, double d2) {
        this.setOffset(d, d2);
    }

    public void pointAt(PNode pNode, PCanvas pCanvas) {
        if (!pNode.isDescendentOf(pCanvas.getLayer())) {
            throw new IllegalArgumentException("node is not on canvas");
        }
        if (this._follower != null) {
            this._follower.setFollowEnabled(false);
        }
        this._follower = new PNodeFollower(this, pNode, pCanvas);
        this._follower.setFollowEnabled(this._enabled);
    }

    public Point2D mapLocation(PNode pNode, PCanvas pCanvas) {
        int n = 0;
        int n2 = 0;
        Cloneable cloneable = pNode.getFullBounds();
        Rectangle2D rectangle2D = pNode.getParent().localToGlobal((Rectangle2D)cloneable);
        PCamera pCamera = pCanvas.getCamera();
        PAffineTransform pAffineTransform = pCamera.getViewTransformReference();
        Rectangle2D rectangle2D2 = pAffineTransform.transform(rectangle2D, null);
        n = (int)rectangle2D2.getX();
        n2 = (int)rectangle2D2.getY();
        cloneable = SwingUtilities.convertPoint(pCanvas, n, n2, this._helpPane);
        return cloneable;
    }

    private static class PNodeFollower
    implements IFollower,
    PropertyChangeListener {
        private AbstractHelpItem _helpItem;
        private PNode _node;
        private PCanvas _canvas;
        private ArrayList _watchList;

        public PNodeFollower(AbstractHelpItem abstractHelpItem, PNode pNode, PCanvas pCanvas) {
            this._helpItem = abstractHelpItem;
            this._node = pNode;
            this._canvas = pCanvas;
            this._watchList = new ArrayList();
            this.setFollowEnabled(false);
        }

        public void setFollowEnabled(boolean bl) {
            if (bl) {
                this.updateWatchList();
                this.updateVisibility();
                this.updatePosition();
            } else {
                this.clearWatchList();
            }
        }

        public void updateVisibility() {
            boolean bl = AbstractHelpItem.isNodeVisible(this._node);
            this._helpItem.setVisible(bl);
        }

        public void updatePosition() {
            if (this._helpItem.getVisible()) {
                Point2D point2D = this._helpItem.mapLocation(this._node, this._canvas);
                this._helpItem.setOffset(point2D);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("parent".equals(string)) {
                this.updateWatchList();
                this.updateVisibility();
                this.updatePosition();
            } else if ("visible".equals(string)) {
                this.updateVisibility();
                this.updatePosition();
            } else {
                this.updatePosition();
            }
        }

        private void updateWatchList() {
            this.clearWatchList();
            for (PNode pNode = this._node; pNode != null; pNode = pNode.getParent()) {
                pNode.addPropertyChangeListener(this);
                this._watchList.add(pNode);
            }
        }

        private void clearWatchList() {
            Iterator iterator = this._watchList.iterator();
            while (iterator.hasNext()) {
                ((PNode)iterator.next()).removePropertyChangeListener(this);
            }
            this._watchList.clear();
        }
    }

    private static interface IFollower {
        public void setFollowEnabled(boolean var1);

        public void updatePosition();
    }
}

