/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.servicemanager;

import edu.colorado.phet.common.phetcommon.util.DialogUtils;
import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common.servicemanager.InputStreamFileContents;
import edu.colorado.phet.common.servicemanager.LocalFileContent;
import edu.colorado.phet.common.servicemanager.LocalFileFilter;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jnlp.FileContents;
import javax.jnlp.FileSaveService;
import javax.swing.JFileChooser;

public class LocalFileSaveService
implements FileSaveService {
    Component owner;

    public LocalFileSaveService(Component component) {
        this.owner = component;
    }

    public FileContents saveAsFileDialog(String string, String[] stringArray, FileContents fileContents) throws IOException {
        JFileChooser jFileChooser = new JFileChooser(string);
        LocalFileFilter localFileFilter = new LocalFileFilter(stringArray);
        jFileChooser.setFileFilter(localFileFilter);
        int n = jFileChooser.showSaveDialog(this.owner);
        if (n == 1) {
            System.out.println("Cancelled.");
            return null;
        }
        if (n == -1) {
            System.out.println("Error");
            return null;
        }
        if (n == 0) {
            Object object;
            File file = jFileChooser.getSelectedFile();
            System.out.println("Selected file f=" + file);
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            } else {
                object = SimStrings.getInstance().getString("Save.confirm.message");
                int n2 = DialogUtils.showConfirmDialog(this.owner, (String)object, 1);
                if (n2 != 0) {
                    return null;
                }
            }
            object = new LocalFileContent(file);
            byte[] byArray = new byte[(int)fileContents.getLength()];
            InputStream inputStream = fileContents.getInputStream();
            int n3 = 0;
            while ((n3 = inputStream.read(byArray, n3, byArray.length - n3)) > 0) {
            }
            inputStream.close();
            if (file.canWrite()) {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byArray);
            }
            return object;
        }
        return null;
    }

    public FileContents saveFileDialog(String string, String[] stringArray, InputStream inputStream, String string2) throws IOException {
        return this.saveAsFileDialog(string, stringArray, new InputStreamFileContents(string2, inputStream));
    }
}

