/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.timeseries.model;

import edu.colorado.phet.common.timeseries.model.TimeState;
import java.util.ArrayList;

public class TimeStateSeries {
    private ArrayList pts = new ArrayList();

    public void addPoint(Object object, double d) {
        TimeState timeState = new TimeState(object, d);
        this.pts.add(timeState);
    }

    public int size() {
        return this.pts.size();
    }

    public void clear() {
        this.pts = new ArrayList();
    }

    public TimeState pointAt(int n) {
        return (TimeState)this.pts.get(n);
    }

    public int numPoints() {
        return this.pts.size();
    }

    public Object getTimeStateValue(double d) {
        TimeState timeState = this.getTimeState(d);
        return timeState != null ? timeState.getValue() : null;
    }

    public TimeState getTimeState(double d) {
        double d2;
        double d3;
        boolean bl;
        if (this.numPoints() == 0) {
            return new TimeState(null, 0.0);
        }
        TimeState[] timeStateArray = this.getNeighborsForTime(d, 0, this.numPoints() - 1);
        TimeState timeState = timeStateArray[0];
        TimeState timeState2 = timeStateArray[1];
        boolean bl2 = bl = timeState.getTime() <= d && timeState2.getTime() >= d;
        if (!bl) {
            System.out.println("requested time=" + d + ", lower bound=" + timeState.getTime() + ", upper bound=" + timeState2.getTime() + ", valid=" + bl);
        }
        if ((d3 = Math.abs(timeState.getTime() - d)) <= (d2 = Math.abs(timeState2.getTime() - d))) {
            return new TimeState(timeState.getValue(), d);
        }
        return new TimeState(timeState2.getValue(), d);
    }

    private TimeState[] getNeighborsForTime(double d, int n, int n2) {
        return new TimeState[]{this.getLowerSample(d, n, n2, 0), this.getUpperSample(d, n, n2, 0)};
    }

    private TimeState getLowerSample(double d, int n, int n2, int n3) {
        if (n3 > 1000) {
            new RuntimeException("Lower Sample recursed 1000 times.").printStackTrace();
            return new TimeState(null, 0.0);
        }
        if (n == n2 || n == n2 - 1) {
            return this.pointAt(n);
        }
        int n4 = (n2 + n) / 2;
        TimeState timeState = this.pointAt(n4);
        if (timeState.getTime() > d) {
            return this.getLowerSample(d, n, n4, n3 + 1);
        }
        return this.getLowerSample(d, n4, n2, n3 + 1);
    }

    private TimeState getUpperSample(double d, int n, int n2, int n3) {
        if (n3 > 1000) {
            new RuntimeException("Lower Sample recursed 1000 times.").printStackTrace();
            return new TimeState(null, 0.0);
        }
        if (n == n2 || n == n2 - 1) {
            return this.pointAt(n2);
        }
        int n4 = (n2 + n) / 2;
        TimeState timeState = this.pointAt(n4);
        if (timeState.getTime() > d) {
            return this.getUpperSample(d, n, n4, n3 + 1);
        }
        return this.getUpperSample(d, n4, n2, n3 + 1);
    }

    public double getStartTime() {
        return this.pointAt(0).getTime();
    }
}

