/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.energyskatepark.EnergySkateParkModule;
import edu.colorado.phet.energyskatepark.EnergySkateParkOptions;
import edu.colorado.phet.energyskatepark.EnergySkateParkOptionsMenu;
import edu.colorado.phet.energyskatepark.EnergySkateParkStrings;
import edu.colorado.phet.energyskatepark.serialization.EnergySkateParkIO;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkFrameSetup;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkLookAndFeel;
import edu.colorado.phet.energyskatepark.view.swing.EnergySkateParkTestMenu;
import edu.colorado.phet.energyskatepark.view.swing.EnergySkateParkTrackMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public class EnergySkateParkApplication
extends PhetApplication {
    private EnergySkateParkModule module;
    public static double SIMULATION_TIME_DT = 0.03;

    public EnergySkateParkApplication(String[] stringArray) {
        this(stringArray, new EnergySkateParkOptions());
    }

    public EnergySkateParkApplication(String[] stringArray, EnergySkateParkOptions energySkateParkOptions) {
        super(stringArray, EnergySkateParkStrings.getString("energy-skate-park.name"), EnergySkateParkStrings.getString("energy-skate-park.description"), PhetApplicationConfig.getVersion("energy-skate-park").formatForTitleBar(), new EnergySkateParkFrameSetup());
        this.module = new EnergySkateParkModule("Module", new ConstantDtClock(30, SIMULATION_TIME_DT), this.getPhetFrame(), energySkateParkOptions);
        this.setModules(new Module[]{this.module});
        this.getPhetFrame().addMenu(new EnergySkateParkOptionsMenu(this.module));
        this.getPhetFrame().addMenu(new EnergySkateParkTestMenu(this));
        this.getPhetFrame().addMenu(new EnergySkateParkTrackMenu(this));
        JMenuItem jMenuItem = new JMenuItem(EnergySkateParkStrings.getString("file-menu.save") + "...");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    EnergySkateParkIO.save(EnergySkateParkApplication.this.module);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(EnergySkateParkStrings.getString("file-menu.open") + "...");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    EnergySkateParkIO.open(EnergySkateParkApplication.this.module);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.getPhetFrame().addFileMenuItem(jMenuItem2);
        this.getPhetFrame().addFileMenuItem(jMenuItem);
        this.getPhetFrame().addFileMenuSeparator();
    }

    public EnergySkateParkModule getModule() {
        return this.module;
    }

    private void start() {
        super.startApplication();
        this.module.getPhetPCanvas().requestFocus();
    }

    public static void main(String[] stringArray) {
        EnergySkateParkApplication.main(stringArray, EnergySkateParkApplication.parseOptions(stringArray));
    }

    private static EnergySkateParkOptions parseOptions(String[] stringArray) {
        return new EnergySkateParkOptions();
    }

    public static void main(final String[] stringArray, final EnergySkateParkOptions energySkateParkOptions) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new EnergySkateParkLookAndFeel().initLookAndFeel();
                new EnergySkateParkApplication(stringArray, energySkateParkOptions).start();
            }
        });
    }
}

