/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark;

import edu.colorado.phet.common.phetcommon.math.SerializablePoint2D;
import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.common.piccolophet.help.HelpBalloon;
import edu.colorado.phet.common.timeseries.model.TimeSeriesModel;
import edu.colorado.phet.energyskatepark.EnergySkateParkOptions;
import edu.colorado.phet.energyskatepark.EnergySkateParkStrings;
import edu.colorado.phet.energyskatepark.SkaterCharacter;
import edu.colorado.phet.energyskatepark.SkaterCharacterSet;
import edu.colorado.phet.energyskatepark.model.Body;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkRecordableModel;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkSpline;
import edu.colorado.phet.energyskatepark.model.Planet;
import edu.colorado.phet.energyskatepark.model.PreFabSplines;
import edu.colorado.phet.energyskatepark.plots.BarChartDialog;
import edu.colorado.phet.energyskatepark.plots.EnergyPositionPlotDialog;
import edu.colorado.phet.energyskatepark.plots.EnergyTimePlot;
import edu.colorado.phet.energyskatepark.view.EnergyLookAndFeel;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkControlPanel;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkSimulationPanel;
import edu.colorado.phet.energyskatepark.view.WiggleMeInSpace;
import edu.colorado.phet.energyskatepark.view.swing.EnergySkateParkTimePanel;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import javax.swing.JOptionPane;

public class EnergySkateParkModule
extends PiccoloModule {
    private EnergySkateParkModel energyModel;
    private EnergySkateParkSimulationPanel energySkateParkSimulationPanel;
    private EnergyLookAndFeel energyLookAndFeel = new EnergyLookAndFeel();
    private BarChartDialog barChartDialog;
    private double floorY = 0.0;
    private EnergySkateParkRecordableModel energyTimeSeriesModel;
    private SkaterCharacterSet skaterCharacterSet = new SkaterCharacterSet();
    private PhetFrame phetFrame;
    private EnergySkateParkControlPanel energySkateParkControlPanel;
    private TimeSeriesModel timeSeriesModel;
    private EnergyTimePlot energyTimePlot;
    private EnergyPositionPlotDialog energyPositionPlotDialog;
    private EnergySkateParkOptions options;

    public EnergySkateParkModule(String string, ConstantDtClock constantDtClock, PhetFrame phetFrame, EnergySkateParkOptions energySkateParkOptions) {
        super(string, constantDtClock);
        this.options = energySkateParkOptions;
        this.phetFrame = phetFrame;
        this.energyModel = new EnergySkateParkModel(this.floorY);
        this.setModel(new BaseModel());
        this.energyTimeSeriesModel = new EnergySkateParkRecordableModel(this.getEnergySkateParkModel());
        this.timeSeriesModel = new TimeSeriesModel(this.energyTimeSeriesModel, constantDtClock);
        this.timeSeriesModel.setMaxAllowedRecordTime(20.0);
        constantDtClock.addClockListener(this.timeSeriesModel);
        this.energySkateParkSimulationPanel = new EnergySkateParkSimulationPanel(this);
        this.setSimulationPanel(this.energySkateParkSimulationPanel);
        this.energySkateParkControlPanel = new EnergySkateParkControlPanel(this);
        this.setControlPanel(this.energySkateParkControlPanel);
        this.barChartDialog = new BarChartDialog(phetFrame, EnergySkateParkStrings.getString("plots.bar-graph"), false, this);
        this.barChartDialog.setSize(200, 625);
        this.barChartDialog.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width - this.barChartDialog.getWidth(), 0);
        this.energyTimePlot = new EnergyTimePlot(this, phetFrame, constantDtClock, this.energyModel, this.timeSeriesModel);
        this.energyTimePlot.addListener(new EnergyTimePlot.Listener(){

            public void visibilityChanged() {
                EnergySkateParkModule.this.setRecordOrLiveMode();
            }
        });
        this.addDefaultBody();
        this.energyPositionPlotDialog = new EnergyPositionPlotDialog(phetFrame, EnergySkateParkStrings.getString("plots.energy-vs-position"), false, this);
        this.energyPositionPlotDialog.setSize(400, 400);
        EnergySkateParkTimePanel energySkateParkTimePanel = new EnergySkateParkTimePanel(this, constantDtClock);
        this.getModulePanel().setClockControlPanel(energySkateParkTimePanel);
        this.setDefaults();
        this.setLogoPanelVisible(Toolkit.getDefaultToolkit().getScreenSize().height > 768);
        new WiggleMeInSpace(this).start();
        final HelpBalloon helpBalloon = new HelpBalloon(this.getDefaultHelpPane(), "Grab a Track", HelpBalloon.TOP_CENTER, 20.0);
        this.getDefaultHelpPane().add(helpBalloon);
        helpBalloon.pointAt(this.energySkateParkSimulationPanel.getRootNode().getSplineToolbox(), this.energySkateParkSimulationPanel);
        final HelpBalloon helpBalloon2 = new HelpBalloon(this.getDefaultHelpPane(), "Drag the Skater", HelpBalloon.RIGHT_CENTER, 20.0){

            public Point2D mapLocation(PNode pNode, PCanvas pCanvas) {
                if (pNode == null || pNode.getParent() == null) {
                    return new Point2D.Double(0.0, 0.0);
                }
                return super.mapLocation(pNode, pCanvas);
            }
        };
        this.getDefaultHelpPane().add(helpBalloon2);
        helpBalloon2.pointAt(this.energySkateParkSimulationPanel.getRootNode().getSkaterNode(0), this.energySkateParkSimulationPanel);
        this.energyModel.addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void bodyCountChanged() {
                if (EnergySkateParkModule.this.energySkateParkSimulationPanel.getRootNode().numBodyGraphics() > 0) {
                    helpBalloon2.pointAt(EnergySkateParkModule.this.energySkateParkSimulationPanel.getRootNode().getSkaterNode(0), EnergySkateParkModule.this.energySkateParkSimulationPanel);
                }
            }
        });
        final HelpBalloon helpBalloon3 = new HelpBalloon(this.getDefaultHelpPane(), "Right Click for Options", HelpBalloon.BOTTOM_CENTER, 20.0);
        this.getDefaultHelpPane().add(helpBalloon3);
        helpBalloon3.pointAt(0.0, 0.0);
        this.energyModel.addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void preStep() {
                if (EnergySkateParkModule.this.energyModel.getNumSplines() > 0 && EnergySkateParkModule.this.isHelpEnabled()) {
                    helpBalloon.setVisible(EnergySkateParkModule.this.isHelpEnabled());
                    SerializablePoint2D serializablePoint2D = EnergySkateParkModule.this.energyModel.getSpline(0).getParametricFunction2D().evaluate(0.25);
                    Point2D.Double double_ = new Point2D.Double(serializablePoint2D.getX(), serializablePoint2D.getY());
                    EnergySkateParkModule.this.energySkateParkSimulationPanel.getRootNode().worldToScreen(double_);
                    helpBalloon3.pointAt(double_);
                } else {
                    helpBalloon.setVisible(false);
                }
            }
        });
    }

    public boolean hasHelp() {
        return true;
    }

    private void setDefaults() {
        this.setBarChartVisible(false);
        this.setEnergyTimePlotVisible(false);
        this.setEnergyPositionPlotVisible(false);
    }

    public EnergySkateParkModel getEnergySkateParkModel() {
        return this.energyModel;
    }

    public EnergyLookAndFeel getEnergyLookAndFeel() {
        return this.energyLookAndFeel;
    }

    public EnergySkateParkSimulationPanel getEnergySkateParkSimulationPanel() {
        return this.energySkateParkSimulationPanel;
    }

    public void reset() {
        this.energyModel.reset();
        this.energySkateParkSimulationPanel.reset();
        this.energySkateParkControlPanel.reset();
        this.timeSeriesModel.reset();
        this.timeSeriesModel.setLiveMode();
        this.timeSeriesModel.startLiveMode();
        this.energyTimePlot.reset();
        this.barChartDialog.reset();
        this.energyPositionPlotDialog.reset();
        this.addDefaultBody();
        this.setPieChartVisible(false);
    }

    public void returnOrResetSkater() {
        if (this.getEnergySkateParkModel().getNumBodies() > 0) {
            Body body = this.getEnergySkateParkModel().getBody(0);
            this.returnOrResetSkater(body);
        }
    }

    private void returnOrResetSkater(Body body) {
        if (body.isRestorePointSet()) {
            this.returnSkateToRestorePoint(body);
        } else {
            this.reinitializeSkater(body);
        }
    }

    public void reinitializeSkater(Body body) {
        body.deleteRestorePoint();
        body.reset();
        this.initBodyOnTrack(body);
    }

    public void returnSkateToRestorePoint(Body body) {
        body.reset();
        if (!body.isRestorePointSet()) {
            this.initBodyOnTrack(body);
        }
        if (!this.getEnergySkateParkSimulationPanel().isSkaterOnscreen(body)) {
            body.deleteRestorePoint();
            body.reset();
            this.initBodyOnTrack(body);
        }
    }

    private void addDefaultBody() {
        Body body = this.energyModel.createBody();
        this.energyModel.addBody(body);
        this.energyModel.addSplineSurface(this.createDefaultTrack());
        this.initBodyOnTrack(body);
    }

    private EnergySkateParkSpline createDefaultTrack() {
        return new EnergySkateParkSpline(new PreFabSplines().getParabolic().getControlPoints());
    }

    private void initBodyOnTrack(Body body) {
        if (this.isTrackDefaultState()) {
            body.setSpline(this.energyModel.getSpline(0), false, 0.1);
            body.clearHeat();
            body.clearEnergyError();
        }
    }

    private boolean isTrackDefaultState() {
        return this.energyModel.getNumSplines() > 0 && this.energyModel.getSpline(0).equals(this.createDefaultTrack());
    }

    public TimeSeriesModel getTimeSeriesModel() {
        return this.timeSeriesModel;
    }

    public void setRecordPath(boolean bl) {
        this.getEnergySkateParkModel().setRecordPath(bl);
    }

    public boolean isMeasuringTapeVisible() {
        return this.energySkateParkSimulationPanel.isMeasuringTapeVisible();
    }

    public void setMeasuringTapeVisible(boolean bl) {
        this.energySkateParkSimulationPanel.setMeasuringTapeVisible(bl);
    }

    public boolean isPieChartVisible() {
        return this.energySkateParkSimulationPanel.isPieChartVisible();
    }

    public void setPieChartVisible(boolean bl) {
        this.energySkateParkSimulationPanel.setPieChartVisible(bl);
    }

    public void clearPaths() {
        this.getEnergySkateParkModel().clearHistory();
    }

    public void setEnergyTimePlotVisible(boolean bl) {
        this.energyTimePlot.setVisible(bl);
    }

    public void setBarChartVisible(boolean bl) {
        this.barChartDialog.setVisible(bl);
    }

    public void setCoefficientOfFriction(double d) {
        for (int i = 0; i < this.getEnergySkateParkModel().getNumBodies(); ++i) {
            this.getEnergySkateParkModel().getBody(i).setFrictionCoefficient(d);
        }
    }

    public void setEnergyPositionPlotVisible(boolean bl) {
        this.energyPositionPlotDialog.setVisible(bl);
    }

    public void setBounciness(double d) {
        EnergySkateParkModel energySkateParkModel = this.getEnergySkateParkModel();
        for (int i = 0; i < energySkateParkModel.getNumBodies(); ++i) {
            energySkateParkModel.getBody(i).setBounciness(d);
        }
    }

    public void confirmAndReset() {
        int n = JOptionPane.showConfirmDialog(this.getSimulationPanel(), EnergySkateParkStrings.getString("message.confirm-reset"), EnergySkateParkStrings.getString("message.confirm-reset-title"), 0);
        if (n == 0) {
            this.reset();
        }
    }

    public Planet[] getPlanets() {
        return new Planet[]{new Planet.Space(), new Planet.Moon(), new Planet.Earth(), new Planet.Jupiter()};
    }

    public Frame getPhetFrame() {
        return this.phetFrame;
    }

    public void setSkaterCharacter(SkaterCharacter skaterCharacter) {
        this.energyModel.setSkaterCharacter(skaterCharacter);
    }

    public SkaterCharacter getSkaterCharacter() {
        return this.energyModel.getSkaterCharacter();
    }

    public SkaterCharacter[] getSkaterCharacters() {
        return this.skaterCharacterSet.getSkaterCharacters();
    }

    public void setEnergyErrorVisible(boolean bl) {
        this.energySkateParkSimulationPanel.setEnergyErrorVisible(bl);
    }

    public boolean isEnergyErrorVisible() {
        return this.energySkateParkSimulationPanel.isEnergyErrorVisible();
    }

    public void showNewEnergyVsTimePlot() {
        this.energyTimePlot.setVisible(true);
    }

    public EnergySkateParkOptions getOptions() {
        return this.options;
    }

    private boolean isEnergyVsTimeGraphVisible() {
        return this.energyTimePlot.isVisible();
    }

    public void setRecordOrLiveMode() {
        if (this.isEnergyVsTimeGraphVisible()) {
            this.timeSeriesModel.setRecordMode();
        } else {
            this.timeSeriesModel.setLiveMode();
        }
    }

    public Body createBody() {
        return this.energyModel.createBody();
    }
}

