/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark;

import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;

public class SkaterCharacter
implements Serializable {
    private String imageURL;
    private String name;
    private double mass;
    private double modelHeight;
    private double heightDivisor;

    public SkaterCharacter(String string, String string2, double d, double d2) {
        this(string, string2, d, d2, 1.0);
    }

    public SkaterCharacter(String string, String string2, double d, double d2, double d3) {
        this.imageURL = string;
        this.name = string2;
        this.mass = d;
        this.modelHeight = d2;
        this.heightDivisor = d3;
    }

    public boolean equals(Object object) {
        if (object instanceof SkaterCharacter) {
            SkaterCharacter skaterCharacter = (SkaterCharacter)object;
            return skaterCharacter.imageURL.equals(this.imageURL) && skaterCharacter.name.equals(this.name) && skaterCharacter.mass == this.mass && skaterCharacter.modelHeight == this.modelHeight && skaterCharacter.heightDivisor == this.heightDivisor;
        }
        return false;
    }

    public double getModelWidth() {
        return this.modelHeight / (double)this.getImage().getHeight() * (double)this.getImage().getWidth();
    }

    public double getModelHeight() {
        return this.modelHeight;
    }

    public String getName() {
        return this.name;
    }

    public double getMass() {
        return this.mass;
    }

    public String getImageURL() {
        return this.imageURL;
    }

    public BufferedImage getImage() {
        try {
            return ImageLoader.loadBufferedImage(this.getImageURL());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
    }

    public double getHeightDivisor() {
        return this.heightDivisor;
    }
}

