/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.common;

import edu.colorado.phet.common.phetcommon.view.util.PhetDefaultFont;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.ShadowPText;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class Legend
extends PhetPNode {
    private ArrayList list = new ArrayList();
    private double padY = 2.0;
    private PPath background = new PPath();

    public Legend() {
        this.background.setPaint(Color.white);
        this.addChild(this.background);
    }

    public void setBackgroundPaint(Paint paint) {
        this.background.setPaint(paint);
    }

    public void addEntry(String string, Color color) {
        Entry entry = new Entry(string, color, new SquareColor(color));
        this.list.add(entry);
        this.addChild(entry);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        if (this.list.size() > 0) {
            Entry entry = (Entry)this.list.get(0);
            entry.setOffset(0.0, 5.0);
            Rectangle2D rectangle2D = new PBounds(entry.getFullBounds());
            for (int i = 1; i < this.list.size(); ++i) {
                Entry entry2 = (Entry)this.list.get(i - 1);
                Entry entry3 = (Entry)this.list.get(i);
                entry3.setOffset(entry2.getFullBounds().getX(), entry2.getFullBounds().getMaxY() + this.padY);
                rectangle2D = ((Rectangle2D)rectangle2D).createUnion(entry3.getFullBounds());
            }
            this.background.setPathTo(RectangleUtils.expand(rectangle2D, 5.0, 5.0));
            double d = this.background.getFullBounds().getY();
            for (int i = 0; i < this.getChildrenCount(); ++i) {
                this.getChild(i).translate(0.0, -d);
            }
        }
    }

    public void setFont(Font font) {
        for (int i = 0; i < this.list.size(); ++i) {
            Entry entry = (Entry)this.list.get(i);
            entry.setFont(font);
        }
    }

    private static class SquareColor
    extends PPath {
        public SquareColor(Color color) {
            this.setPathTo(new Rectangle(0, 0, 10, 10));
            this.setPaint(color);
        }
    }

    private static class Entry
    extends PNode {
        String text;
        PNode node;
        private ShadowPText textNode;

        public Entry(String string, Color color, PNode pNode) {
            this.text = string;
            this.node = pNode;
            this.textNode = new ShadowPText(string);
            this.textNode.setShadowOffset(1.0, 1.0);
            this.textNode.setFont(new PhetDefaultFont(16, false, true));
            this.textNode.setShadowColor(Color.black);
            this.textNode.setTextPaint(color);
            this.addChild(this.textNode);
            this.addChild(pNode);
            this.textNode.setOffset(pNode.getFullBounds().getMaxX() + 2.0, pNode.getFullBounds().getY());
        }

        public void setFont(Font font) {
            this.textNode.setFont(font);
        }
    }
}

