/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.model;

import edu.colorado.phet.common.phetcommon.math.SerializablePoint2D;
import edu.colorado.phet.common.phetcommon.util.persistence.PersistenceUtil;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.energyskatepark.model.physics.ControlPointParametricFunction2D;
import edu.colorado.phet.energyskatepark.model.physics.CubicSpline2D;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import java.util.ArrayList;

public class EnergySkateParkSpline
implements Serializable {
    private DefaultTrackSpline parametricFunction2D;
    private boolean rollerCoaster;
    private boolean userControlled;
    private boolean interactive = true;
    private transient ArrayList listeners = new ArrayList();

    public EnergySkateParkSpline(SerializablePoint2D[] serializablePoint2DArray) {
        this(new DefaultTrackSpline(serializablePoint2DArray));
    }

    private EnergySkateParkSpline(DefaultTrackSpline defaultTrackSpline) {
        this.parametricFunction2D = defaultTrackSpline;
    }

    public boolean isUserControlled() {
        return this.userControlled;
    }

    public String toString() {
        return "fn=" + this.parametricFunction2D;
    }

    public EnergySkateParkSpline copy() {
        try {
            return (EnergySkateParkSpline)PersistenceUtil.copy(this);
        }
        catch (PersistenceUtil.CopyFailedException copyFailedException) {
            copyFailedException.printStackTrace();
            throw new RuntimeException(copyFailedException);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof EnergySkateParkSpline) {
            EnergySkateParkSpline energySkateParkSpline = (EnergySkateParkSpline)object;
            return energySkateParkSpline.parametricFunction2D.equals(this.parametricFunction2D) && energySkateParkSpline.rollerCoaster == this.rollerCoaster && energySkateParkSpline.userControlled == this.userControlled && energySkateParkSpline.interactive == this.interactive;
        }
        return false;
    }

    public ControlPointParametricFunction2D getParametricFunction2D() {
        return this.parametricFunction2D;
    }

    public void setRollerCoasterMode(boolean bl) {
        if (bl != this.rollerCoaster) {
            this.rollerCoaster = bl;
            this.parametricFunction2D.rollerCoasterMode = this.rollerCoaster;
            this.notifyRollerCoasterModeChanged();
        }
    }

    public boolean isRollerCoasterMode() {
        return this.rollerCoaster;
    }

    public void setUserControlled(boolean bl) {
        this.userControlled = bl;
    }

    public SerializablePoint2D[] getControlPoints() {
        return this.parametricFunction2D.getControlPoints();
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public GeneralPath getInterpolationPath() {
        return this.createInterpolationPath();
    }

    private GeneralPath createInterpolationPath() {
        SerializablePoint2D[] serializablePoint2DArray = this.getInterpolationPoints();
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        doubleGeneralPath.moveTo(serializablePoint2DArray[0].getX(), serializablePoint2DArray[0].getY());
        for (int i = 1; i < serializablePoint2DArray.length; ++i) {
            doubleGeneralPath.lineTo(serializablePoint2DArray[i]);
        }
        return doubleGeneralPath.getGeneralPath();
    }

    private SerializablePoint2D[] getInterpolationPoints() {
        ArrayList<SerializablePoint2D> arrayList = new ArrayList<SerializablePoint2D>();
        for (double d = 0.0; d <= 1.0; d += 0.01) {
            arrayList.add(this.parametricFunction2D.evaluate(d));
        }
        arrayList.add(this.parametricFunction2D.evaluate(1.0));
        return arrayList.toArray(new SerializablePoint2D[0]);
    }

    public SerializablePoint2D getControlPoint(int n) {
        return this.getControlPoints()[n];
    }

    public void translate(double d, double d2) {
        if (d != 0.0 || d2 != 0.0) {
            this.parametricFunction2D.translateControlPoints(d, d2);
            this.notifyControlPointsChanged();
        }
    }

    private void notifyControlPointsChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.controlPointsChanged();
        }
    }

    public int numControlPoints() {
        return this.getControlPoints().length;
    }

    public void translateControlPoint(int n, double d, double d2) {
        this.parametricFunction2D.translateControlPoint(n, d, d2);
        this.notifyControlPointsChanged();
    }

    public void removeControlPoint(int n) {
        this.parametricFunction2D.removeControlPoint(n);
        this.notifyControlPointsChanged();
    }

    public void printControlPointCode() {
        System.out.println("parametricFunction2D.toStringSerialization() = " + this.parametricFunction2D.toStringSerialization());
    }

    public void setControlPointLocation(int n, SerializablePoint2D serializablePoint2D) {
        this.parametricFunction2D.setControlPoint(n, serializablePoint2D);
        this.notifyControlPointsChanged();
    }

    public double getMinY() {
        int n;
        double d = Double.POSITIVE_INFINITY;
        for (n = 0; n < 100; ++n) {
            SerializablePoint2D serializablePoint2D = this.parametricFunction2D.evaluate((double)n / 100.0);
            if (!(serializablePoint2D.getY() < d)) continue;
            d = serializablePoint2D.getY();
        }
        for (n = 0; n < this.numControlPoints(); ++n) {
            if (!(this.getControlPoint(n).getY() < d)) continue;
            d = this.getControlPoint(n).getY();
        }
        return d;
    }

    public void addListener(Listener listener) {
        this.createListenerArray();
        this.listeners.add(listener);
    }

    private void createListenerArray() {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
    }

    public void removeListener(Listener listener) {
        this.createListenerArray();
        this.listeners.remove(listener);
    }

    private void notifyRollerCoasterModeChanged() {
        this.createListenerArray();
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).rollerCoasterModeChanged();
        }
    }

    public static class DefaultTrackSpline
    extends CubicSpline2D {
        private boolean rollerCoasterMode = false;

        public DefaultTrackSpline(SerializablePoint2D[] serializablePoint2DArray) {
            super(serializablePoint2DArray);
        }

        public boolean isRollerCoasterMode() {
            return this.rollerCoasterMode;
        }
    }

    public static interface Listener {
        public void rollerCoasterModeChanged();

        public void controlPointsChanged();
    }
}

