/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.model;

import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkSpline;
import edu.colorado.phet.energyskatepark.model.physics.ParticleStage;

public class EnergySkateParkSplineListAdapter
extends ParticleStage {
    private EnergySkateParkModel energySkateParkModel;

    public EnergySkateParkSplineListAdapter(EnergySkateParkModel energySkateParkModel) {
        this.energySkateParkModel = energySkateParkModel;
        energySkateParkModel.addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void splineCountChanged() {
                EnergySkateParkSplineListAdapter.this.update();
            }

            public void floorChanged() {
                EnergySkateParkSplineListAdapter.this.update();
            }
        });
        this.update();
    }

    private void update() {
        this.clear();
        for (int i = 0; i < this.energySkateParkModel.getNumSplines(); ++i) {
            EnergySkateParkSpline energySkateParkSpline = this.energySkateParkModel.getSpline(i);
            this.addCubicSpline2D(energySkateParkSpline.getParametricFunction2D());
        }
        if (this.energySkateParkModel.getFloor() != null) {
            this.addCubicSpline2D(this.energySkateParkModel.getFloor().getParametricFunction2D());
        }
    }

    public boolean isSplineUserControlled() {
        for (int i = 0; i < this.energySkateParkModel.getNumSplines(); ++i) {
            if (!this.energySkateParkModel.getSpline(i).isUserControlled()) continue;
            return true;
        }
        return false;
    }
}

