/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.model;

import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.energyskatepark.EnergySkateParkModule;
import edu.colorado.phet.energyskatepark.EnergySkateParkStrings;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.io.IOException;

public abstract class Planet {
    private String name;
    private double gravity;
    private Paint groundPaint;
    private Paint groundLinePaint;
    private boolean groundVisible;

    protected Planet(String string, double d, Paint paint, Paint paint2, boolean bl) {
        this.gravity = d;
        this.name = string;
        this.groundPaint = paint;
        this.groundLinePaint = paint2;
        this.groundVisible = bl;
    }

    public String getName() {
        return this.name;
    }

    public double getGravity() {
        return this.gravity;
    }

    public void apply(EnergySkateParkModule energySkateParkModule) {
        this.setupImage(energySkateParkModule);
        this.setupGravity(energySkateParkModule);
    }

    private void setupGravity(EnergySkateParkModule energySkateParkModule) {
        energySkateParkModule.getEnergySkateParkModel().setGravity(this.gravity);
    }

    protected abstract void setupImage(EnergySkateParkModule var1);

    public boolean isDefault() {
        return false;
    }

    public Paint getGroundPaint() {
        return this.groundPaint;
    }

    public Paint getGroundLinePaint() {
        return this.groundLinePaint;
    }

    public boolean isGroundVisible() {
        return this.groundVisible;
    }

    public static class Jupiter
    extends Planet {
        public Jupiter() {
            super(EnergySkateParkStrings.getString("location.jupiter"), -25.95, new Color(173, 114, 98), new Color(62, 44, 58), true);
        }

        protected void setupImage(EnergySkateParkModule energySkateParkModule) {
            try {
                BufferedImage bufferedImage = ImageLoader.loadBufferedImage("energy-skate-park/images/jupiter4.jpg");
                energySkateParkModule.getEnergySkateParkSimulationPanel().getRootNode().setBackground(bufferedImage);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static class Moon
    extends Planet {
        public Moon() {
            super(EnergySkateParkStrings.getString("location.moon"), -1.62, Color.gray, Color.darkGray, true);
        }

        protected void setupImage(EnergySkateParkModule energySkateParkModule) {
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = ImageLoader.loadBufferedImage("energy-skate-park/images/moon2.jpg");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            energySkateParkModule.getEnergySkateParkSimulationPanel().getRootNode().setBackground(bufferedImage);
        }
    }

    public static class Earth
    extends Planet {
        public Earth() {
            super(EnergySkateParkStrings.getString("location.earth"), -9.81, new Color(100, 170, 100), new Color(0, 130, 0), true);
        }

        protected void setupImage(EnergySkateParkModule energySkateParkModule) {
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = ImageLoader.loadBufferedImage("energy-skate-park/images/earth-background.jpg");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            energySkateParkModule.getEnergySkateParkSimulationPanel().getRootNode().setBackground(bufferedImage);
        }

        public boolean isDefault() {
            return true;
        }
    }

    public static class Space
    extends Planet {
        public Space() {
            super(EnergySkateParkStrings.getString("location.space"), 0.0, Color.black, Color.black, false);
        }

        protected void setupImage(EnergySkateParkModule energySkateParkModule) {
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = ImageLoader.loadBufferedImage("energy-skate-park/images/blackhole_large_2.jpg");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            energySkateParkModule.getEnergySkateParkSimulationPanel().getRootNode().setBackground(bufferedImage);
        }

        public boolean isGroundVisible() {
            return false;
        }
    }
}

