/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.model.physics;

import edu.colorado.phet.common.phetcommon.math.SerializablePoint2D;
import edu.colorado.phet.energyskatepark.model.physics.ParametricFunction2D;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class ControlPointParametricFunction2D
extends ParametricFunction2D {
    private SerializablePoint2D[] pts;

    public ControlPointParametricFunction2D(SerializablePoint2D[] serializablePoint2DArray) {
        this.pts = serializablePoint2DArray;
    }

    public boolean equals(Object object) {
        if (object instanceof ControlPointParametricFunction2D) {
            ControlPointParametricFunction2D controlPointParametricFunction2D = (ControlPointParametricFunction2D)object;
            return Arrays.equals(this.pts, controlPointParametricFunction2D.pts);
        }
        return false;
    }

    public void setControlPoints(SerializablePoint2D[] serializablePoint2DArray) {
        this.pts = serializablePoint2DArray;
    }

    public SerializablePoint2D[] getControlPoints() {
        SerializablePoint2D[] serializablePoint2DArray = new SerializablePoint2D[this.pts.length];
        for (int i = 0; i < serializablePoint2DArray.length; ++i) {
            serializablePoint2DArray[i] = new SerializablePoint2D(this.pts[i].getX(), this.pts[i].getY());
        }
        return serializablePoint2DArray;
    }

    public void setControlPoint(int n, SerializablePoint2D serializablePoint2D) {
        this.pts[n] = new SerializablePoint2D(serializablePoint2D.getX(), serializablePoint2D.getY());
    }

    public int getNumControlPoints() {
        return this.pts.length;
    }

    public void translateControlPoints(double d, double d2) {
        for (int i = 0; i < this.pts.length; ++i) {
            SerializablePoint2D serializablePoint2D = this.pts[i];
            serializablePoint2D.setLocation(serializablePoint2D.getX() + d, serializablePoint2D.getY() + d2);
        }
    }

    public void translateControlPoint(int n, double d, double d2) {
        this.pts[n].setLocation(this.pts[n].getX() + d, this.pts[n].getY() + d2);
    }

    public void removeControlPoint(int n) {
        ArrayList<SerializablePoint2D> arrayList = new ArrayList<SerializablePoint2D>(Arrays.asList(this.pts));
        arrayList.remove(n);
        this.setControlPoints(arrayList.toArray(new SerializablePoint2D[arrayList.size()]));
    }

    public int numControlPoints() {
        return this.pts.length;
    }

    public SerializablePoint2D controlPointAt(int n) {
        return this.pts[n];
    }
}

