/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.model.physics;

import Jama.Matrix;
import java.io.Serializable;
import java.util.Arrays;

public class CubicSpline
implements Serializable {
    private CubicSplineSegment[] segments;
    private double[] xTrain;
    private double[] yTrain;

    public CubicSpline(CubicSplineSegment[] cubicSplineSegmentArray, double[] dArray, double[] dArray2) {
        this.segments = cubicSplineSegmentArray;
        this.xTrain = dArray;
        this.yTrain = dArray2;
    }

    public boolean equals(Object object) {
        if (object instanceof CubicSpline) {
            CubicSpline cubicSpline = (CubicSpline)object;
            return Arrays.equals(cubicSpline.segments, this.segments) && Arrays.equals(cubicSpline.xTrain, this.xTrain) && Arrays.equals(cubicSpline.yTrain, this.yTrain);
        }
        return false;
    }

    public double evaluate(double d) {
        for (int i = 0; i < this.xTrain.length - 1; ++i) {
            if (!(d >= this.xTrain[i]) || !(d <= this.xTrain[i + 1])) continue;
            if (i >= this.segments.length) {
                throw new RuntimeException("out of bounds");
            }
            return this.segments[i].evaluate(d);
        }
        if (d < 0.0) {
            return this.segments[0].evaluate(d);
        }
        return this.segments[this.segments.length - 1].evaluate(d);
    }

    private static double pow3(double d) {
        return d * d * d;
    }

    public static CubicSpline interpolate(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double[] dArray3 = new double[dArray.length - 1];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = dArray[i + 1] - dArray[i];
        }
        Matrix matrix = new Matrix(n, n);
        matrix.set(0, 0, 1.0);
        matrix.set(n - 1, n - 1, 1.0);
        for (int i = 1; i < n - 1; ++i) {
            matrix.set(i, i - 1, dArray3[i - 1]);
            matrix.set(i, i, 2.0 * (dArray3[i - 1] + dArray3[i]));
            matrix.set(i, i + 1, dArray3[i]);
        }
        Matrix matrix2 = new Matrix(n, 1);
        matrix2.set(0, 0, 0.0);
        matrix2.set(n - 1, 0, 0.0);
        for (int i = 1; i < n - 1; ++i) {
            double d = (dArray2[i + 1] - dArray2[i]) / dArray3[i];
            double d2 = (dArray2[i] - dArray2[i - 1]) / dArray3[i - 1];
            matrix2.set(i, 0, 6.0 * (d - d2));
        }
        Matrix matrix3 = matrix.solve(matrix2);
        double[] dArray4 = matrix3.getColumnPackedCopy();
        CubicSplineSegment[] cubicSplineSegmentArray = new CubicSplineSegment[n - 1];
        for (int i = 0; i < cubicSplineSegmentArray.length; ++i) {
            cubicSplineSegmentArray[i] = new CubicSplineSegment(dArray3[i], dArray4[i], dArray4[i + 1], dArray[i], dArray[i + 1], dArray2[i], dArray2[i + 1]);
        }
        return new CubicSpline(cubicSplineSegmentArray, dArray, dArray2);
    }

    static class CubicSplineSegment
    implements Cloneable,
    Serializable {
        private double h;
        private double z0;
        private double z1;
        private double x0;
        private double x1;
        private double y0;
        private double y1;

        public CubicSplineSegment(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
            this.h = d;
            this.z0 = d2;
            this.z1 = d3;
            this.x0 = d4;
            this.x1 = d5;
            this.y0 = d6;
            this.y1 = d7;
        }

        public boolean equals(Object object) {
            if (object instanceof CubicSplineSegment) {
                CubicSplineSegment cubicSplineSegment = (CubicSplineSegment)object;
                return cubicSplineSegment.h == this.h && cubicSplineSegment.z0 == this.z0 && cubicSplineSegment.z1 == this.z1 && cubicSplineSegment.x0 == this.x0 && cubicSplineSegment.x1 == this.x1 && cubicSplineSegment.y0 == this.y0 && cubicSplineSegment.y1 == this.y1;
            }
            return false;
        }

        public double evaluate(double d) {
            return (this.z1 * CubicSpline.pow3(d - this.x0) + this.z0 * CubicSpline.pow3(this.x1 - d)) / (6.0 * this.h) + (this.y1 / this.h - this.h / 6.0 * this.z1) * (d - this.x0) + (this.y0 / this.h - this.h / 6.0 * this.z0) * (this.x1 - d);
        }
    }
}

