/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.model.physics;

import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.energyskatepark.model.physics.CubicSpline2D;
import edu.colorado.phet.energyskatepark.model.physics.ParametricFunction2D;
import edu.colorado.phet.energyskatepark.model.physics.ParametricFunction2DNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;

public class CubicSpline2DNode
extends ParametricFunction2DNode {
    private CubicSpline2D parametricFunction2D;
    private PNode controlPointLayer = new PNode();
    private ParametricFunction2D.Listener listener = new ParametricFunction2D.Listener(){

        public void trackChanged() {
            CubicSpline2DNode.this.update();
        }
    };
    private boolean constructed = false;

    public CubicSpline2DNode(CubicSpline2D cubicSpline2D) {
        super(cubicSpline2D);
        this.parametricFunction2D = cubicSpline2D;
        cubicSpline2D.addListener(this.listener);
        this.addChild(this.controlPointLayer);
        this.constructed = true;
        this.updateControlPoints();
    }

    protected void updateControlPoints() {
        super.updateControlPoints();
        if (this.constructed) {
            while (this.controlPointLayer.getChildrenCount() < this.parametricFunction2D.getNumControlPoints()) {
                this.addControlPointNode();
            }
            while (this.controlPointLayer.getChildrenCount() > this.parametricFunction2D.getNumControlPoints()) {
                this.removeControlPointNode();
            }
            for (int i = 0; i < this.controlPointLayer.getChildrenCount(); ++i) {
                ControlPointNode controlPointNode = (ControlPointNode)this.controlPointLayer.getChild(i);
                controlPointNode.setIndex(i);
            }
        }
    }

    public void setCubicSpline2D(CubicSpline2D cubicSpline2D) {
        if (this.parametricFunction2D != null) {
            this.parametricFunction2D.removeListener(this.listener);
        }
        this.parametricFunction2D = cubicSpline2D;
        cubicSpline2D.addListener(this.listener);
        this.update();
    }

    private void removeControlPointNode() {
        this.controlPointLayer.removeChild(this.controlPointLayer.getChildrenCount() - 1);
    }

    private void addControlPointNode() {
        this.controlPointLayer.addChild(new ControlPointNode(0));
        this.update();
    }

    class ControlPointNode
    extends PNode {
        private int index;
        private PhetPPath controlPoint;

        public ControlPointNode(int n) {
            this.index = n;
            this.controlPoint = new PhetPPath(new Color(255, 50, 50, 128), (Stroke)new BasicStroke(0.01f), (Paint)Color.black);
            double d = 0.1;
            this.controlPoint.setPathTo(new Ellipse2D.Double(-d / 2.0, -d / 2.0, d, d));
            this.addChild(this.controlPoint);
            this.controlPoint.addInputEventListener(new PBasicInputEventHandler(this, CubicSpline2DNode.this){
                private final /* synthetic */ CubicSpline2DNode val$this$0;
                private final /* synthetic */ ControlPointNode this$1;
                {
                    this.this$1 = controlPointNode;
                    this.val$this$0 = cubicSpline2DNode;
                }

                public void mouseDragged(PInputEvent pInputEvent) {
                    CubicSpline2DNode.access$200(ControlPointNode.access$100(this.this$1)).translateControlPoint(ControlPointNode.access$000(this.this$1), pInputEvent.getDeltaRelativeTo((PNode)ControlPointNode.access$100((ControlPointNode)this.this$1)).width, pInputEvent.getDeltaRelativeTo((PNode)ControlPointNode.access$100((ControlPointNode)this.this$1)).height);
                }
            });
            this.addChild(this.controlPoint);
            this.update();
        }

        private void update() {
            this.controlPoint.setOffset(CubicSpline2DNode.this.parametricFunction2D.getControlPoints()[this.index]);
        }

        public void setIndex(int n) {
            this.index = n;
            this.update();
        }

        static /* synthetic */ int access$000(ControlPointNode controlPointNode) {
            return controlPointNode.index;
        }

        static /* synthetic */ CubicSpline2DNode access$100(ControlPointNode controlPointNode) {
            return controlPointNode.CubicSpline2DNode.this;
        }
    }
}

