/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.model.physics;

import edu.colorado.phet.common.phetcommon.math.AbstractVector2D;
import edu.colorado.phet.common.phetcommon.math.SerializablePoint2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import java.awt.geom.Line2D;
import java.io.Serializable;
import java.util.Arrays;

public abstract class ParametricFunction2D
implements Serializable {
    public double getClosestPoint(SerializablePoint2D serializablePoint2D) {
        return this.getClosestPointBinarySearch(serializablePoint2D);
    }

    public double getClosestPoint(Line2D.Double double_) {
        return this.getClosestPointBinarySearch(double_);
    }

    private double getClosestPointBinarySearch(Line2D.Double double_) {
        int n = 100;
        double d = 1.0 / (double)n;
        SerializablePoint2D serializablePoint2D = new SerializablePoint2D((double_.getX1() + double_.getX2()) / 2.0, (double_.getY1() + double_.getY2()) / 2.0);
        double d2 = this.getClosestPointFlatSearch(serializablePoint2D, n);
        Object object = new SearchPoint(d2 - d * 1.5, double_);
        Object object2 = new SearchPoint(d2 + d * 1.5, double_);
        int n2 = 0;
        double d3 = 1.0E-9;
        do {
            SearchPoint searchPoint = new SearchPoint((((SearchPoint)object).alpha + ((SearchPoint)object2).alpha) / 2.0, double_);
            Object[] objectArray = new SearchPoint[]{object, searchPoint, object2};
            Arrays.sort(objectArray);
            if (((SearchPoint)objectArray[0]).alpha < ((SearchPoint)objectArray[1]).alpha) {
                object = objectArray[0];
                object2 = objectArray[1];
                continue;
            }
            object = objectArray[1];
            object2 = objectArray[0];
        } while (++n2 <= 50 && !(Math.abs(((SearchPoint)object).alpha - ((SearchPoint)object2).alpha) < d3));
        return (((SearchPoint)object).alpha + ((SearchPoint)object2).alpha) / 2.0;
    }

    public AbstractVector2D getCurvatureDirection(double d) {
        AbstractVector2D abstractVector2D;
        SerializablePoint2D serializablePoint2D;
        double d2 = 0.001;
        SerializablePoint2D serializablePoint2D2 = this.evaluate(d - d2 / 2.0);
        SerializablePoint2D serializablePoint2D3 = this.evaluate(d + d2 / 2.0);
        SerializablePoint2D serializablePoint2D4 = this.evaluate(d);
        Vector2D.Double double_ = new Vector2D.Double(serializablePoint2D4, serializablePoint2D = new SerializablePoint2D((serializablePoint2D2.getX() + serializablePoint2D3.getX()) / 2.0, (serializablePoint2D2.getY() + serializablePoint2D3.getY()) / 2.0));
        if (double_.dot(abstractVector2D = new Vector2D.Double(this.getUnitNormalVector(d))) < 0.0) {
            abstractVector2D = abstractVector2D.getScaledInstance(-1.0);
        }
        return abstractVector2D;
    }

    public abstract String toStringSerialization();

    private double getClosestPointBinarySearch(SerializablePoint2D serializablePoint2D) {
        int n = 100;
        double d = 1.0 / (double)n;
        double d2 = this.getClosestPointFlatSearch(serializablePoint2D, n);
        Object object = new SearchPoint(d2 - d * 1.5, serializablePoint2D);
        Object object2 = new SearchPoint(d2 + d * 1.5, serializablePoint2D);
        int n2 = 0;
        double d3 = 1.0E-6;
        do {
            SearchPoint searchPoint = new SearchPoint((((SearchPoint)object).alpha + ((SearchPoint)object2).alpha) / 2.0, serializablePoint2D);
            Object[] objectArray = new SearchPoint[]{object, searchPoint, object2};
            Arrays.sort(objectArray);
            if (((SearchPoint)objectArray[0]).alpha < ((SearchPoint)objectArray[1]).alpha) {
                object = objectArray[0];
                object2 = objectArray[1];
                continue;
            }
            object = objectArray[1];
            object2 = objectArray[0];
        } while (++n2 <= 30 && !(Math.abs(((SearchPoint)object).alpha - ((SearchPoint)object2).alpha) < d3));
        return (((SearchPoint)object).alpha + ((SearchPoint)object2).alpha) / 2.0;
    }

    private double getClosestPointFlatSearch(SerializablePoint2D serializablePoint2D, int n) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NaN;
        for (int i = 0; i < n; ++i) {
            double d3 = (double)i / (double)n;
            double d4 = this.evaluate(d3).distance(serializablePoint2D);
            if (!(d4 < d)) continue;
            d = d4;
            d2 = d3;
        }
        return d2;
    }

    public abstract SerializablePoint2D evaluate(double var1);

    public double getMetricDelta(double d, double d2) {
        return this.getMetricDeltaIterative(d, d2);
    }

    public double getMetricDeltaIterative(double d, double d2) {
        if (d2 == d) {
            return 0.0;
        }
        if (d2 < d) {
            return -this.getMetricDeltaIterative(d2, d);
        }
        int n = 10;
        double d3 = (d2 - d) / (double)(n - 1);
        SerializablePoint2D serializablePoint2D = this.evaluate(d);
        double d4 = 0.0;
        for (int i = 1; i < n; ++i) {
            double d5 = d + (double)i * d3;
            SerializablePoint2D serializablePoint2D2 = this.evaluate(d5);
            double d6 = serializablePoint2D2.distance(serializablePoint2D);
            d4 += d6;
            serializablePoint2D = serializablePoint2D2;
        }
        return d4;
    }

    public double getFractionalDistance(double d, double d2) {
        double d3 = -1.0;
        double d4 = 2.0;
        double d5 = (d4 + d3) / 2.0;
        double d6 = this.getMetricDelta(d, d5);
        double d7 = 1.0E-8;
        int n = 0;
        while (Math.abs(d6 - d2) > d7) {
            if (d6 > d2) {
                d4 = d5;
            } else {
                d3 = d5;
            }
            d5 = (d4 + d3) / 2.0;
            d6 = this.getMetricDelta(d, d5);
            if (++n <= 100) continue;
            System.out.println("binary search failed: count=" + n);
            break;
        }
        return d5 - d;
    }

    public AbstractVector2D getUnitParallelVector(double d) {
        double d2 = 1.0E-8;
        double d3 = d - d2 / 2.0;
        double d4 = d + d2 / 2.0;
        Vector2D.Double double_ = new Vector2D.Double(this.evaluate(d3), this.evaluate(d4));
        if (double_.getMagnitude() == 0.0) {
            throw new RuntimeException("unit parallel vector failed: alpha=" + d + ", eval=" + this.evaluate(d));
        }
        return double_.getNormalizedInstance();
    }

    public AbstractVector2D getUnitNormalVector(double d) {
        return this.getUnitParallelVector(d).getNormalVector();
    }

    public double getAngle(double d) {
        return this.getUnitParallelVector(d).getAngle();
    }

    public SerializablePoint2D getOffsetPoint(double d, double d2, boolean bl) {
        return new SerializablePoint2D(this.getUnitNormalVector(d).getInstanceOfMagnitude(d2 * (double)(bl ? 1 : -1)).getDestination(this.evaluate(d)));
    }

    public SerializablePoint2D[] getOffsetSpline(double d, boolean bl, int n) {
        double d2 = 0.0;
        double d3 = 1.0 / (double)(n - 1);
        SerializablePoint2D[] serializablePoint2DArray = new SerializablePoint2D[n];
        for (int i = 0; i < n; ++i) {
            serializablePoint2DArray[i] = this.getOffsetPoint(d2, d, bl);
            d2 += d3;
        }
        return serializablePoint2DArray;
    }

    public static interface Listener {
        public void trackChanged();
    }

    class SearchPoint
    implements Comparable {
        double alpha;
        double dist;

        public SearchPoint(double d, Line2D line2D) {
            this(d, line2D.ptLineDist(parametricFunction2D.evaluate(d)));
        }

        public SearchPoint(double d, SerializablePoint2D serializablePoint2D) {
            this(d, parametricFunction2D.evaluate(d).distance(serializablePoint2D));
        }

        public SearchPoint(double d, double d2) {
            this.alpha = d;
            this.dist = d2;
        }

        public int compareTo(Object object) {
            return new Double(this.dist).compareTo(new Double(((SearchPoint)object).dist));
        }

        public String toString() {
            return "alpha=" + this.alpha + ", dist=" + this.dist;
        }
    }
}

