/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.model.physics;

import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.energyskatepark.model.physics.ParametricFunction2D;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;

public class ParametricFunction2DNode
extends PNode {
    private ParametricFunction2D parametricFunction2D;
    private PhetPPath phetPPath;
    private PNode topLayer = new PNode();
    private boolean normalsVisible = false;
    private boolean curvatureVisible = false;
    private PNode curvatureLayer = new PNode();
    private PNode topOffsetTrack = new PNode();
    private PNode bottomOffsetTrack = new PNode();
    private boolean topOffsetTrackVisible = false;
    private double splineOffset = 0.9520000000000001;
    private boolean showBottomOffsetSpline = false;

    public ParametricFunction2DNode(ParametricFunction2D parametricFunction2D) {
        this.parametricFunction2D = parametricFunction2D;
        this.phetPPath = new PhetPPath(new BasicStroke(0.01f), (Paint)Color.blue);
        this.addChild(this.phetPPath);
        this.addChild(this.topLayer);
        this.addChild(this.curvatureLayer);
        this.addChild(this.topOffsetTrack);
        this.addChild(this.bottomOffsetTrack);
        this.update();
    }

    public boolean isNormalsVisible() {
        return this.normalsVisible;
    }

    protected void update() {
        Object object;
        Object object2;
        Object object3;
        double d;
        double d2;
        double d3;
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(this.parametricFunction2D.evaluate(0.0));
        for (d2 = d3 = 0.01; d2 < 1.0; d2 += d3) {
            doubleGeneralPath.lineTo(this.parametricFunction2D.evaluate(d2));
        }
        doubleGeneralPath.lineTo(this.parametricFunction2D.evaluate(1.0));
        this.phetPPath.setPathTo(doubleGeneralPath.getGeneralPath());
        this.updateControlPoints();
        this.topLayer.removeAllChildren();
        if (this.normalsVisible) {
            for (d2 = 0.0; d2 <= this.parametricFunction2D.getMetricDelta(0.0, 1.0); d2 += 0.1) {
                d = this.parametricFunction2D.getFractionalDistance(0.0, d2);
                object3 = this.parametricFunction2D.evaluate(d);
                object2 = new Arrow((Point2D)object3, this.parametricFunction2D.getUnitNormalVector(d).getScaledInstance(0.1).getDestination((Point2D)object3), 0.03f, 0.03f, 0.01f);
                object = new PhetPPath((Shape)((Arrow)object2).getShape(), (Paint)Color.black);
                this.topLayer.addChild((PNode)object);
            }
        }
        this.curvatureLayer.removeAllChildren();
        if (this.curvatureVisible) {
            for (d2 = 0.0; d2 <= this.parametricFunction2D.getMetricDelta(0.0, 1.0); d2 += 0.1) {
                d = this.parametricFunction2D.getFractionalDistance(0.0, d2);
                object3 = this.parametricFunction2D.evaluate(d);
                object2 = this.parametricFunction2D.getCurvatureDirection(d);
                object = new Arrow((Point2D)object3, object2.getScaledInstance(0.1).getDestination((Point2D)object3), 0.03f, 0.03f, 0.01f);
                PhetPPath phetPPath = new PhetPPath((Shape)((Arrow)object).getShape(), (Paint)Color.blue);
                this.curvatureLayer.addChild(phetPPath);
            }
        }
        this.topOffsetTrack.removeAllChildren();
        if (this.topOffsetTrackVisible) {
            d2 = 0.0;
            d = 0.005;
            object3 = new DoubleGeneralPath(this.parametricFunction2D.getOffsetPoint(d2, this.splineOffset, true));
            d2 += d;
            while (d2 <= 1.0) {
                ((DoubleGeneralPath)object3).lineTo(this.parametricFunction2D.getOffsetPoint(d2, this.splineOffset, true));
                d2 += d;
            }
            this.topOffsetTrack.addChild(new PhetPPath(((DoubleGeneralPath)object3).getGeneralPath(), (Stroke)new BasicStroke(0.01f), (Paint)Color.green));
        }
        this.bottomOffsetTrack.removeAllChildren();
        if (this.showBottomOffsetSpline) {
            d2 = 0.0;
            d = 0.005;
            object3 = new DoubleGeneralPath(this.parametricFunction2D.getOffsetPoint(d2, this.splineOffset, false));
            d2 += d;
            while (d2 <= 1.0) {
                ((DoubleGeneralPath)object3).lineTo(this.parametricFunction2D.getOffsetPoint(d2, this.splineOffset, false));
                d2 += d;
            }
            this.bottomOffsetTrack.addChild(new PhetPPath(((DoubleGeneralPath)object3).getGeneralPath(), (Stroke)new BasicStroke(0.01f), (Paint)Color.magenta));
        }
    }

    protected void updateControlPoints() {
    }

    public void setNormalsVisible(boolean bl) {
        this.normalsVisible = bl;
        this.update();
    }

    public boolean isCurvatureVisible() {
        return this.curvatureVisible;
    }

    public void setCurvatureVisible(boolean bl) {
        this.curvatureVisible = bl;
        this.update();
    }

    public void setShowTopOffsetSpline(boolean bl) {
        this.topOffsetTrackVisible = bl;
        this.update();
    }

    public void setOffsetSplineDistance(double d) {
        this.splineOffset = d;
        this.update();
    }

    public void setShowBottomOffsetSpline(boolean bl) {
        this.showBottomOffsetSpline = bl;
        this.update();
    }
}

