/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.model.physics;

import edu.colorado.phet.common.phetcommon.math.AbstractVector2D;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.SerializablePoint2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.energyskatepark.model.TraversalState;
import edu.colorado.phet.energyskatepark.model.physics.ParametricFunction2D;
import edu.colorado.phet.energyskatepark.model.physics.Particle1D;
import edu.colorado.phet.energyskatepark.model.physics.ParticleStage;
import edu.colorado.phet.energyskatepark.model.physics.TrackWithStickiness;
import java.awt.geom.Line2D;
import java.io.Serializable;
import java.util.ArrayList;

public class Particle
implements Serializable {
    private Particle1D particle1D;
    private double x;
    private double y;
    private double vx;
    private double vy;
    private double g = 9.8;
    private double mass = 1.0;
    private double elasticity = 0.6;
    private double stickiness = 0.25;
    private UpdateStrategy updateStrategy = new Particle1DUpdate();
    private ParticleStage particleStage;
    private boolean convertNormalVelocityToThermalOnLanding = true;
    private double angle = 0.0;
    private boolean userControlled = false;
    private double thermalEnergy = 0.0;
    private double zeroPointPotentialY;
    private double xThrust = 0.0;
    private double yThrust = 0.0;
    private double frictionCoefficient = 0.0;
    private boolean verboseDebug = true;
    private ArrayList listeners = new ArrayList();
    public static boolean reorientOnBounce = true;

    public Particle(ParticleStage particleStage) {
        this.particle1D = new Particle1D(particleStage.getCubicSpline2DCount() > 0 ? particleStage.getCubicSpline2D(0) : null, true, this.g);
        this.particleStage = particleStage;
        this.setUpdateStrategy(particleStage.getCubicSpline2DCount() > 0 ? new Particle1DUpdate() : new FreeFall());
        this.setMass(1.0);
    }

    public ParticleStage getParticleStage() {
        return this.particleStage;
    }

    public void stepInTime(double d) {
        if (!this.userControlled) {
            double d2 = this.getTotalEnergy();
            Class<?> clazz = this.updateStrategy.getClass();
            this.updateStrategy.stepInTime(d);
            double d3 = this.getTotalEnergy();
            double d4 = d3 - d2;
            if (Math.abs(d4) > 1.0E-6 && this.getThrust().getMagnitude() == 0.0) {
                System.out.println("Particle.stepInTime: de = " + d4 + ", strategy=" + clazz + ", newStrategy=" + this.updateStrategy.getClass());
            }
            this.update();
        }
    }

    public void setGravity(double d) {
        this.g = d;
        this.particle1D.setGravity(d);
    }

    public boolean isFreeFall() {
        return this.updateStrategy instanceof FreeFall;
    }

    public double getElasticity() {
        return this.elasticity;
    }

    public void setElasticity(double d) {
        this.elasticity = d;
    }

    public double getStickiness() {
        return this.stickiness;
    }

    public void setStickiness(double d) {
        this.stickiness = d;
    }

    public boolean isAboveSpline1D() {
        return this.particle1D.isSplineTop();
    }

    public Particle1D getParticle1D() {
        return this.particle1D;
    }

    public boolean isSplineMode() {
        return this.updateStrategy instanceof Particle1DUpdate;
    }

    public double getAngle() {
        return this.angle;
    }

    public double getKineticEnergy() {
        return 0.5 * this.mass * this.getSpeed() * this.getSpeed();
    }

    public double getTotalEnergy() {
        return this.getKineticEnergy() + this.getPotentialEnergy() + this.getThermalEnergy();
    }

    public double getThermalEnergy() {
        return this.thermalEnergy;
    }

    public double getHeightAboveZero() {
        return this.y - this.zeroPointPotentialY;
    }

    public double getPotentialEnergy() {
        return -this.mass * this.g * (this.y - this.zeroPointPotentialY);
    }

    public double getGravity() {
        return this.g;
    }

    public boolean isOnSpline(ParametricFunction2D parametricFunction2D) {
        return this.updateStrategy instanceof Particle1DUpdate && this.particle1D.getCubicSpline2D() == parametricFunction2D;
    }

    public ParametricFunction2D getSpline() {
        return this.updateStrategy instanceof Particle1DUpdate ? this.particle1D.getCubicSpline2D() : null;
    }

    public boolean isUserControlled() {
        return this.userControlled;
    }

    public void translate(double d, double d2) {
        this.setPosition(this.x + d, this.y + d2);
    }

    public void resetThermalEnergy() {
        this.thermalEnergy = 0.0;
        this.particle1D.setThermalEnergy(0.0);
    }

    public void setMass(double d) {
        this.mass = d;
        this.particle1D.setMass(d);
    }

    public void setZeroPointPotentialY(double d) {
        this.zeroPointPotentialY = d;
        this.particle1D.setZeroPointPotentialY(d);
    }

    public double getZeroPointPotentialY() {
        return this.zeroPointPotentialY;
    }

    public AbstractVector2D getThrust() {
        return new ImmutableVector2D.Double(this.xThrust, this.yThrust);
    }

    public void setThrust(double d, double d2) {
        this.xThrust = d;
        this.yThrust = d2;
        this.particle1D.setThrust(d, d2);
    }

    public TraversalState getTraversalState() {
        return this.particle1D.getTraversalState();
    }

    public void setFrictionCoefficient(double d) {
        this.frictionCoefficient = d;
        this.particle1D.setFrictionCoefficient(d);
    }

    public double getFrictionCoefficient() {
        return this.frictionCoefficient;
    }

    public TraversalState getTrackMatch(double d, double d2) {
        boolean[] blArray = this.getOrigAbove();
        SearchState searchState = this.getBestCrossPoint(new SerializablePoint2D(this.getPosition().getX() + d, this.getPosition().getY() + d2), this.getOrigAbove(), this.getPosition());
        if (searchState == null || searchState.getIndex() == -1) {
            return null;
        }
        return new TraversalState(searchState.getTrack(), blArray[searchState.getIndex()], searchState.getAlpha());
    }

    public boolean isSplineUserControlled() {
        return this.particleStage.isSplineUserControlled();
    }

    public double getMass() {
        return this.mass;
    }

    private void updateStateFrom1D() {
        this.x = this.particle1D.getX();
        this.y = this.particle1D.getY();
        AbstractVector2D abstractVector2D = this.particle1D.getVelocity2D();
        this.vx = abstractVector2D.getX();
        this.vy = abstractVector2D.getY();
        this.angle = this.particle1D.getSideVector().getAngle() - 1.5707963267948966;
        this.thermalEnergy = this.particle1D.getThermalEnergy();
    }

    public void setAngle(double d) {
        this.angle = d;
        this.update();
    }

    private void switchToFreeFall() {
        double d = this.particle1D.getEnergy();
        this.setVelocity(this.particle1D.getVelocity2D());
        this.setFreeFall();
        this.offsetOnSpline(this.particle1D.getCubicSpline2D(), this.particle1D.getAlpha(), this.particle1D.isSplineTop());
        this.particle1D.detach();
        double d2 = this.getTotalEnergy() - d;
        if (Math.abs(d2) > 1.0E-6) {
            System.out.println("Switching to freefall: energy discrepancy: dE=" + d2);
            if (d2 > 0.0) {
                this.testCorrectVelocity(d);
            }
        }
    }

    private void testCorrectVelocity(double d) {
        double d2 = this.getTotalEnergy() - d;
        if (Math.abs(this.getKineticEnergy()) > Math.abs(d2)) {
            this.verboseDebug("Could fix all energy by changing velocity.");
            this.correctEnergyReduceVelocity(d);
            this.verboseDebug("changed velocity: dE=" + (this.getTotalEnergy() - d));
            if (!MathUtil.isApproxEqual(d, this.getTotalEnergy(), 1.0E-8)) {
                new RuntimeException("Energy error[p0]").printStackTrace();
            }
        } else {
            System.out.println("can't correct with velocity correction");
        }
    }

    private void verboseDebug(String string) {
        if (this.verboseDebug) {
            System.out.println(string);
        }
    }

    private void correctEnergyReduceVelocity(double d) {
        double d2 = this.getVelocity().getMagnitude();
        for (int i = 0; i < 100; ++i) {
            double d3 = (this.getTotalEnergy() - d) / (this.mass * d2);
            this.setVelocity(this.getVelocity().getInstanceOfMagnitude(Math.abs(d2 -= d3)));
            if (MathUtil.isApproxEqual(d, this.getTotalEnergy(), 1.0E-8)) break;
        }
        this.setVelocity(this.getVelocity().getInstanceOfMagnitude(Math.abs(d2)));
    }

    public boolean isAboveSpline(int n) {
        return this.isAboveSpline(this.particleStage.getCubicSpline2D(n), this.particleStage.getCubicSpline2D(n).getClosestPoint(new SerializablePoint2D(this.x, this.y)), new SerializablePoint2D(this.x, this.y));
    }

    public boolean isAboveSplineZero() {
        return this.isAboveSpline(0);
    }

    public boolean[] getOrigAbove() {
        boolean[] blArray = new boolean[this.particleStage.getCubicSpline2DCount()];
        for (int i = 0; i < this.particleStage.getCubicSpline2DCount(); ++i) {
            blArray[i] = this.isAboveSpline(i);
        }
        return blArray;
    }

    public static double pointSegmentDistance(SerializablePoint2D serializablePoint2D, Line2D.Double double_) {
        SerializablePoint2D serializablePoint2D2 = new SerializablePoint2D(double_.getP1());
        SerializablePoint2D serializablePoint2D3 = new SerializablePoint2D(double_.getP2());
        double d = ((serializablePoint2D.getX() - serializablePoint2D2.getX()) * (serializablePoint2D3.getX() - serializablePoint2D2.getX()) + (serializablePoint2D.getY() - serializablePoint2D2.getY()) * (serializablePoint2D3.getY() - serializablePoint2D2.getY())) / serializablePoint2D2.distanceSq(serializablePoint2D3);
        if (d < 0.0) {
            return serializablePoint2D.distance(double_.getP1());
        }
        if (d > 1.0) {
            return serializablePoint2D.distance(double_.getP2());
        }
        SerializablePoint2D serializablePoint2D4 = new SerializablePoint2D(serializablePoint2D2.getX() + d * (serializablePoint2D3.getX() - serializablePoint2D2.getX()), serializablePoint2D2.getY() + d * (serializablePoint2D3.getY() - serializablePoint2D2.getY()));
        return serializablePoint2D4.distance(serializablePoint2D);
    }

    public TraversalState getBestTraversalState(SerializablePoint2D serializablePoint2D, AbstractVector2D abstractVector2D) {
        SearchState searchState = this.getBestSearchPoint(serializablePoint2D);
        AbstractVector2D abstractVector2D2 = searchState.getTrack().getUnitNormalVector(searchState.getAlpha());
        boolean bl = abstractVector2D2.dot(abstractVector2D) > 0.0;
        return new TraversalState(searchState.getTrack(), bl, searchState.getAlpha());
    }

    private SearchState getBestSearchPoint(SerializablePoint2D serializablePoint2D) {
        SearchState searchState = new SearchState(Double.POSITIVE_INFINITY, null, 0.0, -1);
        for (int i = 0; i < this.particleStage.getCubicSpline2DCount(); ++i) {
            double d;
            ParametricFunction2D parametricFunction2D = this.particleStage.getCubicSpline2D(i);
            double d2 = parametricFunction2D.getClosestPoint(serializablePoint2D);
            if (!(d2 > 0.0) || !(d2 < 1.0) || !((d = parametricFunction2D.evaluate(d2).distance(serializablePoint2D)) < searchState.getDistance())) continue;
            searchState.setDistance(d);
            searchState.setTrack(parametricFunction2D);
            searchState.setAlpha(d2);
            searchState.setIndex(i);
        }
        return searchState;
    }

    private void orientAngleOnTrack(ParametricFunction2D parametricFunction2D, double d, boolean bl) {
        this.setAngle(parametricFunction2D.getAngle(d) + (bl ? Math.PI : 0.0));
    }

    private SearchState getBestCrossPoint(SerializablePoint2D serializablePoint2D, boolean[] blArray, SerializablePoint2D serializablePoint2D2) {
        SearchState searchState = new SearchState(Double.POSITIVE_INFINITY, null, 0.0, -1);
        for (int i = 0; i < this.particleStage.getCubicSpline2DCount(); ++i) {
            double d;
            boolean bl;
            double d2;
            ParametricFunction2D parametricFunction2D = this.particleStage.getCubicSpline2D(i);
            boolean bl2 = this.isAboveSpline(parametricFunction2D, d2 = parametricFunction2D.getClosestPoint(new Line2D.Double(serializablePoint2D2, serializablePoint2D)), serializablePoint2D);
            boolean bl3 = bl = blArray[i] != bl2;
            if (!bl || !(d2 >= 0.0) || !(d2 <= 1.0) || !((d = Particle.pointSegmentDistance(parametricFunction2D.evaluate(d2), new Line2D.Double(serializablePoint2D2, serializablePoint2D))) < searchState.getDistance())) continue;
            searchState.setDistance(d);
            searchState.setTrack(parametricFunction2D);
            searchState.setAlpha(d2);
            searchState.setIndex(i);
        }
        return searchState;
    }

    private static double getTrackStickiness(ParametricFunction2D parametricFunction2D) {
        if (parametricFunction2D instanceof TrackWithStickiness) {
            TrackWithStickiness trackWithStickiness = (TrackWithStickiness)((Object)parametricFunction2D);
            return trackWithStickiness.getStickiness();
        }
        return 0.0;
    }

    private boolean isVelocityTowardTrack(SerializablePoint2D serializablePoint2D, ParametricFunction2D parametricFunction2D, double d) {
        Vector2D.Double double_;
        Vector2D.Double double_2 = this.getVelocity();
        return double_2.dot(double_ = new Vector2D.Double(serializablePoint2D, parametricFunction2D.evaluate(d))) > 0.0;
    }

    private void offsetOnSpline(ParametricFunction2D parametricFunction2D, double d, boolean bl) {
        AbstractVector2D abstractVector2D = parametricFunction2D.getUnitNormalVector(d);
        SerializablePoint2D serializablePoint2D = parametricFunction2D.evaluate(d);
        double d2 = bl ? 1.0 : -1.0;
        SerializablePoint2D serializablePoint2D2 = new SerializablePoint2D(abstractVector2D.getInstanceOfMagnitude(0.001 * d2).getDestination(serializablePoint2D));
        this.setPosition(serializablePoint2D2);
    }

    public void setVelocity(AbstractVector2D abstractVector2D) {
        this.setVelocity(abstractVector2D.getX(), abstractVector2D.getY());
    }

    public Vector2D.Double getVelocity() {
        return new Vector2D.Double(this.vx, this.vy);
    }

    public boolean isAboveSpline(ParametricFunction2D parametricFunction2D, double d, SerializablePoint2D serializablePoint2D) {
        AbstractVector2D abstractVector2D = parametricFunction2D.getUnitNormalVector(d);
        Vector2D.Double double_ = new Vector2D.Double(parametricFunction2D.evaluate(d), serializablePoint2D);
        return double_.dot(abstractVector2D) > 0.0;
    }

    public void setFreeFall() {
        this.setUpdateStrategy(new FreeFall());
    }

    public void switchToTrack(ParametricFunction2D parametricFunction2D, double d, boolean bl) {
        double d2;
        double d3;
        double d4 = this.getTotalEnergy();
        this.particle1D.setThermalEnergy(this.thermalEnergy);
        Vector2D.Double double_ = this.getVelocity();
        this.particle1D.setCubicSpline2D(parametricFunction2D, bl, d);
        double d5 = parametricFunction2D.getUnitParallelVector(d).dot(this.getVelocity()) > 0.0 ? 1.0 : -1.0;
        double d6 = this.convertNormalVelocityToThermalOnLanding ? this.getParallelSpeed(parametricFunction2D, d) : this.getSpeed();
        this.particle1D.setVelocity(d6 * d5);
        this.setUpdateStrategy(new Particle1DUpdate());
        AbstractVector2D abstractVector2D = this.particle1D.getVelocity2D();
        double d7 = abstractVector2D.dot(double_);
        if (d7 < 0.0) {
            System.out.println("Velocities were in contrary directions");
        }
        if ((d3 = (d2 = this.particle1D.getEnergy()) - d4) <= 0.0) {
            this.particle1D.addThermalEnergy(Math.abs(d3));
        } else {
            System.out.println("gained energy on landing, not solved yet");
        }
        this.updateStateFrom1D();
    }

    public boolean isConvertNormalVelocityToThermalOnLanding() {
        return this.convertNormalVelocityToThermalOnLanding;
    }

    public void setConvertNormalVelocityToThermalOnLanding(boolean bl) {
        this.convertNormalVelocityToThermalOnLanding = bl;
    }

    private double getParallelSpeed(ParametricFunction2D parametricFunction2D, double d) {
        return Math.abs(parametricFunction2D.getUnitParallelVector(d).dot(this.getVelocity()));
    }

    public double getSpeed() {
        return Math.sqrt(this.vx * this.vx + this.vy * this.vy);
    }

    public void setUserControlled(boolean bl) {
        this.userControlled = bl;
        if (bl) {
            this.setThermalEnergy(0.0);
        }
        if (!bl) {
            // empty if block
        }
    }

    public void setThermalEnergy(double d) {
        this.thermalEnergy = d;
        this.particle1D.setThermalEnergy(d);
    }

    public void setUpdateStrategy(UpdateStrategy updateStrategy) {
        this.updateStrategy = updateStrategy;
        this.update();
    }

    private void update() {
        this.notifyListeners();
    }

    public SerializablePoint2D getPosition() {
        return new SerializablePoint2D(this.x, this.y);
    }

    public void setPosition(SerializablePoint2D serializablePoint2D) {
        this.setPosition(serializablePoint2D.getX(), serializablePoint2D.getY());
    }

    public void setPosition(double d, double d2) {
        this.setFreeFall();
        this.x = d;
        this.y = d2;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setVelocity(double d, double d2) {
        this.vx = d;
        this.vy = d2;
        this.notifyListeners();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.particleChanged();
        }
    }

    public static interface Listener {
        public void particleChanged();
    }

    class FreeFall
    implements UpdateStrategy {
        FreeFall() {
        }

        public void stepInTime(double d) {
            boolean bl;
            SerializablePoint2D serializablePoint2D;
            SearchState searchState;
            double d2 = Particle.this.getTotalEnergy();
            boolean[] blArray = Particle.this.getOrigAbove();
            SerializablePoint2D serializablePoint2D2 = new SerializablePoint2D(Particle.this.x, Particle.this.y);
            double d3 = Particle.this.g + Particle.this.yThrust;
            double d4 = 0.0 + Particle.this.xThrust;
            Particle.this.vy += d3 * d;
            Particle.this.vx += d4 * d;
            Particle.this.y += Particle.this.vy * d + 0.5 * d3 * d * d;
            Particle.this.x += Particle.this.vx * d + 0.5 * d4 * d * d;
            double d5 = Particle.this.getTotalEnergy() - d2;
            if (this.shouldFixFreeFallEnergy()) {
                double d6 = d5 / (Particle.this.getMass() * Particle.this.getGravity());
                Particle.this.y += d6;
            }
            if (!Double.isInfinite((searchState = Particle.this.getBestCrossPoint(serializablePoint2D = new SerializablePoint2D(Particle.this.x, Particle.this.y), blArray, serializablePoint2D2)).getDistance())) {
                System.out.println("searchState.getDistance() = " + searchState.getDistance());
            }
            boolean bl2 = bl = searchState.getDistance() < 0.2;
            if (bl) {
                this.interactWithTrack(searchState, serializablePoint2D, serializablePoint2D2, blArray, d2, d);
            }
            double d7 = Particle.this.getTotalEnergy();
            if (this.shouldFixFreeFallEnergy() && Math.abs(d7 - d2) >= 1.0E-6) {
                System.out.println("Energy error in freefall, interactWithTrack=" + bl);
            }
        }

        private boolean shouldFixFreeFallEnergy() {
            return Math.abs(Particle.this.getMass() * Particle.this.getGravity()) > 1.0E-6 && Particle.this.xThrust == 0.0 && Particle.this.yThrust == 0.0;
        }

        private void interactWithTrack(SearchState searchState, SerializablePoint2D serializablePoint2D, SerializablePoint2D serializablePoint2D2, boolean[] blArray, double d, double d2) {
            ParametricFunction2D parametricFunction2D = searchState.getTrack();
            double d3 = searchState.getAlpha();
            AbstractVector2D abstractVector2D = parametricFunction2D.getUnitParallelVector(d3);
            AbstractVector2D abstractVector2D2 = parametricFunction2D.getUnitNormalVector(d3);
            AbstractVector2D abstractVector2D3 = abstractVector2D.getInstanceOfMagnitude(abstractVector2D.dot(Particle.this.getVelocity()));
            AbstractVector2D abstractVector2D4 = abstractVector2D2.getInstanceOfMagnitude(abstractVector2D2.dot(Particle.this.getVelocity())).getScaledInstance(Particle.this.elasticity);
            AbstractVector2D abstractVector2D5 = abstractVector2D3.getSubtractedInstance(abstractVector2D4);
            double d4 = Math.abs(abstractVector2D4.getMagnitude() / abstractVector2D5.getMagnitude());
            double d5 = Math.abs(Particle.this.getVelocity().getMagnitude() / Particle.this.getGravity() / d2);
            boolean bl = d4 >= Particle.this.stickiness + Particle.getTrackStickiness(parametricFunction2D);
            double d6 = 3.0;
            if (d5 < d6) {
                System.out.println("p = " + d5);
                System.out.println("Grabbing due to small speed (for this g and dt), threshold=" + d6 + ", v/(g*dt)=" + d5);
                bl = false;
            }
            double d7 = parametricFunction2D.getClosestPoint(serializablePoint2D);
            boolean bl2 = Particle.this.isVelocityTowardTrack(serializablePoint2D2, parametricFunction2D, d7);
            if (bl || !bl2) {
                double d8 = Particle.this.getTotalEnergy();
                Particle.this.setVelocity(abstractVector2D5);
                Particle.this.offsetOnSpline(parametricFunction2D, d7, blArray[searchState.getIndex()]);
                if (Particle.this.getTotalEnergy() > d8) {
                    Particle.this.correctEnergyReduceVelocity(d8);
                }
                Particle.this.thermalEnergy += d8 - Particle.this.getTotalEnergy();
                if (reorientOnBounce) {
                    Particle.this.orientAngleOnTrack(parametricFunction2D, d7, blArray[searchState.getIndex()]);
                }
            } else {
                double d9 = Particle.this.getTotalEnergy() - d;
                Particle.this.switchToTrack(parametricFunction2D, d7, blArray[searchState.getIndex()]);
                double d10 = Particle.this.getTotalEnergy() - d;
                double d11 = Particle.this.getTotalEnergy() - d;
                if (Math.abs(d11) > 1.0E-6) {
                    if (d11 < 0.0) {
                        Particle.this.thermalEnergy += Math.abs(d11);
                    } else {
                        Particle.this.particle1D.fixEnergy(Particle.this.particle1D.getAlpha(), d);
                        Particle.this.updateStateFrom1D();
                        double d12 = Particle.this.getTotalEnergy() - d;
                        if (Math.abs(d12) > 1.0E-6) {
                            System.out.println("particle1d couldn't fix, deleting thermal energy (temporary solution): dE=" + Math.abs(d12));
                            Particle.this.thermalEnergy -= Math.abs(d12);
                        }
                    }
                }
            }
        }
    }

    class SearchState {
        double distance;
        ParametricFunction2D track;
        double alpha;
        int index;

        public SearchState(double d, ParametricFunction2D parametricFunction2D, double d2, int n) {
            this.distance = d;
            this.track = parametricFunction2D;
            this.alpha = d2;
            this.index = n;
        }

        public double getDistance() {
            return this.distance;
        }

        public ParametricFunction2D getTrack() {
            return this.track;
        }

        public double getAlpha() {
            return this.alpha;
        }

        public int getIndex() {
            return this.index;
        }

        public void setDistance(double d) {
            this.distance = d;
        }

        public void setTrack(ParametricFunction2D parametricFunction2D) {
            this.track = parametricFunction2D;
        }

        public void setAlpha(double d) {
            this.alpha = d;
        }

        public void setIndex(int n) {
            this.index = n;
        }
    }

    class Particle1DUpdate
    implements UpdateStrategy,
    Serializable {
        Particle1DUpdate() {
        }

        public void stepInTime(double d) {
            AbstractVector2D abstractVector2D = Particle.this.particle1D.getSideVector();
            boolean bl = abstractVector2D.dot(Particle.this.particle1D.getCurvatureDirection()) < 0.0;
            double d2 = Math.abs(Particle.this.particle1D.getRadiusOfCurvature());
            double d3 = Particle.this.getMass() * Particle.this.particle1D.getSpeed() * Particle.this.particle1D.getSpeed() / d2;
            double d4 = Particle.this.particle1D.getNetForce().dot(Particle.this.particle1D.getCurvatureDirection());
            boolean bl2 = false;
            if (d4 < d3 && bl) {
                bl2 = true;
            }
            if (d4 > d3 && !bl) {
                bl2 = true;
            }
            if (bl2 && !Particle.this.particle1D.isRollerCoasterMode()) {
                Particle.this.switchToFreeFall();
                Particle.this.stepInTime(d);
            } else {
                Particle.this.particle1D.stepInTime(d);
                Particle.this.updateStateFrom1D();
                if (!Particle.this.particle1D.isReflect() && (Particle.this.particle1D.getAlpha() < 0.0 || Particle.this.particle1D.getAlpha() > 1.0)) {
                    Particle.this.switchToFreeFall();
                }
            }
        }
    }

    static interface UpdateStrategy
    extends Serializable {
        public void stepInTime(double var1);
    }
}

