/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.model.physics;

import edu.colorado.phet.common.phetcommon.math.AbstractVector2D;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.SerializablePoint2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.util.persistence.PersistenceUtil;
import edu.colorado.phet.energyskatepark.common.OptionalItemSerializableList;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkSpline;
import edu.colorado.phet.energyskatepark.model.TrackWithFriction;
import edu.colorado.phet.energyskatepark.model.TraversalState;
import edu.colorado.phet.energyskatepark.model.physics.CubicSpline2D;
import edu.colorado.phet.energyskatepark.model.physics.ParametricFunction2D;
import edu.colorado.phet.energyskatepark.model.physics.Particle1DNode;
import java.io.Serializable;
import java.util.List;

public class Particle1D
implements Serializable {
    private double alpha = 0.25;
    private double velocity = 0.0;
    private ParametricFunction2D track;
    private UpdateStrategy updateStrategy = new Euler();
    private double g;
    private double mass = 1.0;
    private List listeners = new OptionalItemSerializableList();
    private boolean splineTop = true;
    private boolean reflect = true;
    private double zeroPointPotentialY = 0.0;
    private double xThrust = 0.0;
    private double yThrust = 0.0;
    private double frictionCoefficient = 0.0;
    private double thermalEnergy = 0.0;
    private boolean debug = false;
    boolean verbose = false;
    double cachedRCAlpha;
    ParametricFunction2D cachedRCTrack = new CubicSpline2D(new SerializablePoint2D[]{new SerializablePoint2D(), new SerializablePoint2D()});
    double cachedRC = 0.0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Particle1D(ParametricFunction2D parametricFunction2D, boolean bl, double d) {
        this.track = parametricFunction2D;
        this.splineTop = bl;
        this.g = d;
    }

    public boolean isReflect() {
        return this.reflect;
    }

    public void setReflect(boolean bl) {
        this.reflect = bl;
    }

    public double getX() {
        return this.track.evaluate(this.alpha).getX();
    }

    public double getY() {
        return this.track.evaluate(this.alpha).getY();
    }

    private double getY(double d) {
        return this.track.evaluate(d).getY();
    }

    public AbstractVector2D getSideVector() {
        AbstractVector2D abstractVector2D = this.getCubicSpline2D().getUnitNormalVector(this.alpha);
        double d = this.isSplineTop() ? 1.0 : -1.0;
        return abstractVector2D.getInstanceOfMagnitude(d);
    }

    public void stepInTime(double d) {
        int n;
        double d2 = this.getEnergy();
        double d3 = this.alpha;
        double d4 = this.velocity;
        int n2 = 10;
        for (n = 0; n < n2; ++n) {
            this.updateStrategy.stepInTime(d / (double)n2);
        }
        if (!$assertionsDisabled && Double.isNaN(this.getEnergy())) {
            throw new AssertionError();
        }
        if (this.getThrust().getMagnitude() == 0.0) {
            this.fixEnergy(d3, d2);
        }
        for (n = 0; n < this.listeners.size(); ++n) {
            Particle1DNode particle1DNode = (Particle1DNode)this.listeners.get(n);
            particle1DNode.update();
        }
    }

    private Vector2D.Double getThrust() {
        return new Vector2D.Double(this.xThrust, this.yThrust);
    }

    public SerializablePoint2D getLocation() {
        return new SerializablePoint2D(this.getX(), this.getY());
    }

    public UpdateStrategy getUpdateStrategy() {
        return this.updateStrategy;
    }

    public void setUpdateStrategy(UpdateStrategy updateStrategy) {
        this.updateStrategy = updateStrategy;
    }

    public UpdateStrategy createVerlet() {
        return new Verlet();
    }

    public UpdateStrategy createConstantVelocity() {
        return new ConstantVelocity();
    }

    public void setVelocity(double d) {
        this.velocity = d;
    }

    public UpdateStrategy createEuler() {
        return new Euler();
    }

    private double getEnergy(double d, double d2) {
        return 0.5 * this.mass * d2 * d2 - this.mass * this.g * this.getY(d) + this.thermalEnergy;
    }

    public double getEnergy() {
        return this.getKineticEnergy() + this.getPotentialEnergy() + this.thermalEnergy;
    }

    private double getPotentialEnergy() {
        return -this.mass * this.g * (this.getY() - this.zeroPointPotentialY);
    }

    public double getKineticEnergy() {
        return 0.5 * this.mass * this.velocity * this.velocity;
    }

    public UpdateStrategy createVerletOffset(double d) {
        return new VerletOffset(d);
    }

    public double getAlpha() {
        return this.alpha;
    }

    public AbstractVector2D getVelocity2D() {
        return this.track.getUnitParallelVector(this.alpha).getInstanceOfMagnitude(this.velocity);
    }

    public void detach() {
        this.track = null;
    }

    public void setCubicSpline2D(ParametricFunction2D parametricFunction2D, boolean bl, double d) {
        this.track = parametricFunction2D;
        this.splineTop = bl;
        this.alpha = d;
    }

    public double getSpeed() {
        return Math.abs(this.velocity);
    }

    public AbstractVector2D getCurvatureDirection() {
        return this.track.getCurvatureDirection(this.alpha);
    }

    public ParametricFunction2D getCubicSpline2D() {
        return this.track;
    }

    public boolean isSplineTop() {
        return this.splineTop;
    }

    public void setGravity(double d) {
        this.g = d;
    }

    public void setMass(double d) {
        this.mass = d;
    }

    public void setZeroPointPotentialY(double d) {
        this.zeroPointPotentialY = d;
    }

    public void setThrust(double d, double d2) {
        this.xThrust = d;
        this.yThrust = d2;
    }

    public TraversalState getTraversalState() {
        return new TraversalState(this.track, this.splineTop, this.alpha);
    }

    public void setFrictionCoefficient(double d) {
        this.frictionCoefficient = d;
    }

    public double getThermalEnergy() {
        return this.thermalEnergy;
    }

    public void setThermalEnergy(double d) {
        this.thermalEnergy = d;
    }

    public void addThermalEnergy(double d) {
        this.setThermalEnergy(this.thermalEnergy + d);
    }

    public boolean isRollerCoasterMode() {
        if (this.track instanceof EnergySkateParkSpline.DefaultTrackSpline) {
            EnergySkateParkSpline.DefaultTrackSpline defaultTrackSpline = (EnergySkateParkSpline.DefaultTrackSpline)this.track;
            return defaultTrackSpline.isRollerCoasterMode();
        }
        return false;
    }

    private void handleBoundary() {
        if (this.reflect) {
            this.clampAndBounce();
        }
    }

    private void clampAndBounce() {
        this.alpha = MathUtil.clamp(0.0, this.alpha, 1.0);
        if (this.alpha <= 0.0) {
            this.velocity *= -1.0;
        }
        if (this.alpha >= 1.0) {
            this.velocity *= -1.0;
        }
    }

    void fixEnergy(double d, double d2) {
        this.fixEnergyHeuristic(d, d2);
    }

    private void fixEnergyHeuristic(double d, double d2) {
        if (Double.isNaN(this.getEnergy())) {
            throw new IllegalArgumentException();
        }
        double d3 = this.getEnergy() - d2;
        if (Math.abs(d3) < 1.0E-6) {
            // empty if block
        }
        if (this.getEnergy() > d2) {
            this.verboseDebug("Energy too high");
            if (Math.abs(this.getKineticEnergy()) > Math.abs(d3)) {
                this.verboseDebug("Could fix all energy by changing velocity.");
                this.correctEnergyReduceVelocity(d2);
                this.verboseDebug("changed velocity: dE=" + (this.getEnergy() - d2));
                if (!MathUtil.isApproxEqual(d2, this.getEnergy(), 1.0E-8)) {
                    new RuntimeException("Energy error[0]").printStackTrace();
                }
            } else {
                this.verboseDebug("Not enough KE to fix with velocity alone: normal:" + this.getCubicSpline2D().getUnitNormalVector(this.alpha));
                this.verboseDebug("changed position alpha: dE=" + (this.getEnergy() - d2));
                int n = 10;
                double d4 = (this.alpha + d) / 2.0;
                double d5 = (this.alpha - d) / 2.0;
                for (int i = 0; i < n; ++i) {
                    int n2 = 10;
                    d4 = this.searchAlpha(d4 - d5, d4 + d5, d2, n2);
                    d5 = (d4 - d5 - (d4 + d5)) / (double)n2;
                }
                this.alpha = d4;
                this.verboseDebug("changed position alpha: dE=" + (this.getEnergy() - d2));
                if (!MathUtil.isApproxEqual(d2, this.getEnergy(), 1.0E-8)) {
                    if (Math.abs(this.getKineticEnergy()) > Math.abs(d3)) {
                        this.verboseDebug("Fixed position some, still need to fix velocity as well.");
                        this.correctEnergyReduceVelocity(d2);
                        if (!MathUtil.isApproxEqual(d2, this.getEnergy(), 1.0E-8)) {
                            System.out.println("Changed position & Velocity and still had energy error");
                            new RuntimeException("Energy error[123]").printStackTrace();
                        }
                    } else {
                        System.out.println("Changed position, wanted to change velocity, but didn't have enough to fix it..., dE=" + (this.getEnergy() - d2));
                        new RuntimeException("Energy error[456]").printStackTrace();
                    }
                }
            }
        } else {
            if (Double.isNaN(this.getEnergy())) {
                throw new IllegalArgumentException();
            }
            this.verboseDebug("Energy too low");
            double d6 = Math.abs(2.0 / this.mass * (d2 - this.getPotentialEnergy() - this.thermalEnergy));
            double d7 = Math.sqrt(d6);
            this.velocity = d7 * (double)MathUtil.getSign(this.velocity);
            this.verboseDebug("Set velocity to match energy, when energy was low: ");
            this.verboseDebug("INC changed velocity: dE=" + (this.getEnergy() - d2));
            if (!MathUtil.isApproxEqual(d2, this.getEnergy(), 1.0E-8)) {
                new RuntimeException("Energy error[2]").printStackTrace();
            }
        }
    }

    private void verboseDebug(String string) {
        if (this.verbose) {
            System.out.println(string);
        }
    }

    private void correctEnergyReduceVelocity(double d) {
        for (int i = 0; i < 100; ++i) {
            double d2 = (this.getEnergy() - d) / (this.mass * this.velocity);
            this.velocity -= d2;
            if (MathUtil.isApproxEqual(d, this.getEnergy(), 1.0E-8)) break;
        }
    }

    private double searchAlpha(double d, double d2, double d3, int n) {
        double d4 = (d2 - d) / (double)n;
        double d5 = (d2 - d) / 2.0;
        double d6 = this.getEnergy(d5, this.velocity);
        for (int i = 0; i < n; ++i) {
            double d7 = d + d4 * (double)i;
            double d8 = this.getEnergy(d7, this.velocity);
            if (!(Math.abs(d8 - d3) <= Math.abs(d6))) continue;
            d6 = d8 - d3;
            d5 = d7;
        }
        this.verboseDebug("After " + n + " steps, origAlpha=" + d + ", stepAlpha=" + this.alpha + ", bestAlpha=" + d5 + ", dE=" + d6);
        return d5;
    }

    private static double getRadiusOfCurvatureStatic(double d, ParametricFunction2D parametricFunction2D) {
        return Particle1D.getRadiusOfCurvature(d, parametricFunction2D, 0.001);
    }

    private static double getRadiusOfCurvature(double d, ParametricFunction2D parametricFunction2D, double d2) {
        double d3;
        double d4 = d + parametricFunction2D.getFractionalDistance(d, -d2 / 2.0);
        double d5 = d + parametricFunction2D.getFractionalDistance(d, d2 / 2.0);
        double d6 = parametricFunction2D.evaluate(d4).distance(parametricFunction2D.evaluate(d5));
        for (d3 = parametricFunction2D.getAngle(d4) - parametricFunction2D.getAngle(d5); d3 > Math.PI; d3 -= Math.PI * 2) {
            System.out.println("|dTheta| was more than Pi radians, rotated by 2Pi");
        }
        while (d3 < -Math.PI) {
            System.out.println("|dTheta| was more than Pi radians, rotated by 2Pi");
            d3 += Math.PI * 2;
        }
        double d7 = d3 / d6;
        return 1.0 / d7;
    }

    double getRadiusOfCurvature() {
        if (this.cachedRCAlpha != this.alpha || !this.cachedRCTrack.equals(this.track)) {
            this.cachedRC = Particle1D.getRadiusOfCurvatureStatic(this.alpha, this.track);
            this.cachedRCAlpha = this.alpha;
            try {
                this.cachedRCTrack = (ParametricFunction2D)PersistenceUtil.copy(this.track);
            }
            catch (PersistenceUtil.CopyFailedException copyFailedException) {
                copyFailedException.printStackTrace();
            }
        }
        return this.cachedRC;
    }

    public AbstractVector2D getNormalForce() {
        double d = this.getRadiusOfCurvature();
        if (Double.isInfinite(d)) {
            d = 100000.0;
            Vector2D.Double double_ = new Vector2D.Double();
            double_.add(new Vector2D.Double(0.0, this.mass * this.g));
            double_.add(new Vector2D.Double(this.xThrust * this.mass, this.yThrust * this.mass));
            double d2 = this.mass * this.velocity * this.velocity / Math.abs(d) - double_.dot(this.getCurvatureDirection());
            return Vector2D.Double.parseAngleAndMagnitude(d2, this.getCurvatureDirection().getAngle());
        }
        Vector2D.Double double_ = new Vector2D.Double();
        double_.add(new Vector2D.Double(0.0, this.mass * this.g));
        double_.add(new Vector2D.Double(this.xThrust * this.mass, this.yThrust * this.mass));
        double d3 = this.mass * this.velocity * this.velocity / Math.abs(d) - double_.dot(this.getCurvatureDirection());
        return Vector2D.Double.parseAngleAndMagnitude(d3, this.getCurvatureDirection().getAngle());
    }

    public AbstractVector2D getNetForce() {
        Vector2D.Double double_ = new Vector2D.Double();
        double_.add(new Vector2D.Double(0.0, this.mass * this.g));
        double_.add(new Vector2D.Double(this.xThrust * this.mass, this.yThrust * this.mass));
        double_.add(this.getFrictionForce());
        return double_;
    }

    public AbstractVector2D getFrictionForce() {
        if (this.getTotalFriction() == 0.0 || this.getVelocity2D().getMagnitude() < 0.01) {
            return new Vector2D.Double();
        }
        AbstractVector2D abstractVector2D = this.getVelocity2D().getInstanceOfMagnitude(-this.getTotalFriction() * this.getNormalForce().getMagnitude() * 25.0);
        if (Double.isNaN(abstractVector2D.getMagnitude())) {
            throw new IllegalArgumentException();
        }
        return abstractVector2D;
    }

    private double getTotalFriction() {
        return this.frictionCoefficient + (this.track instanceof TrackWithFriction ? ((TrackWithFriction)((Object)this.track)).getFriction() : 0.0);
    }

    private void debug(String string) {
        if (this.debug) {
            System.out.println(string);
        }
    }

    static {
        $assertionsDisabled = !Particle1D.class.desiredAssertionStatus();
    }

    public class Euler
    implements UpdateStrategy {
        public void stepInTime(double d) {
            double d2 = Particle1D.this.getEnergy();
            SerializablePoint2D serializablePoint2D = Particle1D.this.getLocation();
            AbstractVector2D abstractVector2D = Particle1D.this.getNetForce();
            double d3 = Particle1D.this.track.getUnitParallelVector(Particle1D.this.alpha).dot(abstractVector2D) / Particle1D.this.mass;
            Particle1D.this.velocity += d3 * d;
            Particle1D.this.alpha += Particle1D.this.track.getFractionalDistance(Particle1D.this.alpha, Particle1D.this.velocity * d + 0.0 * d3 * d * d);
            if (Particle1D.this.getTotalFriction() > 0.0) {
                AbstractVector2D abstractVector2D2 = Particle1D.this.getFrictionForce();
                if (Double.isNaN(abstractVector2D2.getMagnitude())) {
                    throw new IllegalArgumentException();
                }
                double d4 = abstractVector2D2.getMagnitude() * Particle1D.this.getLocation().distance(serializablePoint2D);
                Particle1D.this.thermalEnergy += d4;
                if (Particle1D.this.getThrust().getMagnitude() == 0.0) {
                    if (Particle1D.this.getEnergy() < d2) {
                        Particle1D.this.thermalEnergy += Math.abs(Particle1D.this.getEnergy() - d2);
                        if (Math.abs(Particle1D.this.getEnergy() - d2) > 1.0E-6) {
                            System.out.println("Added thermal, dE=" + (Particle1D.this.getEnergy() - d2));
                        }
                    }
                    if (Particle1D.this.getEnergy() > d2) {
                        if (Math.abs(Particle1D.this.getEnergy() - d2) < d4) {
                            Particle1D.this.debug("gained energy, removing thermal (Would have to remove more than we gained)");
                        } else {
                            double d5 = Math.abs(Particle1D.this.getEnergy() - d2);
                            Particle1D.this.thermalEnergy -= d5;
                            if (Math.abs(Particle1D.this.getEnergy() - d2) > 1.0E-6) {
                                System.out.println("Removed thermal, dE=" + (Particle1D.this.getEnergy() - d2));
                            }
                        }
                    }
                }
            }
            if (Double.isNaN(Particle1D.this.getKineticEnergy())) {
                throw new IllegalArgumentException();
            }
            if (Double.isInfinite(Particle1D.this.getKineticEnergy())) {
                throw new IllegalArgumentException();
            }
            if (Double.isNaN(Particle1D.this.getVelocity2D().getMagnitude())) {
                throw new IllegalArgumentException();
            }
            Particle1D.this.handleBoundary();
        }
    }

    public class ConstantVelocity
    implements UpdateStrategy {
        public void stepInTime(double d) {
            Particle1D.this.alpha += Particle1D.this.track.getFractionalDistance(Particle1D.this.alpha, Particle1D.this.velocity * d);
            Particle1D.this.handleBoundary();
        }
    }

    public class Verlet
    implements UpdateStrategy {
        public void stepInTime(double d) {
            double d2 = 1.5707963267948966 - Particle1D.this.track.getAngle(Particle1D.this.alpha);
            double d3 = Particle1D.this.velocity * d - 0.5 * Particle1D.this.g * Math.cos(d2) * d * d;
            Particle1D.this.alpha += Particle1D.this.track.getFractionalDistance(Particle1D.this.alpha, d3);
            double d4 = 1.5707963267948966 - Particle1D.this.track.getAngle(Particle1D.this.alpha);
            Particle1D.this.velocity = Particle1D.this.velocity + Particle1D.this.g * (Math.cos(d2) + Math.cos(d4)) / 2.0 * d;
            Particle1D.this.handleBoundary();
        }
    }

    public class VerletOffset
    implements UpdateStrategy {
        private double L;

        public VerletOffset(double d) {
            this.L = d;
        }

        public void stepInTime(double d) {
            double d2 = Particle1D.this.getRadiusOfCurvature();
            double d3 = 1.5707963267948966 - Particle1D.this.track.getAngle(Particle1D.this.alpha);
            double d4 = Math.pow(d2 / (d2 + this.L), 2.0) * Particle1D.this.g * Math.cos(d3) * (1.0 + this.L / d2);
            double d5 = Particle1D.this.velocity * d - 0.5 * d4 * d * d;
            Particle1D.this.alpha += Particle1D.this.track.getFractionalDistance(Particle1D.this.alpha, d5);
            double d6 = 1.5707963267948966 - Particle1D.this.track.getAngle(Particle1D.this.alpha);
            double d7 = Math.pow(d2 / (d2 + this.L), 2.0) * Particle1D.this.g * (Math.cos(d3) + Math.cos(d6)) / 2.0 * (1.0 + this.L / d2);
            Particle1D.this.velocity = Particle1D.this.velocity + d7 * d;
            Particle1D.this.handleBoundary();
        }

        public void setL(double d) {
            this.L = d;
        }
    }

    public static interface UpdateStrategy
    extends Serializable {
        public void stepInTime(double var1);
    }
}

