/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.model.physics;

import edu.colorado.phet.energyskatepark.model.physics.ParametricFunction2D;
import java.io.Serializable;
import java.util.ArrayList;

public class ParticleStage
implements Serializable {
    private ArrayList splines = new ArrayList();
    private ArrayList listeners = new ArrayList();

    public void addCubicSpline2D(ParametricFunction2D parametricFunction2D) {
        this.splines.add(parametricFunction2D);
        this.notifySplineAdded();
    }

    public ParametricFunction2D getCubicSpline2D(int n) {
        return (ParametricFunction2D)this.splines.get(n);
    }

    public int getCubicSpline2DCount() {
        return this.splines.size();
    }

    public boolean isSplineUserControlled() {
        return false;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private void notifySplineRemoved() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.splineRemoved();
        }
    }

    private void notifySplineAdded() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.splineAdded();
        }
    }

    public String toStringSerialization() {
        String string = "";
        for (int i = 0; i < this.splines.size(); ++i) {
            ParametricFunction2D parametricFunction2D = (ParametricFunction2D)this.splines.get(i);
            string = string + parametricFunction2D.toStringSerialization();
        }
        return string;
    }

    public void clear() {
        while (this.splines.size() > 0) {
            this.removeSpline(this.splines.size() - 1);
        }
    }

    private void removeSpline(int n) {
        this.splines.remove(n);
        this.notifySplineRemoved();
    }

    public static interface Listener {
        public void splineAdded();

        public void splineRemoved();
    }
}

