/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.model.physics;

import edu.colorado.phet.energyskatepark.model.physics.CubicSpline2D;
import edu.colorado.phet.energyskatepark.model.physics.CubicSpline2DNode;
import edu.colorado.phet.energyskatepark.model.physics.ParametricFunction2DNode;
import edu.colorado.phet.energyskatepark.model.physics.ParticleStage;
import edu.umd.cs.piccolo.PNode;

public class SplineLayer
extends PNode {
    private ParticleStage particleStage;
    private boolean showTopOffsetSpline = false;
    private double offsetDistance = 0.9520000000000001;
    private boolean showBottomOffsetSpline = false;

    public SplineLayer(ParticleStage particleStage) {
        this.particleStage = particleStage;
        particleStage.addListener(new ParticleStage.Listener(){

            public void splineAdded() {
                SplineLayer.this.update();
            }

            public void splineRemoved() {
                SplineLayer.this.update();
            }
        });
        this.update();
    }

    private void update() {
        ParametricFunction2DNode parametricFunction2DNode;
        int n;
        while (this.particleStage.getCubicSpline2DCount() < this.getChildrenCount()) {
            this.removeChild(this.getChildrenCount() - 1);
        }
        while (this.particleStage.getCubicSpline2DCount() > this.getChildrenCount()) {
            this.addChild(new CubicSpline2DNode((CubicSpline2D)this.particleStage.getCubicSpline2D(this.particleStage.getCubicSpline2DCount() - 1)));
        }
        for (n = 0; n < this.getChildrenCount(); ++n) {
            parametricFunction2DNode = (CubicSpline2DNode)this.getChild(n);
            ((CubicSpline2DNode)parametricFunction2DNode).setCubicSpline2D((CubicSpline2D)this.particleStage.getCubicSpline2D(n));
        }
        for (n = 0; n < this.getChildrenCount(); ++n) {
            parametricFunction2DNode = (ParametricFunction2DNode)this.getChild(n);
            parametricFunction2DNode.setShowTopOffsetSpline(this.showTopOffsetSpline);
            parametricFunction2DNode.setShowBottomOffsetSpline(this.showBottomOffsetSpline);
        }
        for (n = 0; n < this.getChildrenCount(); ++n) {
            parametricFunction2DNode = (ParametricFunction2DNode)this.getChild(n);
            parametricFunction2DNode.setOffsetSplineDistance(this.offsetDistance);
        }
    }

    public void setNormalsVisible(boolean bl) {
        for (int i = 0; i < this.getChildrenCount(); ++i) {
            ParametricFunction2DNode parametricFunction2DNode = (ParametricFunction2DNode)this.getChild(i);
            parametricFunction2DNode.setNormalsVisible(bl);
        }
    }

    public boolean isNormalsVisible() {
        if (this.getChildrenCount() == 0) {
            return false;
        }
        return ((ParametricFunction2DNode)this.getChild(0)).isNormalsVisible();
    }

    public boolean isCurvatureVisible() {
        if (this.getChildrenCount() == 0) {
            return false;
        }
        return ((ParametricFunction2DNode)this.getChild(0)).isCurvatureVisible();
    }

    public void setCurvatureVisible(boolean bl) {
        for (int i = 0; i < this.getChildrenCount(); ++i) {
            ParametricFunction2DNode parametricFunction2DNode = (ParametricFunction2DNode)this.getChild(i);
            parametricFunction2DNode.setCurvatureVisible(bl);
        }
    }

    public boolean isShowTopOffsetSpline() {
        return this.showTopOffsetSpline;
    }

    public void setShowTopOffsetSpline(boolean bl) {
        this.showTopOffsetSpline = bl;
        this.update();
    }

    public double getOffsetDistance() {
        return this.offsetDistance;
    }

    public void setOffsetDistance(double d) {
        this.offsetDistance = d;
        this.update();
    }

    public boolean isShowBottomOffsetSpline() {
        return this.showBottomOffsetSpline;
    }

    public void setShowBottomOffsetSpline(boolean bl) {
        this.showBottomOffsetSpline = bl;
        this.update();
    }
}

