/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.model.physics;

import edu.colorado.phet.common.phetcommon.math.SerializablePoint2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.common.phetcommon.view.ClockControlPanel;
import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.energyskatepark.model.TraversalState;
import edu.colorado.phet.energyskatepark.model.physics.CubicSpline2D;
import edu.colorado.phet.energyskatepark.model.physics.DefaultTestSet;
import edu.colorado.phet.energyskatepark.model.physics.LinearSpline2D;
import edu.colorado.phet.energyskatepark.model.physics.ParametricFunction2DNode;
import edu.colorado.phet.energyskatepark.model.physics.Particle;
import edu.colorado.phet.energyskatepark.model.physics.Particle1D;
import edu.colorado.phet.energyskatepark.model.physics.ParticleImageNode;
import edu.colorado.phet.energyskatepark.model.physics.ParticleNode;
import edu.colorado.phet.energyskatepark.model.physics.ParticleStage;
import edu.colorado.phet.energyskatepark.model.physics.SplineLayer;
import edu.colorado.phet.energyskatepark.model.physics.TestJList;
import edu.colorado.phet.energyskatepark.model.physics.TestState;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TestPhysics1D
extends JFrame {
    private JFrame controlFrame;
    private SwingClock clock;
    private JFrame ccpFrame;
    private PSwingCanvas pSwingCanvas;
    private Particle particle;
    private ParticleStage particleStage = new ParticleStage();
    private SplineLayer splineLayer = new SplineLayer(this.particleStage);
    double totalONTrackError = 0.0;
    double totalOffTrackError = 0.0;
    private double normTerm = 0.0;

    public TestPhysics1D() {
        super("Test Physics 1D (1.05.08)");
        this.pSwingCanvas = new PSwingCanvas();
        this.pSwingCanvas.setPanEventHandler(null);
        this.pSwingCanvas.setZoomEventHandler(null);
        this.pSwingCanvas.setDefaultRenderQuality(1);
        this.setContentPane(this.pSwingCanvas);
        final CubicSpline2D cubicSpline2D = new CubicSpline2D(new SerializablePoint2D[]{new SerializablePoint2D(2.0, 1.0), new SerializablePoint2D(4.0, 2.0), new SerializablePoint2D(6.0, 1.0), new SerializablePoint2D(8.0, 4.0), new SerializablePoint2D(10.0, 1.0)});
        this.particleStage.addCubicSpline2D(cubicSpline2D);
        this.pSwingCanvas.getLayer().scale(65.0);
        this.pSwingCanvas.getLayer().addChild(this.splineLayer);
        this.setSize(800, 600);
        SerializablePoint2D[] serializablePoint2DArray = cubicSpline2D.getOffsetSpline(1.0, true, 100);
        final LinearSpline2D linearSpline2D = new LinearSpline2D(serializablePoint2DArray);
        final ParametricFunction2DNode parametricFunction2DNode = new ParametricFunction2DNode(linearSpline2D);
        parametricFunction2DNode.setVisible(false);
        this.pSwingCanvas.getLayer().addChild(parametricFunction2DNode);
        this.particle = new Particle(this.particleStage);
        final ParticleNode particleNode = new ParticleNode(this.particle);
        final ParticleImageNode particleImageNode = new ParticleImageNode(this.particle);
        this.pSwingCanvas.getLayer().addChild(particleNode);
        this.pSwingCanvas.getLayer().addChild(particleImageNode);
        int n = 30;
        this.clock = new SwingClock(n, (double)n / 1000.0);
        this.clock.addClockListener(new ClockAdapter(){

            public void simulationTimeChanged(ClockEvent clockEvent) {
                double d = TestPhysics1D.this.particle.getTotalEnergy();
                TestPhysics1D.this.particle.stepInTime(clockEvent.getSimulationTimeChange());
                double d2 = TestPhysics1D.this.particle.getTotalEnergy();
                double d3 = (d2 - d) / TestPhysics1D.this.normTerm;
            }
        });
        this.ccpFrame = new JFrame("Clock Controls");
        this.ccpFrame.setContentPane(new ClockControlPanel(this.clock));
        this.ccpFrame.pack();
        this.ccpFrame.setDefaultCloseOperation(3);
        this.ccpFrame.setLocation(this.getX(), this.getY() + this.getHeight());
        this.setDefaultCloseOperation(3);
        this.controlFrame = new JFrame();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
        final Particle1D particle1D = this.particle.getParticle1D();
        JRadioButton jRadioButton = new JRadioButton("Verlet", particle1D.getUpdateStrategy() instanceof Particle1D.Verlet);
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                particle1D.setVelocity(0.0);
                particle1D.setUpdateStrategy(particle1D.createVerlet());
            }
        });
        JRadioButton jRadioButton2 = new JRadioButton("Constant Velocity", particle1D.getUpdateStrategy() instanceof Particle1D.ConstantVelocity);
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                particle1D.setVelocity(1.0);
                particle1D.setUpdateStrategy(particle1D.createConstantVelocity());
            }
        });
        JRadioButton jRadioButton3 = new JRadioButton("Euler", particle1D.getUpdateStrategy() instanceof Particle1D.Euler);
        jRadioButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                particle1D.setVelocity(0.0);
                particle1D.setUpdateStrategy(particle1D.createEuler());
            }
        });
        JRadioButton jRadioButton4 = new JRadioButton("Verlet Offset", particle1D.getUpdateStrategy() instanceof Particle1D.VerletOffset);
        jRadioButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                particle1D.setVelocity(0.0);
                particle1D.setUpdateStrategy(particle1D.createVerletOffset(TestPhysics1D.this.splineLayer.getOffsetDistance()));
            }
        });
        JButton jButton = new JButton("Reset eergy errors");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestPhysics1D.this.totalOffTrackError = 0.0;
                TestPhysics1D.this.totalONTrackError = 0.0;
                TestPhysics1D.this.particle.switchToTrack(cubicSpline2D, 0.01, true);
                TestPhysics1D.this.normTerm = TestPhysics1D.this.particle.getTotalEnergy();
                System.out.println("normTerm = " + TestPhysics1D.this.normTerm);
            }
        });
        jPanel.add(jButton);
        final ModelSlider modelSlider = new ModelSlider("Mass", "units.kg", 0.1, 200.0, this.particle.getMass());
        modelSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TestPhysics1D.this.particle.setMass(modelSlider.getValue());
            }
        });
        jPanel.add((Component)modelSlider, gridBagConstraints);
        jPanel.add((Component)jRadioButton, gridBagConstraints);
        jPanel.add((Component)jRadioButton2, gridBagConstraints);
        jPanel.add((Component)jRadioButton3, gridBagConstraints);
        jPanel.add((Component)jRadioButton4, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton4);
        JButton jButton2 = new JButton("reset particle");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestPhysics1D.this.particle.setVelocity(0.0, 0.0);
                TestPhysics1D.this.particle.setPosition(2.5, 0.0);
            }
        });
        jPanel.add((Component)jButton2, gridBagConstraints);
        final JCheckBox jCheckBox = new JCheckBox("show (top) normals", this.splineLayer.isNormalsVisible());
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestPhysics1D.this.splineLayer.setNormalsVisible(jCheckBox.isSelected());
            }
        });
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        final JCheckBox jCheckBox2 = new JCheckBox("show curvature normals", this.splineLayer.isCurvatureVisible());
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestPhysics1D.this.splineLayer.setCurvatureVisible(jCheckBox2.isSelected());
            }
        });
        jPanel.add((Component)jCheckBox2, gridBagConstraints);
        JButton jButton3 = new JButton("print spline");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("particleStage = " + TestPhysics1D.this.particleStage.toStringSerialization());
            }
        });
        jPanel.add((Component)jButton3, gridBagConstraints);
        final ModelSlider modelSlider2 = new ModelSlider("Elasticity", "", 0.0, 1.0, this.particle.getElasticity());
        modelSlider2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TestPhysics1D.this.particle.setElasticity(modelSlider2.getValue());
            }
        });
        jPanel.add((Component)modelSlider2, gridBagConstraints);
        final ModelSlider modelSlider3 = new ModelSlider("Stickiness", "", 0.0, 2.0, this.particle.getStickiness());
        modelSlider3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TestPhysics1D.this.particle.setStickiness(modelSlider3.getValue());
            }
        });
        jPanel.add((Component)modelSlider3, gridBagConstraints);
        JButton jButton4 = new JButton("Update Particle Node");
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                particleImageNode.update();
                particleNode.update();
                if (TestPhysics1D.this.particle.isSplineMode()) {
                    System.out.println("particle.getParticle1D().getRadiusOfCurvature() = " + TestPhysics1D.this.particle.getParticle1D().getRadiusOfCurvature());
                }
            }
        });
        jPanel.add((Component)jButton4, gridBagConstraints);
        final JCheckBox jCheckBox3 = new JCheckBox("convert normal velocity to thermal on landing", this.particle.isConvertNormalVelocityToThermalOnLanding());
        jCheckBox3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestPhysics1D.this.particle.setConvertNormalVelocityToThermalOnLanding(jCheckBox3.isSelected());
            }
        });
        jPanel.add((Component)jCheckBox3, gridBagConstraints);
        TestJList testJList = new TestJList(new DefaultTestSet(), this);
        jPanel.add((Component)testJList, gridBagConstraints);
        final JCheckBox jCheckBox4 = new JCheckBox("reflect (1d)", this.particle.getParticle1D().isReflect());
        jCheckBox4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestPhysics1D.this.particle.getParticle1D().setReflect(jCheckBox4.isSelected());
            }
        });
        jPanel.add((Component)jCheckBox4, gridBagConstraints);
        final JCheckBox jCheckBox5 = new JCheckBox("Show Top Offset Spline", this.splineLayer.isShowTopOffsetSpline());
        jCheckBox5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestPhysics1D.this.splineLayer.setShowTopOffsetSpline(jCheckBox5.isSelected());
            }
        });
        jPanel.add((Component)jCheckBox5, gridBagConstraints);
        final JCheckBox jCheckBox6 = new JCheckBox("Show Bottom Offset Spline", this.splineLayer.isShowBottomOffsetSpline());
        jCheckBox6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestPhysics1D.this.splineLayer.setShowBottomOffsetSpline(jCheckBox6.isSelected());
            }
        });
        jPanel.add((Component)jCheckBox6, gridBagConstraints);
        final ModelSlider modelSlider4 = new ModelSlider("Offset Distance", "meters", 0.0, 1.7, this.splineLayer.getOffsetDistance());
        modelSlider4.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TestPhysics1D.this.splineLayer.setOffsetDistance(modelSlider4.getValue());
                if (particle1D.getUpdateStrategy() instanceof Particle1D.VerletOffset) {
                    Particle1D.VerletOffset verletOffset = (Particle1D.VerletOffset)particle1D.getUpdateStrategy();
                    verletOffset.setL(TestPhysics1D.this.splineLayer.getOffsetDistance());
                }
            }
        });
        jPanel.add((Component)modelSlider4, gridBagConstraints);
        final JCheckBox jCheckBox7 = new JCheckBox("Show Particle", particleNode.getVisible());
        jCheckBox7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                particleNode.setVisible(jCheckBox7.isSelected());
            }
        });
        jPanel.add((Component)jCheckBox7, gridBagConstraints);
        final JCheckBox jCheckBox8 = new JCheckBox("Show Character", particleImageNode.getVisible());
        jCheckBox8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                particleImageNode.setVisible(jCheckBox8.isSelected());
            }
        });
        jPanel.add((Component)jCheckBox8, gridBagConstraints);
        final JCheckBox jCheckBox9 = new JCheckBox("Centered character", particleImageNode.isCentered());
        jCheckBox9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                particleImageNode.setCentered(jCheckBox9.isSelected());
            }
        });
        jPanel.add((Component)jCheckBox9, gridBagConstraints);
        final JCheckBox jCheckBox10 = new JCheckBox("Linear track visible", parametricFunction2DNode.getVisible());
        jCheckBox10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                parametricFunction2DNode.setVisible(jCheckBox10.isSelected());
            }
        });
        jPanel.add((Component)jCheckBox10, gridBagConstraints);
        final ModelSlider modelSlider5 = new ModelSlider("set to linear", "", 0.0, 1.0, 0.5);
        modelSlider5.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TestPhysics1D.this.particle.switchToTrack(linearSpline2D, modelSlider5.getValue(), true);
            }
        });
        jPanel.add((Component)modelSlider5, gridBagConstraints);
        this.controlFrame.setContentPane(new JScrollPane(jPanel));
        final PhetPPath phetPPath = new PhetPPath((Shape)new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0), (Paint)Color.yellow);
        this.pSwingCanvas.getLayer().addChild(phetPPath);
        phetPPath.moveToBack();
        final PhetPPath phetPPath2 = new PhetPPath((Shape)new Rectangle2D.Double(0.0, 0.0, 0.2, 0.2), (Paint)Color.blue);
        this.pSwingCanvas.getLayer().addChild(phetPPath2);
        phetPPath.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseDragged(PInputEvent pInputEvent) {
                SerializablePoint2D serializablePoint2D = new SerializablePoint2D(pInputEvent.getPositionRelativeTo(phetPPath));
                System.out.println("coords = " + serializablePoint2D);
                TraversalState traversalState = TestPhysics1D.this.particle.getBestTraversalState(serializablePoint2D, new Vector2D.Double(1.0, 0.0));
                phetPPath2.setOffset(traversalState.getPosition());
            }
        });
        this.controlFrame.pack();
        this.controlFrame.setLocation(this.getX() + this.getWidth(), this.getY());
        this.controlFrame.setDefaultCloseOperation(3);
    }

    public static void main(String[] stringArray) {
        new TestPhysics1D().start();
    }

    public void setTestState(TestState testState) {
        this.particleStage.clear();
        for (int i = 0; i < testState.numCubicSpline2Ds(); ++i) {
            this.particleStage.addCubicSpline2D(new CubicSpline2D(testState.getCubicSpline2D(i)));
        }
        testState.init(this.particle, this.particleStage);
    }

    public void start() {
        this.setVisible(true);
        this.controlFrame.setVisible(true);
        this.ccpFrame.setVisible(true);
        this.clock.start();
    }
}

