/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.plots;

import edu.colorado.phet.common.phetcommon.view.util.PhetDefaultFont;
import edu.colorado.phet.common.piccolophet.BufferedPhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.ZoomControlNode;
import edu.colorado.phet.common.timeseries.model.TimeSeriesModel;
import edu.colorado.phet.energyskatepark.EnergySkateParkModule;
import edu.colorado.phet.energyskatepark.EnergySkateParkStrings;
import edu.colorado.phet.energyskatepark.common.SavedGraph;
import edu.colorado.phet.energyskatepark.model.Body;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import edu.colorado.phet.energyskatepark.plots.DefaultZoomControl;
import edu.colorado.phet.energyskatepark.plots.Range2D;
import edu.colorado.phet.energyskatepark.plots.VerticalZoomControl;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkLookAndFeel;
import edu.colorado.phet.energyskatepark.view.piccolo.EnergySkateParkLegend;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class EnergyPositionPlot
extends BufferedPhetPCanvas {
    private JFreeChart chart;
    private XYSeriesCollection dataset;
    private EnergySkateParkModule module;
    private PImage image;
    private ChartRenderingInfo info = new ChartRenderingInfo();
    private PPath verticalBar = new PPath(new Line2D.Double(0.0, 0.0, 0.0, 500.0));
    private EnergySkateParkLegend legend;
    private int saveCount = 1;
    private EnergyType ke;
    private EnergyType pe;
    private EnergyType thermal;
    private EnergyType total;
    private JPanel southPanel;
    private ZoomControlNode verticalZoom;
    private ZoomControlNode horizontalZoom;
    private PSwing southPSwing;
    private PNode dataLayer = new PNode();
    int count = 0;

    public EnergyPositionPlot(EnergySkateParkModule energySkateParkModule) {
        this.setBackground(EnergySkateParkLookAndFeel.backgroundColor);
        this.module = energySkateParkModule;
        this.ke = new EnergyType(this.module, EnergySkateParkStrings.getString("energy.kinetic"), this.module.getEnergyLookAndFeel().getKEColor(), this){

            public double getValue() {
                return this.getBody().getKineticEnergy();
            }
        };
        this.pe = new EnergyType(this.module, EnergySkateParkStrings.getString("energy.potential"), this.module.getEnergyLookAndFeel().getPEColor(), this){

            public double getValue() {
                return this.getBody().getPotentialEnergy();
            }
        };
        this.thermal = new EnergyType(this.module, EnergySkateParkStrings.getString("energy.thermal"), this.module.getEnergyLookAndFeel().getThermalEnergyColor(), this){

            public double getValue() {
                return this.getBody().getThermalEnergy();
            }
        };
        this.total = new EnergyType(energySkateParkModule, EnergySkateParkStrings.getString("energy.total"), this.module.getEnergyLookAndFeel().getTotalEnergyColor(), this){

            public double getValue() {
                return this.getBody().getTotalEnergy();
            }
        };
        energySkateParkModule.getEnergySkateParkModel().addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void preStep() {
                EnergyPositionPlot.this.update();
            }
        });
        energySkateParkModule.getTimeSeriesModel().addPlaybackTimeChangeListener(new TimeSeriesModel.PlaybackTimeListener(){

            public void timeChanged() {
                EnergyPositionPlot.this.update();
            }
        });
        this.dataset = new XYSeriesCollection(new XYSeries(new Integer(0)));
        this.chart = EnergyPositionPlot.createChart(new Range2D(-2.0, -700.0, 17.0, 7000.0), this.dataset, EnergySkateParkStrings.getString("plots.energy-vs-position"));
        this.setLayout(new BorderLayout());
        this.southPanel = new JPanel();
        JButton jButton = new JButton(EnergySkateParkStrings.getString("time.clear"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnergyPositionPlot.this.reset();
            }
        });
        JButton jButton2 = new JButton(EnergySkateParkStrings.getString("plots.copy"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnergyPositionPlot.this.copyChart();
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(2, 2));
        jPanel.add(this.ke.createCheckBox());
        jPanel.add(this.pe.createCheckBox());
        jPanel.add(this.thermal.createCheckBox());
        jPanel.add(this.total.createCheckBox());
        this.southPanel.add(jButton2);
        this.southPanel.add(jButton);
        this.southPanel.add(jPanel);
        this.southPSwing = new PSwing(this.southPanel);
        this.addScreenChild(this.southPSwing);
        this.chart.setAntiAlias(true);
        this.image = new PImage(new BufferedImage(10, 10, 1));
        this.addScreenChild(this.image);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                EnergyPositionPlot.this.updateGraphics();
            }

            public void componentShown(ComponentEvent componentEvent) {
                EnergyPositionPlot.this.updateGraphics();
            }
        });
        this.verticalBar.setStroke(new BasicStroke(1.0f, 2, 0, 1.0f, new float[]{10.0f, 3.0f}, 0.0f));
        this.verticalBar.setStrokePaint(Color.black);
        this.addScreenChild(this.verticalBar);
        this.legend = new EnergySkateParkLegend(energySkateParkModule);
        this.legend.addTotalEnergyEntry();
        this.legend.setFont(new PhetDefaultFont(12));
        this.addScreenChild(this.dataLayer);
        this.addScreenChild(this.legend);
        this.verticalZoom = new VerticalZoomControl(this.chart.getXYPlot().getRangeAxis()){

            protected void updateZoom() {
                super.updateZoom();
                EnergyPositionPlot.this.chartRangeChanged();
            }
        };
        this.horizontalZoom = new DefaultZoomControl(0, this.chart.getXYPlot().getDomainAxis()){

            protected void updateZoom() {
                double d = Math.min(0, -this.getZoom() * 10);
                double d2 = Math.max(15, this.getZoom() * 10 + 15);
                this.setZoomInEnabled(d2 - d > 15.0);
                this.setZoomOutEnabled(d2 - d < 500.0);
                this.getAxis().setRange(d, d2);
                EnergyPositionPlot.this.chartRangeChanged();
            }
        };
        this.addScreenChild(this.verticalZoom);
        this.addScreenChild(this.horizontalZoom);
        this.relayout();
        this.updateGraphics();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                EnergyPositionPlot.this.relayout();
            }

            public void componentShown(ComponentEvent componentEvent) {
                EnergyPositionPlot.this.relayout();
            }
        });
    }

    private void relayout() {
        this.horizontalZoom.setOffset(0.0, (double)this.getHeight() - this.horizontalZoom.getFullBounds().getHeight());
        this.verticalZoom.setOffset(this.horizontalZoom.getFullBounds().getX(), this.horizontalZoom.getFullBounds().getY() - this.verticalZoom.getFullBounds().getHeight());
        this.southPSwing.setOffset((double)this.getWidth() - this.southPSwing.getFullBounds().getWidth(), (double)this.getHeight() - this.southPSwing.getFullBounds().getHeight());
    }

    private void copyChart() {
        this.getPhetRootNode().invalidateFullBounds();
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        this.horizontalZoom.setVisible(false);
        this.verticalZoom.setVisible(false);
        this.paintComponent(bufferedImage.createGraphics());
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(null), bufferedImage.getHeight(null) - this.southPanel.getHeight(), 1);
        bufferedImage2.createGraphics().drawImage(bufferedImage, new AffineTransform(), null);
        String string = EnergySkateParkStrings.getString("plots.energy-vs-position-save");
        SavedGraph savedGraph = new SavedGraph(this.module.getPhetFrame(), string + this.saveCount + ")", bufferedImage2);
        savedGraph.setVisible(true);
        ++this.saveCount;
        this.horizontalZoom.setVisible(true);
        this.verticalZoom.setVisible(true);
    }

    private void updateGraphics() {
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            this.image.setImage(this.chart.createBufferedImage(this.getWidth(), this.getChartHeight(), this.info));
        }
        this.reset();
        this.legend.setOffset((double)this.getWidth() - this.legend.getFullBounds().getWidth() - 5.0, 5.0 + this.toImageLocation(0.0, this.chart.getXYPlot().getRangeAxis().getRange().getUpperBound()).getY());
    }

    private int getChartHeight() {
        return this.getHeight() - this.southPanel.getHeight();
    }

    private static JFreeChart createChart(Range2D range2D, XYDataset xYDataset, String string) {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(string, "Position", "Energy", xYDataset, PlotOrientation.VERTICAL, false, true, false);
        jFreeChart.setBackgroundPaint(EnergySkateParkLookAndFeel.backgroundColor);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.setBackgroundPaint(Color.white);
        xYPlot.getDomainAxis().setRange(range2D.getMinX(), range2D.getMaxX());
        xYPlot.getRangeAxis().setRange(range2D.getMinY(), range2D.getMaxY());
        xYPlot.setRangeCrosshairVisible(true);
        return jFreeChart;
    }

    public void reset() {
        while (this.dataLayer.getChildrenCount() > 0) {
            FadeDot fadeDot = (FadeDot)this.dataLayer.getChild(0);
            this.removeFadeDot(fadeDot);
        }
    }

    private void removeFadeDot(FadeDot fadeDot) {
        this.dataLayer.removeChild(fadeDot);
    }

    private void update() {
        ++this.count;
        if (!this.isActive()) {
            return;
        }
        if (this.module.getEnergySkateParkModel().getNumBodies() > 0) {
            Body body = this.module.getEnergySkateParkModel().getBody(0);
            double d = this.toImageLocation(body.getX(), 0.0).getX();
            this.verticalBar.setPathTo(new Line2D.Double(d, 0.0, d, this.getHeight()));
            this.addFadeDot(body.getX(), this.thermal);
            this.addFadeDot(body.getX(), this.pe);
            this.addFadeDot(body.getX(), this.total);
            this.addFadeDot(body.getX(), this.ke);
        }
        if (this.count % 10 == 0) {
            this.fadeDots();
        }
    }

    private void fadeDots() {
        for (int i = 0; i < this.dataLayer.getChildrenCount(); ++i) {
            FadeDot fadeDot = (FadeDot)this.dataLayer.getChild(i);
            fadeDot.fade();
            if (!fadeDot.isFullyFaded()) continue;
            this.dataLayer.removeChild(fadeDot);
            --i;
        }
    }

    private boolean isActive() {
        return SwingUtilities.getWindowAncestor(this) != null && SwingUtilities.getWindowAncestor(this).isVisible();
    }

    private void addFadeDot(double d, EnergyType energyType) {
        if (energyType.isVisible() && this.inBounds(d, energyType.getValue())) {
            FadeDot fadeDot = new FadeDot(energyType, this.toImageLocation(d, energyType.getValue()));
            this.dataLayer.addChild(fadeDot);
        }
    }

    private boolean inBounds(double d, double d2) {
        return this.chart.getXYPlot().getDomainAxis().getRange().contains(this.offsetData(d, d2).getX()) && this.chart.getXYPlot().getRangeAxis().getRange().contains(this.offsetData(d, d2).getY());
    }

    private Point2D offsetData(double d, double d2) {
        return new Point2D.Double(d - 1.0, d2);
    }

    public Point2D toImageLocation(double d, double d2) {
        d = this.offsetData(d, d2).getX();
        d2 = this.offsetData(d, d2).getY();
        Rectangle2D rectangle2D = this.info.getPlotInfo().getDataArea();
        if (rectangle2D == null) {
            throw new RuntimeException("Null data area");
        }
        rectangle2D = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        double d3 = this.chart.getXYPlot().getDomainAxisForDataset(0).valueToJava2D(d, rectangle2D, this.chart.getXYPlot().getDomainAxisEdge());
        double d4 = this.chart.getXYPlot().getRangeAxisForDataset(0).valueToJava2D(d2, rectangle2D, this.chart.getXYPlot().getRangeAxisEdge());
        return new Point2D.Double(d3, d4);
    }

    public void chartRangeChanged() {
        this.updateGraphics();
    }

    static abstract class EnergyType {
        private EnergySkateParkModule module;
        String name;
        private Color color;
        private EnergyPositionPlot energyPositionPlot;
        boolean visible = true;

        public EnergyType(EnergySkateParkModule energySkateParkModule, String string, Color color, EnergyPositionPlot energyPositionPlot) {
            this.module = energySkateParkModule;
            this.name = string;
            this.color = color;
            this.energyPositionPlot = energyPositionPlot;
        }

        public JCheckBox createCheckBox() {
            JCheckBox jCheckBox = new JCheckBox(this.name, true);
            jCheckBox.addActionListener(new ActionListener(this, jCheckBox){
                private final /* synthetic */ JCheckBox val$checkBox;
                private final /* synthetic */ EnergyType this$0;
                {
                    this.this$0 = energyType;
                    this.val$checkBox = jCheckBox;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.visible = this.val$checkBox.isSelected();
                    EnergyType.access$400(this.this$0).reset();
                }
            });
            return jCheckBox;
        }

        public abstract double getValue();

        public Body getBody() {
            return this.module.getEnergySkateParkModel().getBody(0);
        }

        public Color getColor() {
            return this.color;
        }

        public String getName() {
            return this.name;
        }

        public boolean isVisible() {
            return this.visible;
        }

        static /* synthetic */ EnergyPositionPlot access$400(EnergyType energyType) {
            return energyType.energyPositionPlot;
        }
    }

    static class FadeDot
    extends PPath {
        private Color origColor;
        private double age;
        private double dAge = 13.0;
        private Color fadeColor;
        private String name;

        public FadeDot(EnergyType energyType, Point2D point2D) {
            super(new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0), null);
            this.name = energyType.getName();
            this.setPaint(energyType.getColor());
            this.setOffset(point2D);
            this.origColor = energyType.getColor();
        }

        public void fade() {
            Color color;
            this.age += this.dAge;
            int n = (int)(255.0 - this.age);
            if (n < 0) {
                n = 0;
            }
            if (!(color = new Color(this.origColor.getRed(), this.origColor.getGreen(), this.origColor.getBlue(), n)).equals(this.fadeColor)) {
                this.setPaint(color);
                this.fadeColor = color;
            }
        }

        public boolean isFullyFaded() {
            return this.fadeColor.getAlpha() <= 0;
        }
    }
}

