/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.plots.bargraphs;

import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.ShadowHTMLNode;
import edu.colorado.phet.energyskatepark.plots.bargraphs.BarGraphic2D;
import edu.colorado.phet.energyskatepark.view.EnergyLookAndFeel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class BarGraph
extends PNode {
    private ShadowHTMLNode titleNode;
    private PNode frontLayer = new PNode();
    private PNode barLayer = new PNode();
    private double barChartHeight;
    private double barWidth;
    private double dw;
    private double sep;
    private double topY;
    private XAxis xAxis;
    private PPath background;
    private YAxis yAxis;
    private Variable[] variables;
    private double scale = 1.0;
    private PNode backLayer = new PNode();

    public BarGraph(String string, double d) {
        this.scale = d;
        this.topY = 0.0;
        this.barChartHeight = 400.0;
        this.barWidth = 20.0;
        this.dw = 7.0;
        this.sep = this.barWidth + this.dw;
        this.titleNode = new ShadowHTMLNode(string);
        this.titleNode.setColor(Color.black);
        this.titleNode.setShadowColor(Color.blue);
        this.titleNode.setFont(this.getTitleFont());
        PhetPPath phetPPath = new PhetPPath((Shape)this.titleNode.getFullBounds(), EnergyLookAndFeel.getLegendBackground());
        this.frontLayer.addChild(phetPPath);
        this.addChild(this.backLayer);
        this.addChild(this.barLayer);
        this.addChild(this.frontLayer);
    }

    protected Font getTitleFont() {
        return new Font("Lucida Sans", 1, 18);
    }

    public void setBarScale(double d) {
        this.scale = d;
        for (int i = 0; i < this.barLayer.getChildrenCount(); ++i) {
            BarGraphic2D barGraphic2D = (BarGraphic2D)this.barLayer.getChild(i);
            barGraphic2D.setBarScale(d);
        }
        this.update();
    }

    private void addBarGraphic(BarGraphic2D barGraphic2D) {
        this.barLayer.addChild(barGraphic2D);
    }

    public void setVariables(Variable[] variableArray) {
        this.variables = variableArray;
        double d = (double)variableArray.length * (this.sep + this.dw) - this.sep;
        this.background = new PPath(new Rectangle2D.Double(0.0, this.topY, 2.0 + d, 1000.0));
        this.background.setPaint(null);
        this.background.setStroke(new BasicStroke());
        this.background.setStrokePaint(null);
        this.frontLayer.addChild(this.background);
        this.xAxis = new XAxis();
        this.backLayer.addChild(this.xAxis);
        this.yAxis = new YAxis();
        this.frontLayer.addChild(this.yAxis);
        for (int i = 0; i < variableArray.length; ++i) {
            Variable variable = variableArray[i];
            int n = (int)((double)i * this.sep + this.dw);
            BarGraphic2D barGraphic2D = new BarGraphic2D(variable.getName(), this.scale, variable.getValue(), n, (int)this.barWidth, (int)this.barChartHeight, variable.getColor(), new Font("Lucida Sans", 1, 14));
            this.addBarGraphic(barGraphic2D);
        }
        this.frontLayer.addChild(this.titleNode);
        this.addPropertyChangeListener("visible", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BarGraph.this.update();
            }
        });
        this.update();
    }

    protected void update() {
        if (this.getVisible()) {
            for (int i = 0; i < this.barLayer.getChildrenCount(); ++i) {
                BarGraphic2D barGraphic2D = (BarGraphic2D)this.barLayer.getChild(i);
                barGraphic2D.setValue(this.variables[i].getValue());
            }
        }
    }

    private class YAxis
    extends PNode {
        private PPath path;

        public YAxis() {
            GeneralPath generalPath = this.createShape();
            this.path = new PPath(generalPath);
            this.path.setPaint(Color.black);
            this.addChild(this.path);
        }

        private GeneralPath createShape() {
            Point2D.Double double_ = new Point2D.Double(0.0, BarGraph.this.barChartHeight);
            Point2D.Double double_2 = new Point2D.Double(0.0, BarGraph.this.topY + 25.0);
            try {
                return new Arrow(double_, double_2, 8.0, 8.0, 3.0).getShape();
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                return new GeneralPath();
            }
        }
    }

    private class XAxis
    extends PNode {
        private PPath path = new PPath(this.createLinePath());

        public XAxis() {
            this.addChild(this.path);
            this.path.setStrokePaint(new Color(255, 150, 150));
            this.path.setStroke(new BasicStroke(3.0f));
        }

        private Line2D.Double createLinePath() {
            return new Line2D.Double(0.0, BarGraph.this.barChartHeight, BarGraph.this.background.getFullBounds().getWidth(), BarGraph.this.barChartHeight);
        }
    }

    public static class Variable {
        private String name;
        private double value;
        private Color color;

        public Variable(String string, double d, Color color) {
            this.name = string;
            this.value = d;
            this.color = color;
        }

        public String getName() {
            return this.name;
        }

        public double getValue() {
            return this.value;
        }

        public Color getColor() {
            return this.color;
        }
    }
}

