/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.plots.bargraphs;

import edu.colorado.phet.energyskatepark.EnergySkateParkStrings;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import edu.colorado.phet.energyskatepark.plots.bargraphs.BarGraph;
import edu.colorado.phet.energyskatepark.plots.bargraphs.ValueAccessor;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkSimulationPanel;

public class EnergySkateParkBarGraph
extends BarGraph {
    private EnergySkateParkModel model;

    public EnergySkateParkBarGraph(EnergySkateParkSimulationPanel energySkateParkSimulationPanel, EnergySkateParkModel energySkateParkModel, double d) {
        this(energySkateParkSimulationPanel, energySkateParkModel, EnergySkateParkStrings.getString("properties.energy"), d);
        ValueAccessor[] valueAccessorArray = new ValueAccessor[]{new ValueAccessor.KineticEnergy(energySkateParkSimulationPanel.getEnergySkateParkModule().getEnergyLookAndFeel()), new ValueAccessor.PotentialEnergy(energySkateParkSimulationPanel.getEnergySkateParkModule().getEnergyLookAndFeel()), new ValueAccessor.ThermalEnergy(energySkateParkSimulationPanel.getEnergySkateParkModule().getEnergyLookAndFeel()), new ValueAccessor.TotalEnergy(energySkateParkSimulationPanel.getEnergySkateParkModule().getEnergyLookAndFeel())};
        BarGraph.Variable[] variableArray = EnergySkateParkBarGraph.toVariableArray(valueAccessorArray, energySkateParkModel);
        this.setVariables(variableArray);
    }

    public EnergySkateParkBarGraph(EnergySkateParkSimulationPanel energySkateParkSimulationPanel, EnergySkateParkModel energySkateParkModel, String string, double d) {
        super(string, d);
        this.model = energySkateParkModel;
        energySkateParkSimulationPanel.getEnergySkateParkModel().addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void primaryBodyChanged() {
                EnergySkateParkBarGraph.this.update();
            }
        });
    }

    public static BarGraph.Variable[] toVariableArray(final ValueAccessor[] valueAccessorArray, final EnergySkateParkModel energySkateParkModel) {
        BarGraph.Variable[] variableArray = new BarGraph.Variable[valueAccessorArray.length];
        for (int i = 0; i < variableArray.length; ++i) {
            final int n = i;
            variableArray[i] = new BarGraph.Variable(valueAccessorArray[n].getName(), valueAccessorArray[n].getValue(energySkateParkModel), valueAccessorArray[n].getColor()){

                public double getValue() {
                    return valueAccessorArray[n].getValue(energySkateParkModel);
                }
            };
        }
        return variableArray;
    }
}

