/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.serialization;

import edu.colorado.phet.common.phetcommon.util.persistence.Point2DPersistenceDelegate;
import edu.colorado.phet.common.servicemanager.InputStreamFileContents;
import edu.colorado.phet.common.servicemanager.PhetServiceManager;
import edu.colorado.phet.energyskatepark.EnergySkateParkModule;
import edu.colorado.phet.energyskatepark.serialization.EnergySkateParkModuleBean;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkSimulationPanel;
import java.awt.geom.Point2D;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.UnavailableServiceException;
import javax.swing.JButton;

public class EnergySkateParkIO {
    public static void save(EnergySkateParkModule energySkateParkModule) throws UnavailableServiceException, IOException {
        EnergySkateParkSimulationPanel energySkateParkSimulationPanel = energySkateParkModule.getEnergySkateParkSimulationPanel();
        String string = EnergySkateParkIO.toXMLString(energySkateParkModule);
        System.out.println("xml = " + string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        InputStreamFileContents inputStreamFileContents = new InputStreamFileContents("esp_output", byteArrayInputStream);
        FileSaveService fileSaveService = PhetServiceManager.getFileSaveService(energySkateParkSimulationPanel);
        FileContents fileContents = fileSaveService.saveAsFileDialog(null, null, inputStreamFileContents);
        System.out.println("Saved file.");
    }

    private static String toXMLString(EnergySkateParkModule energySkateParkModule) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLEncoder xMLEncoder = new XMLEncoder(byteArrayOutputStream);
        xMLEncoder.setPersistenceDelegate(Point2D.Double.class, new Point2DPersistenceDelegate());
        xMLEncoder.writeObject(new EnergySkateParkModuleBean(energySkateParkModule));
        xMLEncoder.writeObject(new JButton("My Button"));
        xMLEncoder.close();
        return byteArrayOutputStream.toString();
    }

    public static void open(EnergySkateParkModule energySkateParkModule) throws UnavailableServiceException, IOException {
        FileOpenService fileOpenService = PhetServiceManager.getFileOpenService(energySkateParkModule.getEnergySkateParkSimulationPanel());
        FileContents fileContents = fileOpenService.openFileDialog(null, null);
        if (fileContents == null) {
            return;
        }
        XMLDecoder xMLDecoder = new XMLDecoder(fileContents.getInputStream());
        Object object = xMLDecoder.readObject();
        if (object instanceof EnergySkateParkModuleBean) {
            EnergySkateParkModuleBean energySkateParkModuleBean = (EnergySkateParkModuleBean)object;
            energySkateParkModuleBean.apply(energySkateParkModule);
        }
    }

    public static void open(String string, EnergySkateParkModule energySkateParkModule) {
        System.out.println("filename = " + string);
        XMLDecoder xMLDecoder = new XMLDecoder(Thread.currentThread().getContextClassLoader().getResourceAsStream(string));
        Object object = xMLDecoder.readObject();
        if (object instanceof EnergySkateParkModuleBean) {
            EnergySkateParkModuleBean energySkateParkModuleBean = (EnergySkateParkModuleBean)object;
            energySkateParkModuleBean.apply(energySkateParkModule);
        }
    }
}

