/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.serialization;

import edu.colorado.phet.common.phetcommon.math.SerializablePoint2D;
import edu.colorado.phet.energyskatepark.EnergySkateParkModule;
import edu.colorado.phet.energyskatepark.SkaterCharacterSet;
import edu.colorado.phet.energyskatepark.model.Body;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkSpline;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class EnergySkateParkModuleBean {
    private ArrayList bodies = new ArrayList();
    private ArrayList splines = new ArrayList();
    private double gravity = -9.81;

    public EnergySkateParkModuleBean() {
    }

    public EnergySkateParkModuleBean(EnergySkateParkModule energySkateParkModule) {
        int n;
        for (n = 0; n < energySkateParkModule.getEnergySkateParkModel().getNumBodies(); ++n) {
            this.addBody(energySkateParkModule.getEnergySkateParkModel().getBody(n));
        }
        for (n = 0; n < energySkateParkModule.getEnergySkateParkModel().getNumSplines(); ++n) {
            EnergySkateParkSpline energySkateParkSpline = energySkateParkModule.getEnergySkateParkModel().getSpline(n);
            this.addSplineSurface(energySkateParkSpline);
        }
        this.gravity = energySkateParkModule.getEnergySkateParkModel().getGravity();
    }

    public double getGravity() {
        return this.gravity;
    }

    public void setGravity(double d) {
        this.gravity = d;
    }

    private void addSplineSurface(EnergySkateParkSpline energySkateParkSpline) {
        this.splines.add(new SplineElement(energySkateParkSpline));
    }

    private void addBody(Body body) {
        this.bodies.add(new BodyElement(body));
    }

    public ArrayList getSplines() {
        return this.splines;
    }

    public void setSplines(ArrayList arrayList) {
        this.splines = arrayList;
    }

    public ArrayList getBodies() {
        return this.bodies;
    }

    public void setBodies(ArrayList arrayList) {
        this.bodies = arrayList;
    }

    public void apply(EnergySkateParkModule energySkateParkModule) {
        Object object;
        int n;
        energySkateParkModule.getEnergySkateParkModel().removeAllBodies();
        for (n = 0; n < this.bodies.size(); ++n) {
            object = energySkateParkModule.createBody();
            ((BodyElement)this.bodies.get(n)).apply((Body)object);
            energySkateParkModule.getEnergySkateParkModel().addBody((Body)object);
        }
        energySkateParkModule.getEnergySkateParkModel().removeAllSplineSurfaces();
        for (n = 0; n < this.splines.size(); ++n) {
            object = (SplineElement)this.splines.get(n);
            energySkateParkModule.getEnergySkateParkModel().addSplineSurface(((SplineElement)object).toEnergySkateParkSpline());
        }
        energySkateParkModule.getEnergySkateParkModel().updateFloorState();
        energySkateParkModule.getEnergySkateParkModel().setGravity(this.gravity);
        energySkateParkModule.setSkaterCharacter(SkaterCharacterSet.getDefaultCharacter());
    }

    public static class SplineElement {
        private Point2D[] controlPoints;
        private boolean rollerCoaster;

        public SplineElement() {
        }

        public SplineElement(EnergySkateParkSpline energySkateParkSpline) {
            SerializablePoint2D[] serializablePoint2DArray = energySkateParkSpline.getControlPoints();
            this.controlPoints = new Point2D[serializablePoint2DArray.length];
            for (int i = 0; i < serializablePoint2DArray.length; ++i) {
                this.controlPoints[i] = new Point2D.Double(serializablePoint2DArray[i].getX(), serializablePoint2DArray[i].getY());
            }
            this.rollerCoaster = energySkateParkSpline.isRollerCoasterMode();
        }

        public Point2D[] getControlPoints() {
            return this.controlPoints;
        }

        public boolean isRollerCoaster() {
            return this.rollerCoaster;
        }

        public void setRollerCoaster(boolean bl) {
            this.rollerCoaster = bl;
        }

        public void setControlPoints(Point2D[] point2DArray) {
            this.controlPoints = point2DArray;
        }

        public EnergySkateParkSpline toEnergySkateParkSpline() {
            SerializablePoint2D[] serializablePoint2DArray = new SerializablePoint2D[this.controlPoints.length];
            for (int i = 0; i < serializablePoint2DArray.length; ++i) {
                serializablePoint2DArray[i] = new SerializablePoint2D(this.controlPoints[i]);
            }
            EnergySkateParkSpline energySkateParkSpline = new EnergySkateParkSpline(serializablePoint2DArray);
            energySkateParkSpline.setRollerCoasterMode(this.rollerCoaster);
            return energySkateParkSpline;
        }
    }

    public static class BodyElement {
        private Point2D.Double position;
        private Point2D.Double velocity;
        private Point2D.Double acceleration;
        private double angularVelocity;
        private double frictionCoefficient;
        private double mass;
        private double thermalEnergy;
        private double attachmentPointRotation;
        private boolean freeFrame;
        private BodyElement restorePoint;

        public BodyElement() {
        }

        public BodyElement(Body body) {
            this.position = new Point2D.Double(body.getPosition().getX(), body.getPosition().getY());
            this.velocity = new Point2D.Double(body.getVelocity().getX(), body.getVelocity().getY());
            this.angularVelocity = body.getAngularVelocity();
            this.frictionCoefficient = body.getFrictionCoefficient();
            this.mass = body.getMass();
            this.thermalEnergy = body.getThermalEnergy();
            this.freeFrame = body.isFreeFallMode();
            this.attachmentPointRotation = body.getAngle();
            this.restorePoint = body.isRestorePointSet() ? new BodyElement(body.getRestorePoint()) : null;
        }

        public BodyElement getRestorePoint() {
            return this.restorePoint;
        }

        public void setRestorePoint(BodyElement bodyElement) {
            this.restorePoint = bodyElement;
        }

        public void apply(Body body) {
            body.setPosition(this.position.getX(), this.position.getY());
            body.setVelocity(this.velocity.x, this.velocity.y);
            body.setAngularVelocity(this.angularVelocity);
            body.setFrictionCoefficient(this.frictionCoefficient);
            body.setMass(this.mass);
            if (this.restorePoint != null) {
                Body body2 = new Body(body.getWidth(), body.getHeight(), body.getParticleStage(), body.getGravity(), body.getZeroPointPotentialY(), body.getSkaterCharacter());
                this.restorePoint.apply(body2);
                body.setRestorePoint(body2);
            }
        }

        public boolean isFreeFrame() {
            return this.freeFrame;
        }

        public void setFreeFrame(boolean bl) {
            this.freeFrame = bl;
        }

        public double getAttachmentPointRotation() {
            return this.attachmentPointRotation;
        }

        public void setAttachmentPointRotation(double d) {
            this.attachmentPointRotation = d;
        }

        public double getAngularVelocity() {
            return this.angularVelocity;
        }

        public void setAngularVelocity(double d) {
            this.angularVelocity = d;
        }

        public double getFrictionCoefficient() {
            return this.frictionCoefficient;
        }

        public void setFrictionCoefficient(double d) {
            this.frictionCoefficient = d;
        }

        public double getMass() {
            return this.mass;
        }

        public void setMass(double d) {
            this.mass = d;
        }

        public double getThermalEnergy() {
            return this.thermalEnergy;
        }

        public void setThermalEnergy(double d) {
            this.thermalEnergy = d;
        }

        public Point2D.Double getPosition() {
            return this.position;
        }

        public void setPosition(Point2D.Double double_) {
            this.position = double_;
        }

        public Point2D.Double getVelocity() {
            return this.velocity;
        }

        public void setVelocity(Point2D.Double double_) {
            this.velocity = double_;
        }

        public Point2D.Double getAcceleration() {
            return this.acceleration;
        }

        public void setAcceleration(Point2D.Double double_) {
            this.acceleration = double_;
        }
    }
}

