/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.test;

import edu.colorado.phet.common.phetcommon.math.SerializablePoint2D;
import edu.colorado.phet.energyskatepark.EnergySkateParkApplication;
import edu.colorado.phet.energyskatepark.model.Body;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkSpline;

public class SearchForFallthrough {
    public static void searchFallThrough1() {
        SearchForFallthrough.runExperiment(new String[0], new ExperimentParam(2.0, 1.9));
    }

    public static void searchFallThrough2() {
        SearchForFallthrough.runExperiment(new String[0], new ExperimentParam(3.0, 1.5));
    }

    private static void runExperiment(String[] stringArray, ExperimentParam experimentParam) {
        EnergySkateParkApplication energySkateParkApplication = new EnergySkateParkApplication(stringArray);
        energySkateParkApplication.getModule().getEnergySkateParkModel().removeAllSplineSurfaces();
        int n = 1;
        int n2 = 8;
        EnergySkateParkSpline energySkateParkSpline = new EnergySkateParkSpline(SearchForFallthrough.createDoubleWell(experimentParam.sx, n, n2, 9.0));
        energySkateParkApplication.getModule().getEnergySkateParkModel().addSplineSurface(energySkateParkSpline);
        int n3 = 40;
        for (int i = 0; i < n3; ++i) {
            Body body = energySkateParkApplication.getModule().createBody();
            body.setPosition(energySkateParkSpline.getControlPoint(1).getX(), energySkateParkSpline.getControlPoint(1).getY() + 1.0E-4);
            double d = (double)(n2 - n) * body.getMass() * Math.abs(-9.81);
            double d2 = Math.sqrt(2.0 * d / body.getMass());
            double d3 = d2 * 0.05;
            double d4 = (0.5 - (double)i / (double)n3) * 2.0 * d3;
            System.out.println("velocity=" + d2 + ", dv = " + d4);
            body.setVelocity((d2 + d4) * experimentParam.energyScale, 0.0);
            body.setSpline(energySkateParkSpline, false, 0.2);
            energySkateParkApplication.getModule().getEnergySkateParkModel().addBody(body);
        }
        energySkateParkApplication.startApplication();
    }

    private static SerializablePoint2D[] createDoubleWell(double d, double d2, double d3, double d4) {
        return new SerializablePoint2D[]{new SerializablePoint2D(0.0 * d, d4), new SerializablePoint2D(1.0 * d, d2), new SerializablePoint2D(2.0 * d, d3), new SerializablePoint2D(3.0 * d, d2), new SerializablePoint2D(4.0 * d, d4)};
    }

    static class ExperimentParam {
        double sx;
        double energyScale;

        public ExperimentParam(double d, double d2) {
            this.sx = d;
            this.energyScale = d2;
        }
    }
}

