/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view;

import edu.colorado.phet.common.phetcommon.view.AdvancedPanel;
import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.energyskatepark.EnergySkateParkModule;
import edu.colorado.phet.energyskatepark.EnergySkateParkStrings;
import edu.colorado.phet.energyskatepark.common.IconComponent;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkSimulationPanel;
import edu.colorado.phet.energyskatepark.view.swing.ChooseCharacterDialog;
import edu.colorado.phet.energyskatepark.view.swing.ClearHeatButton;
import edu.colorado.phet.energyskatepark.view.swing.EditSkaterPanel;
import edu.colorado.phet.energyskatepark.view.swing.FrictionControl;
import edu.colorado.phet.energyskatepark.view.swing.GridLinesCheckBox;
import edu.colorado.phet.energyskatepark.view.swing.LocationControlPanel;
import edu.colorado.phet.energyskatepark.view.swing.PathRecordContol;
import edu.colorado.phet.energyskatepark.view.swing.PieChartControlPanel;
import edu.umd.cs.piccolo.PNode;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class EnergySkateParkControlPanel
extends ControlPanel {
    private EnergySkateParkModule module;
    private PieChartControlPanel piePanel;
    private PathRecordContol pathRecordContol;
    private LocationControlPanel locationControlPanel;
    private AdvancedPanel advancedFrictionPanel;
    private EditSkaterPanel editSkaterPanel;
    DecimalFormat decimalFormat = new DecimalFormat("0.0");

    public EnergySkateParkControlPanel(final EnergySkateParkModule energySkateParkModule) {
        this.module = energySkateParkModule;
        JButton jButton = new JButton(EnergySkateParkStrings.getString("controls.reset"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnergySkateParkControlPanel.this.doReset();
            }
        });
        this.addControl(jButton);
        Object object = new JButton(EnergySkateParkStrings.getString("controls.reset-character"));
        ((AbstractButton)object).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                energySkateParkModule.returnOrResetSkater();
            }
        });
        this.addControl((Component)object);
        try {
            object = new JButton(EnergySkateParkStrings.getString("controls.choose-character") + "...");
            ((AbstractButton)object).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    new ChooseCharacterDialog(energySkateParkModule).setVisible(true);
                }
            });
            this.addControl(new IconComponent((JComponent)object, BufferedImageUtils.rescaleYMaintainAspectRatio(ImageLoader.loadBufferedImage("energy-skate-park/images/skater3.png"), ((JComponent)object).getPreferredSize().height)));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object = null;
        try {
            object = ImageLoader.loadBufferedImage("energy-skate-park/images/ruler-thumb.png");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        final JCheckBox jCheckBox = new JCheckBox(EnergySkateParkStrings.getString("controls.measuring-tape"), energySkateParkModule.isMeasuringTapeVisible());
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                energySkateParkModule.setMeasuringTapeVisible(jCheckBox.isSelected());
            }
        });
        this.getMeasuringTapeNode(energySkateParkModule).addPropertyChangeListener("visible", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jCheckBox.setSelected(EnergySkateParkControlPanel.this.getMeasuringTapeNode(energySkateParkModule).getVisible());
            }
        });
        this.addControlFullWidth(new IconComponent(jCheckBox, (BufferedImage)object));
        final JCheckBox jCheckBox2 = new JCheckBox(EnergySkateParkStrings.getString("label.potential-energy-reference"));
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                energySkateParkModule.getEnergySkateParkSimulationPanel().setZeroPointVisible(jCheckBox2.isSelected());
            }
        });
        energySkateParkModule.getEnergySkateParkSimulationPanel().addListener(new EnergySkateParkSimulationPanel.Adapter(){

            public void zeroPointEnergyVisibilityChanged() {
                jCheckBox2.setSelected(energySkateParkModule.getEnergySkateParkSimulationPanel().isZeroPointVisible());
            }
        });
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageLoader.loadBufferedImage("energy-skate-park/images/peicon.png");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.addControlFullWidth(new IconComponent(jCheckBox2, bufferedImage));
        this.addControlFullWidth(new GridLinesCheckBox(energySkateParkModule));
        this.pathRecordContol = new PathRecordContol(energySkateParkModule);
        this.addControlFullWidth(this.pathRecordContol);
        this.piePanel = new PieChartControlPanel(energySkateParkModule, this);
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        verticalLayoutPanel.setFillNone();
        verticalLayoutPanel.setAnchor(17);
        verticalLayoutPanel.setBorder(BorderFactory.createTitledBorder(EnergySkateParkStrings.getString("plots.plot")));
        verticalLayoutPanel.add(this.piePanel);
        JButton jButton2 = new JButton(EnergySkateParkStrings.getString("plots.energy-vs-time"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                energySkateParkModule.showNewEnergyVsTimePlot();
            }
        });
        JButton jButton3 = new JButton(EnergySkateParkStrings.getString("plots.energy-vs-position"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                energySkateParkModule.setEnergyPositionPlotVisible(true);
            }
        });
        JButton jButton4 = new JButton(EnergySkateParkStrings.getString("plots.bar-graph"));
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                energySkateParkModule.setBarChartVisible(true);
            }
        });
        verticalLayoutPanel.add(jButton4);
        verticalLayoutPanel.add(jButton3);
        verticalLayoutPanel.add(jButton2);
        this.addControlFullWidth(verticalLayoutPanel);
        this.locationControlPanel = new LocationControlPanel(energySkateParkModule, energySkateParkModule.getOptions().getPlanetButtonLayout(), energySkateParkModule.getOptions().getPlanetButtonsCentered());
        this.addControl(this.locationControlPanel);
        this.addControl(new ClearHeatButton(energySkateParkModule.getEnergySkateParkModel()));
        this.advancedFrictionPanel = new AdvancedPanel(EnergySkateParkStrings.getString("controls.show-friction"), EnergySkateParkStrings.getString("controls.hide-friction"));
        FrictionControl frictionControl = new FrictionControl(energySkateParkModule);
        this.advancedFrictionPanel.addControl(frictionControl);
        frictionControl.getModelSlider().setBorder(null);
        this.addControl(this.advancedFrictionPanel);
        this.editSkaterPanel = new EditSkaterPanel(energySkateParkModule);
        this.addControl(this.editSkaterPanel);
    }

    private PNode getMeasuringTapeNode(EnergySkateParkModule energySkateParkModule) {
        return energySkateParkModule.getEnergySkateParkSimulationPanel().getRootNode().getMeasuringTapeNode();
    }

    private void doReset() {
        this.module.confirmAndReset();
    }

    public void reset() {
        this.pathRecordContol.reset();
        this.locationControlPanel.reset();
        this.advancedFrictionPanel.setAdvancedControlsVisible(false);
        this.editSkaterPanel.reset();
    }
}

