/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view;

import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.event.PDebugKeyHandler;
import edu.colorado.phet.common.piccolophet.event.PanZoomWorldKeyHandler;
import edu.colorado.phet.energyskatepark.EnergySkateParkModule;
import edu.colorado.phet.energyskatepark.model.Body;
import edu.colorado.phet.energyskatepark.model.BumpUpSplines;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkSpline;
import edu.colorado.phet.energyskatepark.model.PreFabSplines;
import edu.colorado.phet.energyskatepark.model.TraversalState;
import edu.colorado.phet.energyskatepark.model.physics.ControlPointParametricFunction2D;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkSplineEnvironment;
import edu.colorado.phet.energyskatepark.view.MultiKeyHandler;
import edu.colorado.phet.energyskatepark.view.SplineMatch;
import edu.colorado.phet.energyskatepark.view.piccolo.EnergySkateParkRootNode;
import edu.colorado.phet.energyskatepark.view.piccolo.SkaterNode;
import edu.colorado.phet.energyskatepark.view.piccolo.SplineNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class EnergySkateParkSimulationPanel
extends PhetPCanvas
implements EnergySkateParkSplineEnvironment {
    private EnergySkateParkModule module;
    private EnergySkateParkModel energySkateParkModel;
    private MultiKeyHandler multiKeyHandler = new MultiKeyHandler();
    private EnergySkateParkRootNode rootNode;
    private double matchThresholdWorldCoordinates = 0.495;
    private ArrayList listeners = new ArrayList();

    public EnergySkateParkSimulationPanel(EnergySkateParkModule energySkateParkModule) {
        super(new Rectangle2D.Double(0.0, -1.0, 15.0, 10.0));
        this.module = energySkateParkModule;
        this.energySkateParkModel = energySkateParkModule.getEnergySkateParkModel();
        this.rootNode = new EnergySkateParkRootNode(energySkateParkModule, this);
        this.setPhetRootNode(this.rootNode);
        this.addFocusRequest();
        this.addKeyHandling();
        this.addKeyListener(new PanZoomWorldKeyHandler(this));
        this.energySkateParkModel.addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void preStep() {
                EnergySkateParkSimulationPanel.this.updateThrust();
            }
        });
        this.addKeyListener(new PDebugKeyHandler());
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                EnergySkateParkSimulationPanel.this.requestFocus();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                if (EnergySkateParkSimulationPanel.this.energySkateParkModel.getGravity() != 0.0) {
                    new BumpUpSplines(EnergySkateParkSimulationPanel.this.energySkateParkModel).bumpUpSplines();
                    EnergySkateParkSimulationPanel.this.getRootNode().updateSplineNodes();
                }
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                if (!EnergySkateParkSimulationPanel.this.hasFocus()) {
                    int n = keyEvent.getID();
                    switch (n) {
                        case 401: {
                            EnergySkateParkSimulationPanel.this.keyPressed(keyEvent);
                            break;
                        }
                        case 402: {
                            EnergySkateParkSimulationPanel.this.keyReleased(keyEvent);
                            break;
                        }
                        case 400: {
                            EnergySkateParkSimulationPanel.this.keyTyped(keyEvent);
                            break;
                        }
                        default: {
                            System.out.println("unknown key event type");
                        }
                    }
                }
                return false;
            }
        });
    }

    protected void updateScale() {
        super.updateScale();
        if (this.rootNode != null) {
            this.rootNode.updateScale();
        }
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        super.paintComponent(graphics);
    }

    private void addFocusRequest() {
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                EnergySkateParkSimulationPanel.this.requestFocus();
            }
        });
    }

    private void addKeyHandling() {
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                EnergySkateParkSimulationPanel.this.keyPressed(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                EnergySkateParkSimulationPanel.this.keyReleased(keyEvent);
            }

            public void keyTyped(KeyEvent keyEvent) {
                EnergySkateParkSimulationPanel.this.keyTyped(keyEvent);
            }
        });
    }

    private void debugScreenSize() {
        System.out.println("getSize( ) = " + this.getSize());
    }

    private void updateThrust() {
        if (this.energySkateParkModel.getNumBodies() > 0) {
            Body body = this.energySkateParkModel.getBody(0);
            double d = 0.0;
            double d2 = 0.0;
            int n = 15;
            if (this.multiKeyHandler.isPressed(39)) {
                d = n;
            } else if (this.multiKeyHandler.isPressed(37)) {
                d = -n;
            }
            if (this.multiKeyHandler.isPressed(38)) {
                d2 = n;
            } else if (this.multiKeyHandler.isPressed(40)) {
                d2 = -n;
            }
            body.setThrust(d, d2);
        }
    }

    private void removeSkater() {
        if (this.getEnergySkateParkModel().getNumBodies() > 1) {
            this.energySkateParkModel.removeBody(1);
        }
    }

    private void addSkater() {
        Body body = this.module.createBody();
        this.energySkateParkModel.addBody(body);
        this.module.reinitializeSkater(body);
    }

    private void printControlPoints() {
        this.energySkateParkModel.getSpline(0).printControlPointCode();
    }

    public SplineMatch proposeMatch(SplineNode splineNode, final Point2D point2D) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.numSplineGraphics(); ++i) {
            double d;
            Object object;
            SplineNode splineNode2 = this.getSplineNode(i);
            PNode pNode = splineNode2.getControlPointGraphic(0);
            double d2 = this.distance(point2D, pNode);
            if (d2 < this.matchThresholdWorldCoordinates && splineNode != splineNode2) {
                object = new SplineMatch(splineNode2, 0);
                arrayList.add(object);
            }
            if (!((d = this.distance(point2D, (PNode)(object = splineNode2.getControlPointGraphic(splineNode2.numControlPointGraphics() - 1)))) < this.matchThresholdWorldCoordinates) || splineNode == splineNode2) continue;
            SplineMatch splineMatch = new SplineMatch(splineNode2, splineNode2.numControlPointGraphics() - 1);
            arrayList.add(splineMatch);
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                SplineMatch splineMatch = (SplineMatch)object;
                SplineMatch splineMatch2 = (SplineMatch)object2;
                return Double.compare(EnergySkateParkSimulationPanel.this.distance(point2D, splineMatch.getTarget()), EnergySkateParkSimulationPanel.this.distance(point2D, splineMatch2.getTarget()));
            }
        });
        if (arrayList.size() == 0) {
            return null;
        }
        return (SplineMatch)arrayList.get(0);
    }

    private double distance(Point2D point2D, PNode pNode) {
        return pNode.getFullBounds().getCenter2D().distance(point2D);
    }

    private SplineNode getSplineNode(int n) {
        return this.rootNode.splineGraphicAt(n);
    }

    private int numSplineGraphics() {
        return this.rootNode.numSplineGraphics();
    }

    public void attach(SplineNode splineNode, int n, SplineMatch splineMatch) {
        int n2;
        TraversalState traversalState = this.getEnergySkateParkModel().getBody(0).getTraversalState();
        boolean bl = false;
        boolean bl2 = this.getRollerCoaster(splineNode.getSpline(), splineMatch.getEnergySkateParkSpline());
        if (this.getEnergySkateParkModel().getBody(0).getSpline() == splineNode.getParametricFunction2D() || this.getEnergySkateParkModel().getBody(0).getSpline() == splineMatch.getSplineGraphic().getParametricFunction2D()) {
            bl = true;
        }
        this.removeSpline(splineNode);
        this.removeSpline(splineMatch.getSplineGraphic());
        PreFabSplines.CubicSpline cubicSpline = new PreFabSplines.CubicSpline();
        ControlPointParametricFunction2D controlPointParametricFunction2D = splineNode.getSpline().getParametricFunction2D();
        EnergySkateParkSpline energySkateParkSpline = splineMatch.getEnergySkateParkSpline();
        if (n == 0) {
            for (n2 = controlPointParametricFunction2D.numControlPoints() - 1; n2 >= 0; --n2) {
                cubicSpline.addControlPoint(controlPointParametricFunction2D.controlPointAt(n2));
            }
        } else {
            for (n2 = 0; n2 < controlPointParametricFunction2D.numControlPoints(); ++n2) {
                cubicSpline.addControlPoint(controlPointParametricFunction2D.controlPointAt(n2));
            }
        }
        if (splineMatch.matchesBeginning()) {
            for (n2 = 1; n2 < energySkateParkSpline.numControlPoints(); ++n2) {
                cubicSpline.addControlPoint(energySkateParkSpline.getControlPoint(n2));
            }
        } else if (splineMatch.matchesEnd()) {
            for (n2 = energySkateParkSpline.numControlPoints() - 2; n2 >= 0; --n2) {
                cubicSpline.addControlPoint(energySkateParkSpline.getControlPoint(n2));
            }
        }
        EnergySkateParkSpline energySkateParkSpline2 = new EnergySkateParkSpline(cubicSpline.getControlPoints());
        energySkateParkSpline2.setRollerCoasterMode(bl2);
        this.energySkateParkModel.addSplineSurface(energySkateParkSpline2);
        System.out.println("change = " + bl);
        if (bl) {
            TraversalState traversalState2 = this.energySkateParkModel.getBody(0).getBestTraversalState(traversalState);
            this.energySkateParkModel.getBody(0).setSpline(this.energySkateParkModel.getEnergySkateParkSpline(traversalState2.getParametricFunction2D()), traversalState2.isTop(), traversalState2.getAlpha());
        }
    }

    private boolean getRollerCoaster(EnergySkateParkSpline energySkateParkSpline, EnergySkateParkSpline energySkateParkSpline2) {
        return energySkateParkSpline.numControlPoints() > energySkateParkSpline2.numControlPoints() ? energySkateParkSpline.isRollerCoasterMode() : energySkateParkSpline2.isRollerCoasterMode();
    }

    public EnergySkateParkModel getEnergySkateParkModel() {
        return this.energySkateParkModel;
    }

    public void removeSpline(SplineNode splineNode) {
        this.energySkateParkModel.removeSplineSurface(splineNode.getSpline());
    }

    public EnergySkateParkModule getEnergySkateParkModule() {
        return this.module;
    }

    public void reset() {
        this.rootNode.reset();
        this.setZeroPointVisible(false);
        this.setIgnoreThermal(false);
    }

    private void keyPressed(KeyEvent keyEvent) {
        this.multiKeyHandler.keyPressed(keyEvent);
        if (this.hasFocus()) {
            if (keyEvent.getKeyCode() == 80) {
                System.out.println("spline.getSegmentPath().getLength() = " + this.energySkateParkModel.getSpline(0).numControlPoints());
                this.printControlPoints();
            } else if (keyEvent.getKeyCode() == 65) {
                this.addSkater();
            } else if (keyEvent.getKeyCode() == 82) {
                this.removeSkater();
            } else if (keyEvent.getKeyCode() == 68) {
                this.removeSkater();
                this.debugScreenSize();
            }
        }
    }

    private void keyReleased(KeyEvent keyEvent) {
        this.multiKeyHandler.keyReleased(keyEvent);
    }

    private void keyTyped(KeyEvent keyEvent) {
        this.multiKeyHandler.keyTyped(keyEvent);
    }

    public boolean isMeasuringTapeVisible() {
        return this.rootNode.isMeasuringTapeVisible();
    }

    public void setMeasuringTapeVisible(boolean bl) {
        this.rootNode.setMeasuringTapeVisible(bl);
    }

    public boolean isPieChartVisible() {
        return this.rootNode.isPieChartVisible();
    }

    public void setPieChartVisible(boolean bl) {
        this.rootNode.setPieChartVisible(bl);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).pieChartVisibilityChanged();
        }
    }

    public EnergySkateParkRootNode getRootNode() {
        return this.rootNode;
    }

    public void setZeroPointVisible(boolean bl) {
        this.rootNode.setZeroPointVisible(bl);
        this.notifyZeroPointVisibleChanged();
    }

    private void notifyZeroPointVisibleChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.zeroPointEnergyVisibilityChanged();
        }
    }

    public boolean isZeroPointVisible() {
        return this.rootNode.isZeroPointVisible();
    }

    public void dragSplineSurface(PInputEvent pInputEvent, EnergySkateParkSpline energySkateParkSpline) {
        SplineNode splineNode = this.getSplineNode(energySkateParkSpline);
        if (splineNode == null) {
            throw new RuntimeException("Spline node not found for spline=" + energySkateParkSpline);
        }
        PDimension pDimension = pInputEvent.getCanvasDelta();
        this.rootNode.screenToWorld(pDimension);
        splineNode.processExternalDragEvent(pInputEvent, pDimension.width, pDimension.height);
    }

    public SplineNode getSplineNode(EnergySkateParkSpline energySkateParkSpline) {
        for (int i = 0; i < this.numSplineGraphics(); ++i) {
            if (this.getSplineNode(i).getSpline() != energySkateParkSpline) continue;
            return this.getSplineNode(i);
        }
        return null;
    }

    public void setEnergyErrorVisible(boolean bl) {
        this.rootNode.setEnergyErrorVisible(bl);
    }

    public boolean isEnergyErrorVisible() {
        return this.rootNode.isEnergyErrorVisible();
    }

    public boolean isSkaterOnscreen(Body body) {
        return this.isSkaterOnscreen(this.getRootNode().getSkaterNode(body));
    }

    public boolean isSkaterOnscreen(SkaterNode skaterNode) {
        Rectangle rectangle = new Rectangle(this.module.getEnergySkateParkSimulationPanel().getSize());
        Rectangle2D rectangle2D = skaterNode.getRedDotGlobalFullBounds();
        return rectangle.contains(rectangle2D);
    }

    public boolean getIgnoreThermal() {
        return this.rootNode.getIgnoreThermal();
    }

    public void setIgnoreThermal(boolean bl) {
        if (this.rootNode.getIgnoreThermal() != bl) {
            this.rootNode.setIgnoreThermal(bl);
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((Listener)this.listeners.get(i)).ignoreThermalChanged();
            }
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void fireZoomEvent() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.zoomChanged();
        }
    }

    public static class Adapter
    implements Listener {
        public void zoomChanged() {
        }

        public void zeroPointEnergyVisibilityChanged() {
        }

        public void pieChartVisibilityChanged() {
        }

        public void ignoreThermalChanged() {
        }
    }

    public static interface Listener {
        public void zoomChanged();

        public void zeroPointEnergyVisibilityChanged();

        public void pieChartVisibilityChanged();

        public void ignoreThermalChanged();
    }
}

