/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.piccolo;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.piccolophet.PhetRootPNode;
import edu.colorado.phet.common.piccolophet.nodes.MeasuringTape;
import edu.colorado.phet.energyskatepark.EnergySkateParkModule;
import edu.colorado.phet.energyskatepark.model.Body;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import edu.colorado.phet.energyskatepark.model.Floor;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkSimulationPanel;
import edu.colorado.phet.energyskatepark.view.piccolo.BackgroundScreenNode;
import edu.colorado.phet.energyskatepark.view.piccolo.EnergyErrorIndicatorNode;
import edu.colorado.phet.energyskatepark.view.piccolo.EnergySkateParkLegend;
import edu.colorado.phet.energyskatepark.view.piccolo.EnergySkateParkPieChartNode;
import edu.colorado.phet.energyskatepark.view.piccolo.FloorNode;
import edu.colorado.phet.energyskatepark.view.piccolo.GridNode;
import edu.colorado.phet.energyskatepark.view.piccolo.HistoryPointNode;
import edu.colorado.phet.energyskatepark.view.piccolo.PanZoomOnscreenControlNode;
import edu.colorado.phet.energyskatepark.view.piccolo.PauseIndicatorNode;
import edu.colorado.phet.energyskatepark.view.piccolo.ReturnSkaterButtonNode;
import edu.colorado.phet.energyskatepark.view.piccolo.SkaterNode;
import edu.colorado.phet.energyskatepark.view.piccolo.SplineNode;
import edu.colorado.phet.energyskatepark.view.piccolo.SplineToolboxNode;
import edu.colorado.phet.energyskatepark.view.piccolo.SurfaceObjectNode;
import edu.colorado.phet.energyskatepark.view.piccolo.ZeroPointPotentialNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;

public class EnergySkateParkRootNode
extends PhetRootPNode {
    private EnergySkateParkModule module;
    private EnergySkateParkSimulationPanel simulationPanel;
    private PNode skaterNodeLayer = new PNode();
    private PNode splineLayer = new PNode();
    private PNode historyLayer = new PNode();
    private PNode historyReadoutLayer = new PNode();
    private PNode pieChartLayer = new PNode();
    private MeasuringTape measuringTape;
    private ReturnSkaterButtonNode returnSkaterButtonNode;
    private boolean ignoreThermal = false;
    private PauseIndicatorNode pauseIndicator;
    private EnergySkateParkLegend legend;
    private BackgroundScreenNode backgroundScreenNode;
    private SplineToolboxNode splineToolbox;
    private FloorNode floorNode;
    private ZeroPointPotentialNode zeroPointPotentialNode;
    private GridNode gridNode;
    private PanZoomOnscreenControlNode panZoomControls;
    private PNode energyErrorIndicatorContainer = new PNode();
    private EnergyErrorIndicatorNode energyErrorIndicatorNode;
    private SurfaceObjectNode houseNode;
    private SurfaceObjectNode mountainNode;
    public static final Color SKY_COLOR = new Color(170, 200, 220);

    public EnergySkateParkRootNode(final EnergySkateParkModule energySkateParkModule, EnergySkateParkSimulationPanel energySkateParkSimulationPanel) {
        this.module = energySkateParkModule;
        this.simulationPanel = energySkateParkSimulationPanel;
        EnergySkateParkModel energySkateParkModel = this.getModel();
        Floor floor = energySkateParkModel.getFloor();
        energySkateParkSimulationPanel.setBackground(SKY_COLOR);
        this.splineToolbox = new SplineToolboxNode(energySkateParkSimulationPanel);
        this.measuringTape = new MeasuringTape(new ModelViewTransform2D(new Rectangle(50, 50), new Rectangle2D.Double(0.0, 0.0, 50.0, 50.0)), new Point2D.Double(25.0, 25.0));
        this.updateMapping();
        this.resetMeasuringTapeLocation();
        this.pauseIndicator = new PauseIndicatorNode(energySkateParkModule);
        this.legend = new EnergySkateParkLegend(energySkateParkModule);
        this.floorNode = new FloorNode(energySkateParkModule, this.getModel(), floor);
        this.backgroundScreenNode = new BackgroundScreenNode(energySkateParkSimulationPanel, null, this.floorNode);
        this.zeroPointPotentialNode = new ZeroPointPotentialNode(energySkateParkSimulationPanel, energySkateParkModel);
        this.gridNode = new GridNode(-50.0, -150.0, 100.0, 150.0, 1.0, 1.0);
        energySkateParkModule.getEnergySkateParkModel().addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void gravityChanged() {
                HashMap<Double, Color> hashMap = new HashMap<Double, Color>();
                hashMap.put(new Double(0.0), Color.lightGray);
                hashMap.put(new Double(-25.95), Color.white);
                hashMap.put(new Double(-1.62), Color.lightGray);
                Double d = new Double(energySkateParkModule.getEnergySkateParkModel().getGravity());
                Paint paint = (Paint)(hashMap.containsKey(d) ? hashMap.get(d) : Color.black);
                EnergySkateParkRootNode.this.gridNode.setGridPaint(paint);
            }
        });
        this.houseNode = new SurfaceObjectNode("energy-skate-park/images/house.png", 1.5, 10.0);
        this.mountainNode = new SurfaceObjectNode("energy-skate-park/images/mountains.gif", 1.5, 0.0);
        this.returnSkaterButtonNode = new ReturnSkaterButtonNode(energySkateParkSimulationPanel, energySkateParkModule, null);
        energySkateParkModule.getEnergySkateParkModel().addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void gravityChanged() {
                EnergySkateParkRootNode.this.updateHouseAndMountainVisible();
            }
        });
        this.addScreenChild(this.backgroundScreenNode);
        this.addScreenChild(this.splineToolbox);
        this.addWorldChild(this.houseNode);
        this.addWorldChild(this.mountainNode);
        this.addWorldChild(this.floorNode);
        this.addWorldChild(this.splineLayer);
        this.addWorldChild(this.skaterNodeLayer);
        this.addScreenChild(this.historyLayer);
        this.addScreenChild(this.historyReadoutLayer);
        this.addScreenChild(this.measuringTape);
        this.addScreenChild(this.pieChartLayer);
        this.addScreenChild(this.pauseIndicator);
        this.addScreenChild(this.legend);
        this.addScreenChild(this.zeroPointPotentialNode);
        this.addScreenChild(this.returnSkaterButtonNode);
        this.addWorldChild(this.gridNode);
        this.setGridVisible(false);
        this.resetDefaults();
        energySkateParkSimulationPanel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                EnergySkateParkRootNode.this.backgroundScreenNode.update();
            }
        });
        this.setZeroPointVisible(false);
        this.panZoomControls = new PanZoomOnscreenControlNode(energySkateParkSimulationPanel);
        this.addScreenChild(this.panZoomControls);
        this.energyErrorIndicatorNode = new EnergyErrorIndicatorNode(energySkateParkModule.getEnergySkateParkModel());
        this.energyErrorIndicatorContainer.setVisible(false);
        this.energyErrorIndicatorContainer.addChild(this.energyErrorIndicatorNode);
        this.addScreenChild(this.energyErrorIndicatorContainer);
        energySkateParkSimulationPanel.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                EnergySkateParkRootNode.this.updateEnergyIndicator();
            }

            public void componentResized(ComponentEvent componentEvent) {
                EnergySkateParkRootNode.this.updateEnergyIndicator();
            }
        });
        this.updateMapping();
        this.addWorldTransformListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                EnergySkateParkRootNode.this.updateMapping();
            }
        });
        energySkateParkSimulationPanel.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 86 && keyEvent.isControlDown() && keyEvent.isShiftDown()) {
                    EnergySkateParkRootNode.this.showAll(EnergySkateParkRootNode.this);
                }
            }
        });
        energySkateParkModule.getEnergySkateParkModel().addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void bodyCountChanged() {
                EnergySkateParkRootNode.this.updateBodies();
            }

            public void splineCountChanged() {
                EnergySkateParkRootNode.this.updateSplines();
            }

            public void historyChanged() {
                EnergySkateParkRootNode.this.updateHistory();
            }

            public void splinesSynced() {
                EnergySkateParkRootNode.this.updateSplines();
            }

            public void bodiesSynced() {
                EnergySkateParkRootNode.this.updateBodies();
            }
        });
    }

    public SplineToolboxNode getSplineToolbox() {
        return this.splineToolbox;
    }

    private void resetMeasuringTapeLocation() {
        this.measuringTape.setModelSrc(new Point2D.Double(5.0, 5.0));
        this.measuringTape.setModelDst(new Point2D.Double(7.0, 5.0));
    }

    private void updateHouseAndMountainVisible() {
        this.houseNode.setVisible(this.module.getEnergySkateParkModel().getGravity() == -9.81 && this.getBackgroundScreenNode().getVisible());
        this.mountainNode.setVisible(this.module.getEnergySkateParkModel().getGravity() == -9.81 && this.getBackgroundScreenNode().getVisible());
    }

    private void showAll(PNode pNode) {
        pNode.setVisible(true);
        for (int i = 0; i < pNode.getChildrenCount(); ++i) {
            this.showAll(pNode.getChild(i));
        }
    }

    private void updateMapping() {
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
        this.worldToScreen(double_);
        this.measuringTape.setModelViewTransform2D(new ModelViewTransform2D(new Rectangle(1, 1), double_));
    }

    private void updateEnergyIndicator() {
        double d = 20.0;
        double d2 = 20.0;
        this.energyErrorIndicatorNode.setOffset(d, (double)this.simulationPanel.getHeight() - d2 - this.energyErrorIndicatorNode.getFullBounds().getHeight());
    }

    private BackgroundScreenNode getBackgroundScreenNode() {
        return this.backgroundScreenNode;
    }

    public void setBackground(BufferedImage bufferedImage) {
        this.backgroundScreenNode.setBackground(bufferedImage);
    }

    private void resetDefaults() {
        this.setPieChartVisible(false);
        this.setMeasuringTapeVisible(false);
    }

    private EnergySkateParkModel getModel() {
        return this.module.getEnergySkateParkModel();
    }

    public void addSplineNode(SplineNode splineNode) {
        this.splineLayer.addChild(splineNode);
    }

    public void reset() {
        this.pieChartLayer.removeAllChildren();
        this.setMeasuringTapeVisible(false);
        this.resetMeasuringTapeLocation();
        this.panZoomControls.reset();
        this.setGridVisible(false);
    }

    public void addSkaterNode(SkaterNode skaterNode) {
        skaterNode.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                EnergySkateParkRootNode.this.module.setRecordOrLiveMode();
            }
        });
        this.skaterNodeLayer.addChild(skaterNode);
    }

    public SplineNode splineGraphicAt(int n) {
        return (SplineNode)this.splineLayer.getChildrenReference().get(n);
    }

    public int numSplineGraphics() {
        return this.splineLayer.getChildrenReference().size();
    }

    public void removeSplineNode(SplineNode splineNode) {
        this.splineLayer.removeChild(splineNode);
        splineNode.detachListeners();
    }

    private void updateHistory() {
        while (this.numHistoryGraphics() < this.getModel().getNumHistoryPoints()) {
            this.addHistoryGraphic(new HistoryPointNode(this.getModel().historyPointAt(0), this));
        }
        while (this.numHistoryGraphics() > this.getModel().getNumHistoryPoints()) {
            this.removeHistoryPointGraphic(this.historyGraphicAt(this.numHistoryGraphics() - 1));
        }
        for (int i = 0; i < this.getModel().getNumHistoryPoints(); ++i) {
            this.historyGraphicAt(i).setHistoryPoint(this.getModel().historyPointAt(i));
        }
    }

    private HistoryPointNode historyGraphicAt(int n) {
        return (HistoryPointNode)this.historyLayer.getChild(n);
    }

    private void removeHistoryPointGraphic(HistoryPointNode historyPointNode) {
        this.historyLayer.removeChild(historyPointNode);
        this.historyReadoutLayer.removeChild(historyPointNode.getReadoutGraphic());
    }

    private void addHistoryGraphic(HistoryPointNode historyPointNode) {
        this.historyLayer.addChild(historyPointNode);
        this.historyReadoutLayer.addChild(historyPointNode.getReadoutGraphic());
    }

    private int numHistoryGraphics() {
        return this.historyLayer.getChildrenCount();
    }

    private void updateBodies() {
        while (this.numBodyGraphics() < this.getModel().getNumBodies()) {
            this.addSkaterNode(new SkaterNode(this.getModel().getBody(0)));
        }
        while (this.numBodyGraphics() > this.getModel().getNumBodies()) {
            this.removeSkaterNode(this.getSkaterNode(this.numBodyGraphics() - 1));
        }
        for (int i = 0; i < this.getModel().getNumBodies(); ++i) {
            this.getSkaterNode(i).setBody(this.getModel().getBody(i));
        }
        if (this.skaterNodeLayer.getChildrenCount() == 1) {
            this.initPieChart();
            this.returnSkaterButtonNode.setSkaterNode(this.getSkaterNode(0));
        }
    }

    private void initPieChart() {
        this.pieChartLayer.removeAllChildren();
        EnergySkateParkPieChartNode energySkateParkPieChartNode = new EnergySkateParkPieChartNode(this.module, this.getSkaterNode(0));
        energySkateParkPieChartNode.setIgnoreThermal(this.ignoreThermal);
        this.pieChartLayer.addChild(energySkateParkPieChartNode);
    }

    private void updateSplines() {
        while (this.numSplineGraphics() < this.getModel().getNumSplines()) {
            this.addSplineNode(new SplineNode(this.simulationPanel, this.getModel().getSpline(0), this.simulationPanel));
        }
        while (this.numSplineGraphics() > this.getModel().getNumSplines()) {
            this.removeSplineNode(this.splineGraphicAt(this.numSplineGraphics() - 1));
        }
        for (int i = 0; i < this.getModel().getNumSplines(); ++i) {
            this.splineGraphicAt(i).setSpline(this.getModel().getSpline(i));
        }
    }

    private void removeSkaterNode(SkaterNode skaterNode) {
        this.skaterNodeLayer.removeChild(skaterNode);
        skaterNode.delete();
    }

    public int numBodyGraphics() {
        return this.skaterNodeLayer.getChildrenCount();
    }

    public SkaterNode getSkaterNode(int n) {
        return (SkaterNode)this.skaterNodeLayer.getChild(n);
    }

    public boolean isMeasuringTapeVisible() {
        return this.measuringTape.getVisible();
    }

    public void setMeasuringTapeVisible(boolean bl) {
        this.measuringTape.setVisible(bl);
    }

    public boolean isPieChartVisible() {
        return this.pieChartLayer.getVisible();
    }

    public void setPieChartVisible(boolean bl) {
        this.pieChartLayer.setVisible(bl);
        this.legend.setVisible(bl);
    }

    public boolean getIgnoreThermal() {
        return this.ignoreThermal;
    }

    public void setIgnoreThermal(boolean bl) {
        if (this.ignoreThermal != bl) {
            this.ignoreThermal = bl;
            for (int i = 0; i < this.pieChartLayer.getChildrenCount(); ++i) {
                EnergySkateParkPieChartNode energySkateParkPieChartNode = (EnergySkateParkPieChartNode)this.pieChartLayer.getChild(i);
                energySkateParkPieChartNode.setIgnoreThermal(this.ignoreThermal);
            }
        }
    }

    public void clearBackground() {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(new Color(0, 0, 0, 255));
        graphics2D.fillRect(0, 0, 1, 1);
        this.setBackground(null);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.pauseIndicator.relayout();
        double d = 10.0;
        double d2 = 10.0;
        this.legend.setOffset((double)this.getSimulationPanel().getWidth() - this.legend.getFullBounds().getWidth() - d, d2);
        if (this.panZoomControls != null) {
            this.panZoomControls.setOffset((double)this.getSimulationPanel().getWidth() - this.panZoomControls.getFullBounds().getWidth() - d, (double)this.getSimulationPanel().getHeight() - this.panZoomControls.getFullBounds().getHeight() - d2);
        }
    }

    private EnergySkateParkSimulationPanel getSimulationPanel() {
        return this.simulationPanel;
    }

    public void setZeroPointVisible(boolean bl) {
        this.zeroPointPotentialNode.setVisible(bl);
    }

    public boolean isZeroPointVisible() {
        return this.zeroPointPotentialNode.getVisible();
    }

    public boolean isGridVisible() {
        return this.gridNode.getVisible();
    }

    public void setGridVisible(boolean bl) {
        this.gridNode.setVisible(bl);
    }

    public void addGridVisibilityChangeListener(PropertyChangeListener propertyChangeListener) {
        this.gridNode.addPropertyChangeListener("visible", propertyChangeListener);
    }

    public PNode getMeasuringTapeNode() {
        return this.measuringTape;
    }

    public void updateScale() {
        this.panZoomControls.updateScale();
    }

    public void setEnergyErrorVisible(boolean bl) {
        this.energyErrorIndicatorContainer.setVisible(bl);
    }

    public boolean isEnergyErrorVisible() {
        return this.energyErrorIndicatorContainer.getVisible();
    }

    public void setBackgroundVisible(boolean bl) {
        this.getBackgroundScreenNode().setVisible(bl);
        this.updateHouseAndMountainVisible();
    }

    public void updateSplineNodes() {
        this.updateSplines();
    }

    public SkaterNode getSkaterNode(Body body) {
        for (int i = 0; i < this.skaterNodeLayer.getChildrenCount(); ++i) {
            SkaterNode skaterNode = (SkaterNode)this.skaterNodeLayer.getChild(i);
            if (skaterNode.getBody() != body) continue;
            return skaterNode;
        }
        return null;
    }
}

