/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.piccolo;

import edu.colorado.phet.energyskatepark.EnergySkateParkModule;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import edu.colorado.phet.energyskatepark.model.Floor;
import edu.colorado.phet.energyskatepark.model.Planet;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class FloorNode
extends PNode {
    private EnergySkateParkModule module;
    private EnergySkateParkModel energySkateParkModel;
    private Floor floor;
    private PPath groundPPath;
    private PPath groundLinePPath;

    public FloorNode(EnergySkateParkModule energySkateParkModule, EnergySkateParkModel energySkateParkModel, Floor floor) {
        this.module = energySkateParkModule;
        this.energySkateParkModel = energySkateParkModel;
        energySkateParkModel.addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void gravityChanged() {
                FloorNode.this.update();
            }

            public void floorChanged() {
                FloorNode.this.update();
            }
        });
        this.floor = floor;
        double d = floor.getY();
        float f = 0.0f;
        double d2 = -1000.0;
        double d3 = 1000.0;
        double d4 = 1000.0;
        this.groundPPath = new PPath(new Rectangle2D.Double(d2, d - d4, d3 - d2, d4 + (double)f));
        this.groundPPath.setPaint(new Color(100, 170, 100));
        this.groundPPath.setStroke(null);
        this.addChild(this.groundPPath);
        Line2D.Double double_ = new Line2D.Double(d2, d + (double)f, d3, d + (double)f);
        this.groundLinePPath = new PPath(double_);
        this.groundLinePPath.setStroke(new BasicStroke(0.03f));
        this.groundLinePPath.setStrokePaint(new Color(0, 130, 0));
        this.addChild(this.groundLinePPath);
        this.update();
    }

    private void update() {
        Planet[] planetArray = this.module.getPlanets();
        boolean bl = false;
        for (int i = 0; i < planetArray.length; ++i) {
            Planet planet = planetArray[i];
            if (planet.getGravity() != this.energySkateParkModel.getGravity()) continue;
            this.setPlanetVisible(planet);
            bl = true;
            break;
        }
        if (!bl) {
            this.setPlanetVisible(new Planet.Earth());
        }
        this.setVisible(this.energySkateParkModel.getFloor() != null);
    }

    private void setPlanetVisible(Planet planet) {
        this.groundPPath.setPaint(planet.getGroundPaint());
        this.groundLinePPath.setStrokePaint(planet.getGroundLinePaint());
        this.setVisible(planet.isGroundVisible());
    }
}

