/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.piccolo;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.energyskatepark.EnergySkateParkStrings;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.geom.Line2D;

public class GridNode
extends PhetPNode {
    private PNode lines = new PNode();
    private PNode textLayer = new PNode();
    private Paint gridPaint = null;

    public GridNode(double d, double d2, double d3, double d4, double d5, double d6) {
        PText pText;
        String string;
        double d7;
        this.addChild(this.lines);
        this.addChild(this.textLayer);
        for (d7 = d; d7 <= d3; d7 += d5) {
            this.lines.addChild(this.createXLineNode(d2, d4, d7));
            if (d7 % 2.0 != 0.0) continue;
            string = "" + (int)d7;
            if (string.equals("0")) {
                string = "0 " + EnergySkateParkStrings.getString("units.meters");
            }
            pText = new PText(string);
            pText.setOffset(d7 + d5 + d5 * 0.2, d2);
            pText.setScale(0.03f);
            pText.getTransformReference(true).scale(1.0, -1.0);
            this.textLayer.addChild(pText);
        }
        for (d7 = d2; d7 <= d4; d7 += d6) {
            this.lines.addChild(this.createYLineNode(d, d3, d7));
            if (d7 % 2.0 != 0.0) continue;
            string = "" + (int)d7;
            if (string.equals("0")) {
                string = "0 " + EnergySkateParkStrings.getString("units.meters");
            }
            pText = new PText(string);
            pText.setOffset(d5 + d5 * 0.05, d7 + d6 * 0.05);
            pText.setScale(0.03f);
            pText.getTransformReference(true).scale(1.0, -1.0);
            this.textLayer.addChild(pText);
        }
        this.setPickable(false);
        this.setChildrenPickable(false);
    }

    public void setGridPaint(Paint paint) {
        if (this.gridPaint == null || !this.gridPaint.equals(paint)) {
            this.gridPaint = paint;
            this.setLinePaint(paint);
            this.setFontPaint(paint);
        }
    }

    private void setFontPaint(Paint paint) {
        for (int i = 0; i < this.textLayer.getChildrenCount(); ++i) {
            PText pText = (PText)this.textLayer.getChild(i);
            pText.setTextPaint(paint);
        }
    }

    public void setLinePaint(Paint paint) {
        for (int i = 0; i < this.lines.getChildrenCount(); ++i) {
            PPath pPath = (PPath)this.lines.getChild(i);
            pPath.setStrokePaint(paint);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.setPickable(false);
        this.setChildrenPickable(false);
    }

    private PNode createYLineNode(double d, double d2, double d3) {
        PPath pPath = new PPath(new Line2D.Double(d, d3, d2, d3));
        boolean bl = MathUtil.isApproxEqual(d3, 0.0, 0.001);
        if ((int)d3 % 5 == 0) {
            bl = true;
        }
        pPath.setStroke(new BasicStroke(0.01f * (float)(bl ? 3 : 1)));
        return pPath;
    }

    private PNode createXLineNode(double d, double d2, double d3) {
        PPath pPath = new PPath(new Line2D.Double(d3, d, d3, d2));
        boolean bl = MathUtil.isApproxEqual(d3, 1.0, 0.001);
        pPath.setStroke(new BasicStroke(0.01f * (float)(bl ? 3 : 1)));
        return pPath;
    }
}

