/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.piccolo;

import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.ShadowHTMLNode;
import edu.colorado.phet.energyskatepark.model.HistoryPoint;
import edu.colorado.phet.energyskatepark.view.piccolo.EnergySkateParkRootNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;

public class HistoryPointNode
extends PNode {
    private HistoryPoint historyPoint;
    private EnergySkateParkRootNode rootNode;
    private DecimalFormat formatter = new DecimalFormat("0.00");
    private ShadowHTMLNode htmlNode;
    private Paint paint = new Color(220, 175, 250);

    public HistoryPointNode(HistoryPoint historyPoint, EnergySkateParkRootNode energySkateParkRootNode) {
        this.historyPoint = historyPoint;
        this.rootNode = energySkateParkRootNode;
        PPath pPath = new PPath(new Ellipse2D.Double(-7.5, -7.5, 15.0, 15.0));
        this.addChild(pPath);
        pPath.setStroke(new BasicStroke(1.5f));
        pPath.setPaint(this.paint);
        this.htmlNode = new ShadowHTMLNode("");
        this.htmlNode.addInputEventListener(new CursorHandler());
        this.htmlNode.setShadowOffset(1.0, 1.0);
        this.htmlNode.setShadowColor(Color.white);
        this.htmlNode.setColor(Color.black);
        this.htmlNode.scale(1.5);
        this.addInputEventListener(new CursorHandler());
        PBasicInputEventHandler pBasicInputEventHandler = new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                HistoryPointNode.this.historyPoint.setReadoutVisible(!HistoryPointNode.this.historyPoint.isReadoutVisible());
                HistoryPointNode.this.update();
            }
        };
        energySkateParkRootNode.addWorldTransformListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HistoryPointNode.this.update();
            }
        });
        this.addInputEventListener(pBasicInputEventHandler);
        this.htmlNode.addInputEventListener(pBasicInputEventHandler);
        this.update();
    }

    private String format(double d) {
        return this.formatter.format(d);
    }

    private void update() {
        Point2D.Double double_ = new Point2D.Double(this.historyPoint.getX(), this.historyPoint.getY());
        this.rootNode.worldToScreen(double_);
        this.setOffset(double_);
        String string = this.historyPoint.getThermalEnergy() != 0.0 ? "Thermal Energy=" + this.format(this.historyPoint.getThermalEnergy()) + " J<br>" : "";
        String string2 = "<br>Height=" + this.format(this.historyPoint.getHeightAboveZero()) + " m<br>" + "Speed=" + this.format(this.historyPoint.getSpeed()) + " m/s";
        String string3 = "<html>Kinetic Energy=" + this.format(this.historyPoint.getKE()) + " J<br>" + "Potential Energy=" + this.format(this.historyPoint.getPe()) + " J<br>" + string + "Total Energy=" + this.format(this.historyPoint.getTotalEnergy()) + " J<br>" + string2 + "<br>" + "</html>";
        if (this.historyPoint.isReadoutVisible()) {
            this.htmlNode.setHtml(string3);
        }
        this.getReadoutGraphic().setVisible(this.historyPoint.isReadoutVisible());
        this.getReadoutGraphic().setPickable(this.historyPoint.isReadoutVisible());
        this.getReadoutGraphic().setChildrenPickable(this.historyPoint.isReadoutVisible());
        this.getReadoutGraphic().setOffset(this.getOffset());
    }

    public void setHistoryPoint(HistoryPoint historyPoint) {
        this.historyPoint = historyPoint;
        this.update();
    }

    public PNode getReadoutGraphic() {
        return this.htmlNode;
    }
}

