/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.piccolo;

import edu.colorado.phet.common.piccolophet.nodes.ShadowPText;
import edu.colorado.phet.common.piccolophet.util.PImageFactory;
import edu.colorado.phet.common.timeseries.model.TimeSeriesModel;
import edu.colorado.phet.energyskatepark.EnergySkateParkModule;
import edu.colorado.phet.energyskatepark.EnergySkateParkStrings;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkUtils;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;

public class PauseIndicatorNode
extends PNode {
    private EnergySkateParkModule module;
    private int insetX = 5;
    private int insetY = 5;

    public PauseIndicatorNode(final EnergySkateParkModule energySkateParkModule) {
        this.module = energySkateParkModule;
        PImage pImage = PImageFactory.create("energy-skate-park/images/icons/java/media/Pause24.gif");
        this.addChild(pImage);
        ShadowPText shadowPText = new ShadowPText(EnergySkateParkStrings.getString("message.paused"));
        this.addChild(shadowPText);
        shadowPText.setOffset(pImage.getFullBounds().getMaxX() + 5.0, 0.0);
        shadowPText.setFont(new Font("Lucida Sans", 1, 16));
        shadowPText.setTextPaint(Color.red);
        shadowPText.setShadowColor(Color.black);
        energySkateParkModule.getTimeSeriesModel().addListener(new TimeSeriesModel.Adapter(){

            public void pauseChanged() {
                PauseIndicatorNode.this.updateVisibility();
            }
        });
        JButton jButton = new JButton(EnergySkateParkStrings.getString("time.resume"));
        EnergySkateParkUtils.fixButtonOpacity(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                energySkateParkModule.setRecordOrLiveMode();
                energySkateParkModule.getClock().start();
            }
        });
        PSwing pSwing = new PSwing(jButton);
        pSwing.setOffset(shadowPText.getFullBounds().getMaxX() + 5.0, shadowPText.getFullBounds().getY());
        this.addChild(pSwing);
        this.updateVisibility();
    }

    private void updateVisibility() {
        if (this.module.getTimeSeriesModel().isPaused()) {
            this.showMe();
        } else {
            this.hideMe();
        }
    }

    private void hideMe() {
        this.setVisible(false);
    }

    private void showMe() {
        this.setVisible(true);
    }

    public void relayout() {
        JComponent jComponent = this.module.getSimulationPanel();
        int n = this.insetX;
        int n2 = (int)((double)jComponent.getHeight() - this.getFullBounds().getHeight() - (double)this.insetY);
        if (this.getOffset().getX() != (double)n || this.getOffset().getY() != (double)n2) {
            this.setOffset(n, n2);
        }
    }
}

