/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.piccolo;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;

public class PieChartNode
extends PNode {
    private PieValue[] slices;
    private Rectangle area;

    public PieChartNode(PieValue[] pieValueArray, Rectangle rectangle) {
        this.slices = pieValueArray;
        this.area = rectangle;
        this.update();
    }

    public void setPieValues(PieValue[] pieValueArray) {
        this.slices = pieValueArray;
        this.update();
    }

    public void setArea(Rectangle rectangle) {
        this.area = rectangle;
        this.update();
    }

    private void update() {
        this.removeAllChildren();
        double d = 0.0;
        for (int i = 0; i < this.slices.length; ++i) {
            d += this.slices[i].value;
        }
        double d2 = 0.0;
        int n = 0;
        for (int i = 0; i < this.slices.length; ++i) {
            n = (int)(d2 * 360.0 / d);
            int n2 = (int)(this.slices[i].value * 360.0 / d);
            if (i == this.slices.length - 1) {
                n2 = 360 - n;
            }
            PPath pPath = new PPath(new Arc2D.Double(this.area.x, this.area.y, this.area.width, this.area.height, n, n2, 2));
            pPath.setPaint(this.slices[i].color);
            this.addChild(pPath);
            d2 += this.slices[i].value;
        }
    }

    public static class PieValue {
        double value;
        Color color;

        public PieValue(double d, Color color) {
            this.value = d;
            this.color = color;
        }
    }
}

