/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.piccolo;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.energyskatepark.EnergySkateParkModule;
import edu.colorado.phet.energyskatepark.EnergySkateParkStrings;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkUtils;
import edu.colorado.phet.energyskatepark.view.piccolo.SkaterNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class ReturnSkaterButtonNode
extends PhetPNode {
    private EnergySkateParkModule module;
    private PSwingCanvas canvas;
    private SkaterNode skaterNode;
    private PNode buttonNode;
    private JButton bringBackSkater = new JButton("");

    public ReturnSkaterButtonNode(PSwingCanvas pSwingCanvas, final EnergySkateParkModule energySkateParkModule, SkaterNode skaterNode) {
        this.canvas = pSwingCanvas;
        this.skaterNode = skaterNode;
        this.module = energySkateParkModule;
        EnergySkateParkUtils.fixButtonOpacity(this.bringBackSkater);
        this.bringBackSkater.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                energySkateParkModule.returnOrResetSkater();
            }
        });
        this.buttonNode = new PhetPNode(new PSwing(this.bringBackSkater));
        this.addChild(this.buttonNode);
        energySkateParkModule.getEnergySkateParkModel().addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void primaryBodyChanged() {
                ReturnSkaterButtonNode.this.update();
            }
        });
        this.update();
    }

    private void updateText() {
        if (this.skaterNode != null) {
            this.bringBackSkater.setText(EnergySkateParkStrings.getString("controls.bring-back") + " " + this.skaterNode.getBody().getSkaterCharacter().getName());
        }
    }

    private void update() {
        this.updateText();
        this.updateVisible();
        this.updateLocation();
    }

    private void updateVisible() {
        if (this.skaterNode == null) {
            this.setVisible(false);
        } else {
            this.setVisible(!this.isSkaterFullyOnscreen());
        }
    }

    private boolean isSkaterFullyOnscreen() {
        return this.module.getEnergySkateParkSimulationPanel().isSkaterOnscreen(this.skaterNode);
    }

    private void updateLocation() {
        this.buttonNode.setOffset((double)(this.canvas.getWidth() / 2) - this.buttonNode.getFullBounds().getWidth() / 2.0, (double)(this.canvas.getHeight() / 2) - this.buttonNode.getFullBounds().getHeight() / 2.0);
    }

    public void setSkaterNode(SkaterNode skaterNode) {
        this.skaterNode = skaterNode;
        this.update();
    }
}

