/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.piccolo;

import edu.colorado.phet.common.phetcommon.math.AbstractVector2D;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.energyskatepark.SkaterCharacter;
import edu.colorado.phet.energyskatepark.model.Body;
import edu.colorado.phet.energyskatepark.model.TraversalState;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class SkaterNode
extends PNode {
    private Body body;
    private double heightDivisor = 1.0;
    private PImage skaterImageNode;
    private PPath centerDebugger;
    protected boolean debugCenter = true;
    private PNode jetPackNode;
    private BufferedImage jetPackImage;
    private BufferedImage skaterImage;
    private Body.ListenerAdapter bodyListener = new Body.ListenerAdapter(){

        public void thrustChanged() {
            SkaterNode.this.update();
        }

        public void dimensionChanged() {
            SkaterNode.this.update();
        }

        public void positionAngleChanged() {
            SkaterNode.this.update();
        }

        public void skaterCharacterChanged() {
            SkaterNode.this.setSkaterCharacter(SkaterNode.this.body.getSkaterCharacter());
            SkaterNode.this.update();
        }
    };

    public SkaterNode(Body body) {
        this.body = body;
        if (body == null) {
            throw new IllegalArgumentException("Body cannot be null in " + this.getClass().getName());
        }
        try {
            this.jetPackImage = ImageLoader.loadBufferedImage("energy-skate-park/images/rocket5.png");
            this.jetPackNode = new PhetPNode(new PImage(this.jetPackImage));
            this.addChild(this.jetPackNode);
            this.skaterImage = ImageLoader.loadBufferedImage("energy-skate-park/images/skater3.png");
            this.skaterImageNode = new PImage(this.skaterImage);
            this.addChild(this.skaterImageNode);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.centerDebugger = new PhetPPath(Color.red);
        if (this.debugCenter) {
            this.addChild(this.centerDebugger);
        }
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseDragged(PInputEvent pInputEvent) {
                PDimension pDimension = pInputEvent.getDeltaRelativeTo(SkaterNode.this);
                boolean bl = true;
                SkaterNode.this.getBody().translate(pDimension.getWidth(), pDimension.getHeight());
                double d = SkaterNode.this.getBody().getCenterOfMass().getY();
                if (d <= 0.0) {
                    bl = false;
                }
                SkaterNode.this.getBody().translate(-pDimension.getWidth(), -pDimension.getHeight());
                if (bl) {
                    SkaterNode.this.getBody().translate(pDimension.getWidth(), pDimension.getHeight());
                    SkaterNode.this.updateDragAngle();
                }
            }
        });
        this.addInputEventListener(new CursorHandler(12));
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                SkaterNode.this.getBody().setUserControlled(true);
                SkaterNode.this.getBody().setVelocity(0.0, 0.0);
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                SkaterNode.this.getBody().setUserControlled(false);
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                SkaterNode.this.getBody().setUserControlled(true);
                SkaterNode.this.getBody().setVelocity(0.0, 0.0);
            }
        });
        this.getBody().addListener(this.bodyListener);
        this.update();
    }

    private void updateDragAngle() {
        TraversalState traversalState = this.getBody().getTrackMatch(0.0, -2.0);
        if (traversalState != null) {
            AbstractVector2D abstractVector2D = traversalState.getParametricFunction2D().getUnitNormalVector(traversalState.getAlpha());
            double d = traversalState.isTop() ? 1.0 : -1.0;
            AbstractVector2D abstractVector2D2 = abstractVector2D.getInstanceOfMagnitude(d);
            this.getBody().setAngle(abstractVector2D2.getAngle() - 1.5707963267948966);
        }
    }

    public Body getBody() {
        return this.body;
    }

    public void setBody(Body body) {
        this.setBodyNoUpdate(body);
        this.update();
    }

    protected void setBodyNoUpdate(Body body) {
        this.body.removeListener(this.bodyListener);
        this.body = body;
        this.body.addListener(this.bodyListener);
    }

    private void update() {
        this.updateSkaterTransform();
        this.jetPackNode.setVisible(this.body.getThrust().getMagnitude() > 0.0);
        this.updateJetPackTransform();
        double d = 0.085;
        Ellipse2D.Double double_ = new Ellipse2D.Double(this.body.getCenterOfMass().getX() - d / 2.0, this.body.getCenterOfMass().getY() - d / 2.0, d, d);
        this.centerDebugger.setPathTo(double_);
    }

    public Rectangle2D getRedDotGlobalFullBounds() {
        return this.centerDebugger.getGlobalFullBounds();
    }

    private void updateJetPackTransform() {
        this.jetPackNode.setTransform(new AffineTransform());
        this.jetPackNode.setOffset(this.skaterImageNode.getFullBounds().getCenter2D());
        this.jetPackNode.transformBy(AffineTransform.getScaleInstance(2.0 * this.body.getWidth() / (double)this.skaterImage.getWidth(), -2.0 * this.body.getHeight() / (double)this.skaterImage.getHeight()));
        this.jetPackNode.translate(-this.jetPackImage.getWidth() / 2, -this.jetPackImage.getHeight() / 2);
        this.jetPackNode.rotateAboutPoint(-this.body.getThrust().getAngle() + 1.5707963267948966, this.jetPackImage.getWidth() / 2, this.jetPackImage.getHeight() / 2);
        if (this.body.isFacingRight()) {
            this.jetPackNode.transformBy(AffineTransform.getScaleInstance(-1.0, 1.0));
            this.jetPackNode.translate(-this.jetPackImage.getWidth(), 0.0);
        }
    }

    private void updateSkaterTransform() {
        this.skaterImageNode.setTransform(new AffineTransform());
        this.skaterImageNode.setOffset(this.body.getX(), this.body.getY());
        this.skaterImageNode.transformBy(AffineTransform.getScaleInstance(this.body.getWidth() / (double)this.skaterImage.getWidth(), -this.body.getHeight() / (double)this.skaterImage.getHeight()));
        this.skaterImageNode.rotate(-this.body.getAngle());
        this.skaterImageNode.translate(-this.skaterImage.getWidth() / 2, (double)(-this.skaterImage.getHeight()) / this.heightDivisor);
        if (this.body.isFacingRight()) {
            this.skaterImageNode.transformBy(AffineTransform.getScaleInstance(-1.0, 1.0));
            this.skaterImageNode.translate(-this.skaterImage.getWidth(), 0.0);
        }
    }

    public void setSkaterCharacter(SkaterCharacter skaterCharacter) {
        this.skaterImage = skaterCharacter.getImage();
        this.skaterImageNode.setImage(this.skaterImage);
        this.heightDivisor = skaterCharacter.getHeightDivisor();
        this.update();
    }

    public void delete() {
        this.body.removeListener(this.bodyListener);
    }
}

