/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.piccolo;

import edu.colorado.phet.common.phetcommon.math.SerializablePoint2D;
import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.event.PopupMenuHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.energyskatepark.EnergySkateParkStrings;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkSpline;
import edu.colorado.phet.energyskatepark.model.physics.ParametricFunction2D;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkSplineEnvironment;
import edu.colorado.phet.energyskatepark.view.SplineMatch;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SplineNode
extends PNode {
    private TrackNode splinePath;
    private PhetPPath rollerCoasterPath;
    private PNode controlPointLayer;
    private Point2D.Double[] initDragSpline;
    private Point2D.Double controlPointLoc;
    private BasicStroke dottedStroke = new BasicStroke(0.03f, 2, 0, 1.0f, new float[]{0.09f, 0.09f}, 0.0f);
    private BasicStroke lineStroke = new BasicStroke(0.03f);
    private EnergySkateParkSpline spline;
    private EnergySkateParkSpline lastState;
    private PBasicInputEventHandler dragHandler;
    private JComponent parent;
    private EnergySkateParkSplineEnvironment splineEnvironment;
    private TrackNode centerPath;
    private TrackPopupMenu popupMenu;
    private EnergySkateParkSpline.Listener splineListener;

    public SplineNode(JComponent jComponent, EnergySkateParkSpline energySkateParkSpline, EnergySkateParkSplineEnvironment energySkateParkSplineEnvironment) {
        this.parent = jComponent;
        this.splineEnvironment = energySkateParkSplineEnvironment;
        this.spline = energySkateParkSpline;
        this.splinePath = new TrackNode(0.75f, Color.gray);
        this.centerPath = new TrackNode(0.15f, new Color(235, 193, 56));
        this.rollerCoasterPath = new PhetPPath(this.getRailroadStroke(0.4f), (Paint)Color.gray);
        this.rollerCoasterPath.setPickable(false);
        this.rollerCoasterPath.setChildrenPickable(false);
        this.centerPath.setPickable(false);
        this.centerPath.setChildrenPickable(false);
        this.controlPointLayer = new PNode();
        this.addChild(this.splinePath);
        this.addChild(this.centerPath);
        this.addChild(this.rollerCoasterPath);
        this.addChild(this.controlPointLayer);
        this.dragHandler = new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                SplineNode.this.initDragSpline();
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                SplineNode.this.dragSpline(pInputEvent);
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                SplineNode.this.finishDragSpline(pInputEvent);
            }
        };
        this.splinePath.addInputEventListener(this.dragHandler);
        this.splinePath.addInputEventListener(new CursorHandler(12));
        this.popupMenu = new TrackPopupMenu(energySkateParkSplineEnvironment);
        this.splinePath.addInputEventListener(new PopupMenuHandler(jComponent, this.popupMenu));
        this.splineListener = new EnergySkateParkSpline.Listener(){

            public void rollerCoasterModeChanged() {
                SplineNode.this.update();
            }

            public void controlPointsChanged() {
                SplineNode.this.update();
            }
        };
        energySkateParkSpline.addListener(this.splineListener);
        this.update();
    }

    private void showColorControls() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        jPanel.add((Component)new TrackEditPanel(this.splinePath, "Outside Line"), gridBagConstraints);
        jPanel.add((Component)new TrackEditPanel(this.centerPath, "Center Line"), gridBagConstraints);
        JDialog jDialog = new JDialog((Frame)SwingUtilities.getWindowAncestor(this.parent));
        jDialog.setContentPane(jPanel);
        jDialog.pack();
        SwingUtils.centerDialogInParent(jDialog);
        jDialog.setVisible(true);
    }

    public ParametricFunction2D getParametricFunction2D() {
        return this.spline.getParametricFunction2D();
    }

    private BasicStroke getTrackStroke(float f) {
        return new BasicStroke((float)(0.25 * (double)f));
    }

    private BasicStroke getRailroadStroke(float f) {
        return new BasicStroke((float)(0.25 * (double)f), 0, 0, 1.0f, new float[]{0.1f, 0.15f}, 0.0f);
    }

    private void dragSpline(PInputEvent pInputEvent) {
        Point2D.Double double_ = new Point2D.Double(pInputEvent.getDeltaRelativeTo((PNode)this).width, pInputEvent.getDeltaRelativeTo((PNode)this).height);
        this.dragSpline(pInputEvent, double_);
    }

    private void dragSpline(PInputEvent pInputEvent, Point2D.Double double_) {
        this.translateAll(double_);
        if (this.isAttachAllowed(pInputEvent)) {
            this.proposeMatchesTrunk();
        }
    }

    public EnergySkateParkSpline getSpline() {
        return this.spline;
    }

    public void detachListeners() {
        this.spline.removeListener(this.splineListener);
        this.popupMenu.detachListeners();
    }

    public void setSpline(EnergySkateParkSpline energySkateParkSpline) {
        this.detachListeners();
        this.spline = energySkateParkSpline;
        this.spline.addListener(this.splineListener);
        this.popupMenu.attachListeners(energySkateParkSpline);
        this.update();
    }

    public void processExternalStartDragEvent() {
        this.initDragSpline();
    }

    public void processExternalDragEvent(PInputEvent pInputEvent, double d, double d2) {
        this.dragSpline(pInputEvent, new Point2D.Double(d, d2));
    }

    public void processExternalDropEvent(PInputEvent pInputEvent) {
        this.finishDragSpline(pInputEvent);
    }

    private void finishDragSpline(PInputEvent pInputEvent) {
        boolean bl;
        if (this.isAttachAllowed(pInputEvent) && !(bl = this.testAttach(0))) {
            this.testAttach(this.numControlPointGraphics() - 1);
        }
        this.initDragSpline = null;
        this.spline.setUserControlled(false);
    }

    private boolean testAttach(int n) {
        SplineMatch splineMatch = this.getTrunkMatch(n);
        if (splineMatch != null) {
            this.attach(n, splineMatch);
            return true;
        }
        return false;
    }

    private void initDragSpline() {
        this.spline.setUserControlled(true);
        this.initDragSpline = new Point2D.Double[this.spline.getControlPoints().length];
        for (int i = 0; i < this.initDragSpline.length; ++i) {
            this.initDragSpline[i] = new Point2D.Double(this.spline.getControlPoint(i).getX(), this.spline.getControlPoint(i).getY());
        }
    }

    private void proposeMatchesTrunk() {
        boolean bl = this.proposeMatchTrunk(0);
        if (!bl) {
            this.proposeMatchTrunk(this.numControlPointGraphics() - 1);
        }
    }

    private boolean proposeMatchTrunk(int n) {
        SplineMatch splineMatch = this.getTrunkMatch(n);
        if (splineMatch != null) {
            this.spline.setControlPointLocation(n, new SerializablePoint2D(splineMatch.getTarget().getFullBounds().getCenter2D()));
            return true;
        }
        this.spline.setControlPointLocation(n, new SerializablePoint2D(this.initDragSpline[n]));
        return false;
    }

    private SplineMatch getTrunkMatch(int n) {
        if (this.initDragSpline == null) {
            System.out.println("initdragspline was null");
            return null;
        }
        if (n < 0 || n > this.initDragSpline.length) {
            System.out.println("index = " + n + ", initDragSpline.length=" + this.initDragSpline.length);
            return null;
        }
        Point2D.Double double_ = new Point2D.Double(this.initDragSpline[n].getX(), this.initDragSpline[n].getY());
        return this.splineEnvironment.proposeMatch(this, double_);
    }

    private void translateAll(Point2D point2D) {
        this.translateAll(point2D.getX(), point2D.getY());
    }

    private void translateAll(double d, double d2) {
        this.spline.translate(d, d2);
        for (int i = 0; i < this.initDragSpline.length; ++i) {
            this.initDragSpline[i].x += d;
            this.initDragSpline[i].y += d2;
        }
    }

    private void update() {
        this.setPickable(this.spline.isInteractive());
        this.setChildrenPickable(this.spline.isInteractive());
        if (this.changed()) {
            Cloneable cloneable;
            int n;
            GeneralPath generalPath = this.spline.getInterpolationPath();
            this.splinePath.setPathTo(generalPath);
            this.centerPath.setPathTo(generalPath);
            this.rollerCoasterPath.setPathTo(generalPath);
            this.rollerCoasterPath.setVisible(this.spline.isRollerCoasterMode());
            this.rollerCoasterPath.setStrokePaint(this.spline.isRollerCoasterMode() ? Color.gray : Color.black);
            this.controlPointLayer.removeAllChildren();
            for (n = 0; n < this.spline.numControlPoints(); ++n) {
                cloneable = this.spline.getControlPoint(n);
                this.addControlPoint((Point2D)cloneable, n);
            }
            for (n = 0; n < this.controlPointLayer.getChildrenCount(); ++n) {
                cloneable = (PPath)this.controlPointLayer.getChild(n);
                if (n == 0 || n == this.controlPointLayer.getChildrenCount() - 1) {
                    ((PPath)cloneable).setStroke(this.dottedStroke);
                    ((PPath)cloneable).setStrokePaint(Color.red);
                    continue;
                }
                ((PPath)cloneable).setStroke(this.lineStroke);
                ((PPath)cloneable).setStrokePaint(Color.black);
            }
            this.lastState = this.spline.copy();
        }
        this.popupMenu.updateAll();
    }

    private boolean changed() {
        return this.lastState == null || !this.same();
    }

    private boolean same() {
        return this.lastState.equals(this.spline.copy());
    }

    public boolean isAttachAllowed(PInputEvent pInputEvent) {
        return !pInputEvent.isControlDown();
    }

    private void addControlPoint(Point2D point2D, int n) {
        this.controlPointLayer.addChild(new ControlPointNode(point2D.getX(), point2D.getY(), 0.5, n));
    }

    private void proposeMatchesEndpoint(int n) {
        if (n == 0 || n == this.numControlPointGraphics() - 1) {
            SplineMatch splineMatch = this.getEndpointMatch();
            System.out.println("match=" + splineMatch);
            if (splineMatch != null) {
                this.spline.setControlPointLocation(n, new SerializablePoint2D(splineMatch.getTarget().getFullBounds().getCenter2D()));
            } else {
                this.spline.setControlPointLocation(n, new SerializablePoint2D(this.controlPointLoc));
            }
        }
    }

    private SplineMatch getEndpointMatch() {
        Point2D.Double double_ = new Point2D.Double(this.controlPointLoc.getX(), this.controlPointLoc.getY());
        return this.splineEnvironment.proposeMatch(this, double_);
    }

    private void finishDragControlPoint(int n) {
        if (n == 0 || n == this.numControlPointGraphics() - 1) {
            SplineMatch splineMatch = this.getEndpointMatch();
            if (splineMatch != null) {
                this.attach(n, splineMatch);
            }
            this.controlPointLoc = null;
        }
    }

    private void attach(int n, SplineMatch splineMatch) {
        this.splineEnvironment.attach(this, n, splineMatch);
    }

    private void initDragControlPoint(int n) {
        if (n == 0 || n == this.numControlPointGraphics() - 1) {
            this.controlPointLoc = new Point2D.Double(this.spline.getControlPoint(n).getX(), this.spline.getControlPoint(n).getY());
        }
    }

    public PNode getControlPointGraphic(int n) {
        return this.controlPointLayer.getChild(n);
    }

    public int numControlPointGraphics() {
        return this.controlPointLayer.getChildrenCount();
    }

    public void setControlPointsPickable(boolean bl) {
        this.controlPointLayer.setPickable(bl);
        this.controlPointLayer.setChildrenPickable(bl);
        for (int i = 0; i < this.numControlPointGraphics(); ++i) {
            this.getControlPointGraphic(i).setPickable(bl);
            this.getControlPointGraphic(i).setChildrenPickable(bl);
        }
        this.update();
    }

    static /* synthetic */ void access$700(SplineNode splineNode, int n) {
        splineNode.initDragControlPoint(n);
    }

    static /* synthetic */ void access$900(SplineNode splineNode, int n) {
        splineNode.finishDragControlPoint(n);
    }

    static /* synthetic */ Point2D.Double access$1000(SplineNode splineNode) {
        return splineNode.controlPointLoc;
    }

    static /* synthetic */ void access$1100(SplineNode splineNode, int n) {
        splineNode.proposeMatchesEndpoint(n);
    }

    static /* synthetic */ EnergySkateParkSplineEnvironment access$1400(SplineNode splineNode) {
        return splineNode.splineEnvironment;
    }

    static /* synthetic */ EnergySkateParkSpline access$1702(SplineNode splineNode, EnergySkateParkSpline energySkateParkSpline) {
        splineNode.lastState = energySkateParkSpline;
        return splineNode.lastState;
    }

    static /* synthetic */ void access$1800(SplineNode splineNode) {
        splineNode.showColorControls();
    }

    class TrackNode
    extends PhetPPath {
        private float thickness;
        private Color color;

        public TrackNode(float f, Color color) {
            super(SplineNode.this.getTrackStroke(f), (Paint)color);
            this.thickness = f;
            this.color = color;
        }

        public float getThickness() {
            return this.thickness;
        }

        public void setThickness(float f) {
            this.thickness = f;
            this.setStroke(SplineNode.this.getTrackStroke(f));
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
            this.setStrokePaint(color);
        }
    }

    class TrackPopupMenu
    extends JPopupMenu {
        private JCheckBoxMenuItem rollerCoasterMode;
        private EnergySkateParkSpline.Listener splineListener = new EnergySkateParkSpline.Listener(this){
            private final /* synthetic */ TrackPopupMenu this$1;
            {
                this.this$1 = trackPopupMenu;
            }

            public void rollerCoasterModeChanged() {
                TrackPopupMenu.access$400(this.this$1);
            }

            public void controlPointsChanged() {
            }
        };

        public TrackPopupMenu(EnergySkateParkSplineEnvironment energySkateParkSplineEnvironment) {
            this.rollerCoasterMode = new JCheckBoxMenuItem("Roller-Coaster Mode", SplineNode.this.spline.isRollerCoasterMode());
            this.attachListeners(SplineNode.this.spline);
            this.rollerCoasterMode.addActionListener(new ActionListener(this){
                private final /* synthetic */ TrackPopupMenu this$1;
                {
                    this.this$1 = trackPopupMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    SplineNode.access$800(TrackPopupMenu.access$1600(this.this$1)).setRollerCoasterMode(TrackPopupMenu.access$1500(this.this$1).isSelected());
                    SplineNode.access$1702(TrackPopupMenu.access$1600(this.this$1), null);
                }
            });
            JMenuItem jMenuItem = new JMenuItem(EnergySkateParkStrings.getString("controls.delete-track"));
            jMenuItem.addActionListener(new ActionListener(this, energySkateParkSplineEnvironment, SplineNode.this){
                private final /* synthetic */ EnergySkateParkSplineEnvironment val$splineEnvironment;
                private final /* synthetic */ SplineNode val$this$0;
                private final /* synthetic */ TrackPopupMenu this$1;
                {
                    this.this$1 = trackPopupMenu;
                    this.val$splineEnvironment = energySkateParkSplineEnvironment;
                    this.val$this$0 = splineNode;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.val$splineEnvironment.removeSpline(TrackPopupMenu.access$1600(this.this$1));
                }
            });
            JMenuItem jMenuItem2 = new JMenuItem("Edit look");
            jMenuItem2.addActionListener(new ActionListener(this){
                private final /* synthetic */ TrackPopupMenu this$1;
                {
                    this.this$1 = trackPopupMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    SplineNode.access$1800(TrackPopupMenu.access$1600(this.this$1));
                }
            });
            this.add(this.rollerCoasterMode);
            this.addSeparator();
            this.add(jMenuItem);
            this.addSeparator();
            this.add(jMenuItem2);
        }

        public void detachListeners() {
            SplineNode.this.spline.removeListener(this.splineListener);
        }

        private void updateAll() {
            this.rollerCoasterMode.setSelected(SplineNode.this.spline.isRollerCoasterMode());
        }

        public void attachListeners(EnergySkateParkSpline energySkateParkSpline) {
            energySkateParkSpline.addListener(this.splineListener);
        }

        static /* synthetic */ JCheckBoxMenuItem access$1500(TrackPopupMenu trackPopupMenu) {
            return trackPopupMenu.rollerCoasterMode;
        }

        static /* synthetic */ SplineNode access$1600(TrackPopupMenu trackPopupMenu) {
            return trackPopupMenu.SplineNode.this;
        }
    }

    class TrackEditPanel
    extends JPanel {
        public TrackEditPanel(TrackNode trackNode, String string) {
            ModelSlider modelSlider = new ModelSlider(string, "", 0.0, 10.0, trackNode.getThickness());
            modelSlider.addChangeListener(new ChangeListener(this, trackNode, modelSlider){
                private final /* synthetic */ TrackNode val$splinePath;
                private final /* synthetic */ ModelSlider val$modelSlider;
                private final /* synthetic */ TrackEditPanel this$1;
                {
                    this.this$1 = trackEditPanel;
                    this.val$splinePath = trackNode;
                    this.val$modelSlider = modelSlider;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    this.val$splinePath.setThickness((float)this.val$modelSlider.getValue());
                }
            });
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = 0;
            JColorChooser jColorChooser = new JColorChooser(trackNode.getColor());
            jColorChooser.getSelectionModel().addChangeListener(new ChangeListener(this, trackNode, jColorChooser){
                private final /* synthetic */ TrackNode val$splinePath;
                private final /* synthetic */ JColorChooser val$colorChooser;
                private final /* synthetic */ TrackEditPanel this$1;
                {
                    this.this$1 = trackEditPanel;
                    this.val$splinePath = trackNode;
                    this.val$colorChooser = jColorChooser;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    this.val$splinePath.setColor(this.val$colorChooser.getColor());
                }
            });
            this.add((Component)modelSlider, gridBagConstraints);
            this.add((Component)jColorChooser, gridBagConstraints);
        }
    }

    class ControlCirclePopupMenu
    extends JPopupMenu {
        public ControlCirclePopupMenu(int n) {
            super(EnergySkateParkStrings.getString("controls.circle-popup-menu"));
            JMenuItem jMenuItem = new JMenuItem(EnergySkateParkStrings.getString("controls.delete-point"));
            jMenuItem.addActionListener(new ActionListener(this, SplineNode.this, n){
                private final /* synthetic */ SplineNode val$this$0;
                private final /* synthetic */ int val$index;
                private final /* synthetic */ ControlCirclePopupMenu this$1;
                {
                    this.this$1 = controlCirclePopupMenu;
                    this.val$this$0 = splineNode;
                    this.val$index = n;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (SplineNode.access$800(ControlCirclePopupMenu.access$1300(this.this$1)).numControlPoints() == 1) {
                        SplineNode.access$1400(ControlCirclePopupMenu.access$1300(this.this$1)).removeSpline(ControlCirclePopupMenu.access$1300(this.this$1));
                    } else {
                        SplineNode.access$800(ControlCirclePopupMenu.access$1300(this.this$1)).removeControlPoint(this.val$index);
                    }
                }
            });
            this.add(jMenuItem);
        }

        static /* synthetic */ SplineNode access$1300(ControlCirclePopupMenu controlCirclePopupMenu) {
            return controlCirclePopupMenu.SplineNode.this;
        }
    }

    private class ControlPointNode
    extends PPath {
        public ControlPointNode(double d, double d2, double d3, int n) {
            super(new Ellipse2D.Double(d - d3 / 2.0, d2 - d3 / 2.0, d3, d3));
            this.setStroke(SplineNode.this.dottedStroke);
            this.setStrokePaint(Color.black);
            this.setPaint(new Color(0.0f, 0.0f, 1.0f, 0.5f));
            this.addInputEventListener(new PBasicInputEventHandler(this, n, SplineNode.this){
                private final /* synthetic */ int val$index;
                private final /* synthetic */ SplineNode val$this$0;
                private final /* synthetic */ ControlPointNode this$1;
                {
                    this.this$1 = controlPointNode;
                    this.val$index = n;
                    this.val$this$0 = splineNode;
                }

                public void mousePressed(PInputEvent pInputEvent) {
                    SplineNode.access$700(ControlPointNode.access$600(this.this$1), this.val$index);
                    SplineNode.access$800(ControlPointNode.access$600(this.this$1)).setUserControlled(true);
                    pInputEvent.setHandled(true);
                }

                public void mouseReleased(PInputEvent pInputEvent) {
                    if (ControlPointNode.access$600(this.this$1).isAttachAllowed(pInputEvent)) {
                        SplineNode.access$900(ControlPointNode.access$600(this.this$1), this.val$index);
                    }
                    SplineNode.access$800(ControlPointNode.access$600(this.this$1)).setUserControlled(false);
                    pInputEvent.setHandled(true);
                }

                public void mouseDragged(PInputEvent pInputEvent) {
                    PDimension pDimension = pInputEvent.getDeltaRelativeTo(ControlPointNode.access$600(this.this$1));
                    double d = 0.1;
                    if (SplineNode.access$800(ControlPointNode.access$600(this.this$1)).getControlPoints()[this.val$index].getY() + pDimension.getHeight() < d) {
                        pDimension.height = d - SplineNode.access$800(ControlPointNode.access$600(this.this$1)).getControlPoints()[this.val$index].getY();
                    }
                    SplineNode.access$800(ControlPointNode.access$600(this.this$1)).translateControlPoint(this.val$index, pDimension.getWidth(), pDimension.getHeight());
                    if (this.val$index == 0 || this.val$index == ControlPointNode.access$600(this.this$1).numControlPointGraphics() - 1) {
                        SplineNode.access$1000((SplineNode)ControlPointNode.access$600((ControlPointNode)this.this$1)).x += pDimension.getWidth();
                        SplineNode.access$1000((SplineNode)ControlPointNode.access$600((ControlPointNode)this.this$1)).y += pDimension.getHeight();
                    }
                    if (ControlPointNode.access$600(this.this$1).isAttachAllowed(pInputEvent)) {
                        SplineNode.access$1100(ControlPointNode.access$600(this.this$1), this.val$index);
                    }
                    pInputEvent.setHandled(true);
                }
            });
            this.addInputEventListener(new CursorHandler(12));
            this.addInputEventListener(new PopupMenuHandler(SplineNode.this.parent, new ControlCirclePopupMenu(n)));
        }

        static /* synthetic */ SplineNode access$600(ControlPointNode controlPointNode) {
            return controlPointNode.SplineNode.this;
        }
    }
}

