/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.piccolo;

import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.energyskatepark.EnergySkateParkStrings;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkSpline;
import edu.colorado.phet.energyskatepark.model.PreFabSplines;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkSimulationPanel;
import edu.colorado.phet.energyskatepark.view.piccolo.SplineNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Point2D;

public class SplineToolboxNode
extends PNode {
    private EnergySkateParkSimulationPanel energySkateParkSimulationPanel;
    private PText textGraphic;
    private PNode draggableIcon;
    private PPath boundGraphic;
    private boolean created = false;
    private EnergySkateParkSpline createdSurface;

    public SplineToolboxNode(final EnergySkateParkSimulationPanel energySkateParkSimulationPanel) {
        this.energySkateParkSimulationPanel = energySkateParkSimulationPanel;
        this.draggableIcon = new PNodeFacade(this.createSplineGraphic());
        this.draggableIcon.addInputEventListener(new CursorHandler());
        this.draggableIcon.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseDragged(PInputEvent pInputEvent) {
                if (!SplineToolboxNode.this.created) {
                    this.create(pInputEvent);
                    SplineToolboxNode.this.created = true;
                } else {
                    this.drag(pInputEvent);
                }
            }

            private void drag(PInputEvent pInputEvent) {
                energySkateParkSimulationPanel.dragSplineSurface(pInputEvent, SplineToolboxNode.this.createdSurface);
            }

            private void create(PInputEvent pInputEvent) {
                Point2D.Double double_ = new Point2D.Double(pInputEvent.getCanvasPosition().getX(), pInputEvent.getCanvasPosition().getY());
                energySkateParkSimulationPanel.getRootNode().screenToWorld(double_);
                PreFabSplines.CubicSpline cubicSpline = new PreFabSplines.CubicSpline();
                cubicSpline.addControlPoint(((Point2D)double_).getX() - 1.0, ((Point2D)double_).getY());
                cubicSpline.addControlPoint(((Point2D)double_).getX(), ((Point2D)double_).getY());
                cubicSpline.addControlPoint(((Point2D)double_).getX() + 1.0, ((Point2D)double_).getY());
                SplineToolboxNode.this.createdSurface = new EnergySkateParkSpline(cubicSpline.getControlPoints());
                energySkateParkSimulationPanel.getEnergySkateParkModel().addSplineSurface(SplineToolboxNode.this.createdSurface);
                energySkateParkSimulationPanel.getSplineNode(SplineToolboxNode.this.createdSurface).processExternalStartDragEvent();
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                energySkateParkSimulationPanel.getSplineNode(SplineToolboxNode.this.createdSurface).processExternalDropEvent(pInputEvent);
                SplineToolboxNode.this.created = false;
            }
        });
        this.boundGraphic = new PPath(new Rectangle(200, 60));
        this.boundGraphic.setStroke(new BasicStroke(2.0f));
        this.boundGraphic.setStrokePaint(Color.blue);
        this.boundGraphic.setPaint(Color.yellow);
        this.addChild(this.boundGraphic);
        this.textGraphic = new PText(EnergySkateParkStrings.getString("controls.add-track"));
        this.textGraphic.setFont(new Font("Lucida Sans", 1, 14));
        this.textGraphic.setOffset(this.boundGraphic.getFullBounds().getX() + 5.0, this.boundGraphic.getFullBounds().getY() + 2.0);
        this.addChild(this.textGraphic);
        this.addChild(this.draggableIcon);
        energySkateParkSimulationPanel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                SplineToolboxNode.this.centerTheNode();
            }
        });
        this.centerTheNode();
    }

    private void centerTheNode() {
        this.draggableIcon.setScale(60.0);
        this.draggableIcon.setOffset(this.boundGraphic.getFullBounds().getWidth() / 2.0 - this.draggableIcon.getFullBounds().getWidth() / 2.0, this.boundGraphic.getFullBounds().getHeight() / 2.0);
    }

    private SplineNode createSplineGraphic() {
        EnergySkateParkSpline energySkateParkSpline = this.createSplineSurface();
        SplineNode splineNode = new SplineNode(this.energySkateParkSimulationPanel, energySkateParkSpline, this.energySkateParkSimulationPanel);
        splineNode.setControlPointsPickable(false);
        return splineNode;
    }

    private EnergySkateParkSpline createSplineSurface() {
        PreFabSplines.CubicSpline cubicSpline = new PreFabSplines.CubicSpline();
        cubicSpline.addControlPoint(0.0, 0.0);
        cubicSpline.addControlPoint(1.0, 0.0);
        cubicSpline.addControlPoint(2.0, 0.0);
        return new EnergySkateParkSpline(cubicSpline.getControlPoints());
    }

    public static class PNodeFacade
    extends PNode {
        public PNodeFacade(PNode pNode) {
            this.addChild(pNode);
            pNode.setPickable(false);
            pNode.setChildrenPickable(false);
            PBounds pBounds = pNode.getFullBounds();
            this.addChild(new PhetPPath((Shape)pBounds, (Paint)new Color(0, 0, 0, 0)));
        }
    }
}

