/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.piccolo;

import edu.colorado.phet.common.phetcommon.view.util.PhetDefaultFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.ShadowPText;
import edu.colorado.phet.energyskatepark.EnergySkateParkStrings;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkSimulationPanel;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class ZeroPointPotentialNode
extends PhetPNode {
    private EnergySkateParkSimulationPanel panel;
    private EnergySkateParkModel model;

    public ZeroPointPotentialNode(final EnergySkateParkSimulationPanel energySkateParkSimulationPanel, EnergySkateParkModel energySkateParkModel) {
        this.panel = energySkateParkSimulationPanel;
        this.model = energySkateParkModel;
        PhetPPath phetPPath = new PhetPPath(new Line2D.Double(0.0, 0.0, 5000.0, 0.0), (Stroke)new BasicStroke(30.0f, 2, 0, 3.0f), (Paint)new Color(0, 0, 0, 0));
        this.addChild(phetPPath);
        PhetPPath phetPPath2 = new PhetPPath(new Line2D.Double(0.0, 0.0, 5000.0, 0.0), (Stroke)new BasicStroke(3.0f, 2, 0, 3.0f, new float[]{16.0f, 8.0f}, 0.0f), (Paint)Color.blue);
        this.addChild(phetPPath2);
        ShadowPText shadowPText = new ShadowPText(EnergySkateParkStrings.getString("label.zero-potential-energy"));
        shadowPText.setFont(new PhetDefaultFont(16, true));
        shadowPText.setTextPaint(Color.black);
        shadowPText.setShadowColor(new Color(128, 128, 255));
        this.addChild(shadowPText);
        shadowPText.setOffset(2.0, 2.0);
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseDragged(PInputEvent pInputEvent) {
                double d = pInputEvent.getCanvasDelta().getHeight();
                PDimension pDimension = new PDimension(0.0, d);
                energySkateParkSimulationPanel.getPhetRootNode().screenToWorld(pDimension);
                energySkateParkSimulationPanel.getEnergySkateParkModel().translateZeroPointPotentialY(pDimension.getHeight());
            }
        });
        this.addInputEventListener(new CursorHandler());
        energySkateParkModel.addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void zeroPointPotentialYChanged() {
                ZeroPointPotentialNode.this.update();
            }
        });
        energySkateParkSimulationPanel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ZeroPointPotentialNode.this.update();
            }

            public void componentShown(ComponentEvent componentEvent) {
                ZeroPointPotentialNode.this.update();
            }
        });
        energySkateParkSimulationPanel.addListener(new EnergySkateParkSimulationPanel.Adapter(){

            public void zoomChanged() {
                ZeroPointPotentialNode.this.update();
            }
        });
        this.update();
    }

    private void update() {
        double d = this.model.getZeroPointPotentialY();
        Point2D.Double double_ = new Point2D.Double(0.0, d);
        this.panel.getPhetRootNode().worldToScreen(double_);
        double d2 = double_.getY();
        this.setOffset(0.0, d2);
    }
}

