/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.swing;

import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.energyskatepark.EnergySkateParkModule;
import edu.colorado.phet.energyskatepark.EnergySkateParkStrings;
import edu.colorado.phet.energyskatepark.SkaterCharacter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;

public class ChooseCharacterDialog
extends JDialog {
    private JPanel contentPanel = new JPanel(new GridBagLayout());
    private GridBagConstraints gridBagConstraints = new GridBagConstraints();
    private ArrayList characterPanels = new ArrayList();
    private EnergySkateParkModule module;

    public ChooseCharacterDialog(EnergySkateParkModule energySkateParkModule) {
        super(energySkateParkModule.getPhetFrame(), EnergySkateParkStrings.getString("controls.choose-character"), false);
        int n;
        this.module = energySkateParkModule;
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = -1;
        this.setContentPane(this.contentPanel);
        JButton jButton = new JButton("Ok");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChooseCharacterDialog.this.dispose();
            }
        });
        SkaterCharacter[] skaterCharacterArray = energySkateParkModule.getSkaterCharacters();
        CharacterPanel[] characterPanelArray = new CharacterPanel[skaterCharacterArray.length];
        for (int i = 0; i < skaterCharacterArray.length; ++i) {
            characterPanelArray[i] = new CharacterPanel(energySkateParkModule, skaterCharacterArray[i]);
        }
        Dimension dimension = new Dimension(0, 0);
        for (n = 0; n < characterPanelArray.length; ++n) {
            dimension.width = Math.max(dimension.width, characterPanelArray[n].getPreferredSize().width);
            dimension.height = Math.max(dimension.height, characterPanelArray[n].getPreferredSize().height);
        }
        for (n = 0; n < skaterCharacterArray.length; ++n) {
            characterPanelArray[n].setPreferredSize(dimension);
            this.addCharacterPanel(characterPanelArray[n]);
        }
        this.contentPanel.add((Component)jButton, this.gridBagConstraints);
        this.pack();
        SwingUtils.centerDialogInParent(this);
    }

    private void addCharacterPanel(final CharacterPanel characterPanel) {
        this.contentPanel.add((Component)characterPanel, this.gridBagConstraints);
        characterPanel.addMouseListener(new MouseInputAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                System.out.println("e = " + mouseEvent);
                ChooseCharacterDialog.this.setSelection(characterPanel);
            }
        });
        characterPanel.setSelected(characterPanel.getSkaterCharacter() == this.module.getSkaterCharacter());
        this.characterPanels.add(characterPanel);
    }

    private void setSelection(CharacterPanel characterPanel) {
        for (int i = 0; i < this.characterPanels.size(); ++i) {
            CharacterPanel characterPanel2;
            characterPanel2.setSelected((characterPanel2 = (CharacterPanel)this.characterPanels.get(i)) == characterPanel);
        }
        this.pack();
    }

    static class CharacterPanel
    extends JPanel {
        private boolean selected = false;
        private EnergySkateParkModule module;
        private SkaterCharacter skaterCharacter;

        public CharacterPanel(EnergySkateParkModule energySkateParkModule, SkaterCharacter skaterCharacter) {
            super(new GridBagLayout());
            this.module = energySkateParkModule;
            this.skaterCharacter = skaterCharacter;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            try {
                JLabel jLabel = new JLabel(skaterCharacter.getName() + " (" + skaterCharacter.getMass() + " kg)", new ImageIcon(BufferedImageUtils.rescaleYMaintainAspectRatio(ImageLoader.loadBufferedImage(skaterCharacter.getImageURL()), (int)(skaterCharacter.getModelHeight() * 75.0))), 11);
                this.add((Component)jLabel, gridBagConstraints);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.setSelected(false);
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
            this.setBorder(bl ? this.getSelectionBorder() : BorderFactory.createEtchedBorder());
            if (bl) {
                this.module.setSkaterCharacter(this.skaterCharacter);
            }
        }

        private Border getSelectionBorder() {
            return BorderFactory.createLineBorder(Color.blue, 3);
        }

        public SkaterCharacter getSkaterCharacter() {
            return this.skaterCharacter;
        }
    }
}

