/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.swing;

import edu.colorado.phet.energyskatepark.EnergySkateParkStrings;
import edu.colorado.phet.energyskatepark.model.Body;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class ClearHeatButton
extends JButton {
    private EnergySkateParkModel model;

    public ClearHeatButton(final EnergySkateParkModel energySkateParkModel) {
        this.model = energySkateParkModel;
        this.setText(EnergySkateParkStrings.getString("controls.clear-heat"));
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                energySkateParkModel.clearHeat();
            }
        });
        energySkateParkModel.addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void primaryBodyChanged() {
                ClearHeatButton.this.update();
            }
        });
    }

    private void update() {
        if (this.model.getNumBodies() > 0) {
            Body body = this.model.getBody(0);
            this.setEnabled(body.getThermalEnergy() > 0.0);
        }
    }
}

