/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.swing;

import edu.colorado.phet.common.phetcommon.view.AdvancedPanel;
import edu.colorado.phet.energyskatepark.EnergySkateParkModule;
import edu.colorado.phet.energyskatepark.EnergySkateParkStrings;
import edu.colorado.phet.energyskatepark.model.Body;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import edu.colorado.phet.energyskatepark.view.swing.EnergySkateParkSlider;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EditSkaterPanel
extends AdvancedPanel {
    private EnergySkateParkModule module;

    public EditSkaterPanel(final EnergySkateParkModule energySkateParkModule) {
        super(EnergySkateParkStrings.getString("controls.edit-skater"), EnergySkateParkStrings.getString("controls.hide-skater-properties"));
        this.module = energySkateParkModule;
        final EnergySkateParkSlider energySkateParkSlider = new EnergySkateParkSlider(EnergySkateParkStrings.getString("controls.bounciness"), "", 0.0, 1.0, 1.0);
        energySkateParkSlider.setModelTicks(new double[]{0.0, 0.5, 1.0});
        energySkateParkSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                energySkateParkModule.setBounciness(energySkateParkSlider.getValue());
            }
        });
        final EnergySkateParkSlider energySkateParkSlider2 = new EnergySkateParkSlider(EnergySkateParkStrings.getString("controls.mass"), EnergySkateParkStrings.getString("units.kg"), 0.2, 200.0, 75.0);
        energySkateParkSlider2.setModelTicks(new double[]{0.2, 75.0, 200.0});
        energySkateParkSlider2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                EditSkaterPanel.this.setMass(energySkateParkSlider2.getValue());
            }
        });
        final EnergySkateParkSlider energySkateParkSlider3 = new EnergySkateParkSlider(EnergySkateParkStrings.getString("controls.skater.stickiness"), "", 0.01, 5.0, Body.DEFAULT_STICKINESS);
        energySkateParkSlider3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                EditSkaterPanel.this.setStickiness(energySkateParkSlider3.getValue());
            }
        });
        JButton jButton = new JButton(EnergySkateParkStrings.getString("controls.skater.restore-defaults"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditSkaterPanel.this.restoreDefaults();
            }
        });
        final JCheckBox jCheckBox = new JCheckBox("Frictionless Landing", this.isKeepEnergyOnLanding());
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < energySkateParkModule.getEnergySkateParkModel().getNumBodies(); ++i) {
                    energySkateParkModule.getEnergySkateParkModel().getBody(i).setKeepEnergyOnLanding(jCheckBox.isSelected());
                }
            }
        });
        energySkateParkModule.getEnergySkateParkModel().addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void primaryBodyChanged() {
                if (energySkateParkModule.getEnergySkateParkModel().getNumBodies() > 0) {
                    energySkateParkSlider.setValue(energySkateParkModule.getEnergySkateParkModel().getBody(0).getBounciness());
                    energySkateParkSlider2.setValue(energySkateParkModule.getEnergySkateParkModel().getBody(0).getMass());
                    energySkateParkSlider3.setValue(energySkateParkModule.getEnergySkateParkModel().getBody(0).getStickiness());
                }
            }
        });
        this.addControl(energySkateParkSlider);
        this.addControl(energySkateParkSlider2);
        this.addControl(energySkateParkSlider3);
        this.addControl(jButton);
    }

    private void restoreDefaults() {
        this.setMass(this.module.getSkaterCharacter().getMass());
        this.module.setBounciness(0.6);
        this.setStickiness(Body.DEFAULT_STICKINESS);
    }

    private boolean isKeepEnergyOnLanding() {
        int n = 0;
        EnergySkateParkModel energySkateParkModel = this.module.getEnergySkateParkModel();
        if (n < energySkateParkModel.getNumBodies()) {
            Body body = energySkateParkModel.getBody(n);
            return body.isKeepEnergyOnLanding();
        }
        return false;
    }

    private void setMass(double d) {
        EnergySkateParkModel energySkateParkModel = this.module.getEnergySkateParkModel();
        for (int i = 0; i < energySkateParkModel.getNumBodies(); ++i) {
            Body body = energySkateParkModel.getBody(i);
            body.setMass(d);
        }
    }

    private void setStickiness(double d) {
        Body.staticSticky = d;
        for (int i = 0; i < Body.particles.size(); ++i) {
            Body body = (Body)Body.particles.get(i);
            body.setStickiness(Body.staticSticky);
        }
    }

    public void reset() {
        this.restoreDefaults();
        this.setAdvancedControlsVisible(false);
    }
}

